﻿#region License
/* **********************************************************************************
 * Copyright (c) Roman Ivantsov
 * This source code is subject to terms and conditions of the MIT License
 * for Irony. A copy of the license can be found in the License.txt file
 * at the root of this distribution. 
 * By using this source code in any fashion, you are agreeing to be bound by the terms of the 
 * MIT License.
 * You must not remove this notice from this software.
 * **********************************************************************************/
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Irony.Ast;
using Irony.Parsing;

namespace Irony.Interpreter.Ast
{

    public class ResumeNode : AstNode
    {
        resultWithReturnType result;

        public override void Init(AstContext context , ParseTreeNode treeNode)
        {
            base.Init(context , treeNode);

            AsString = "Resume";
        }

        protected override object DoEvaluate(ScriptThread thread)
        {
            thread.CurrentNode = this;  //standard prolog
            result = new resultWithReturnType(null , ReturnType.EXIT_LOOP);
            thread.CurrentNode = Parent; //standard epilog
            return result;
        }//method

    }//class

}//namespace
