﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using WeifenLuo.WinFormsUI.Docking;
using myBuiltInMethod;
using Gecko;

namespace geckoFXbrowser
{

    public delegate void BrowserEventHandler(browserDoc sender , object obj);


    public partial class browserDoc : DockContent
    {
        //event
        public event BrowserEventHandler OnStatusChange;
        public event BrowserEventHandler OnHistoryNewEntry;

        public myBuiltInMethod.BrowserScriptInterfaces weblib;

        public bool b_swicthHighlightByMouse { get; set; }
        public Gecko.GeckoWebBrowser browser { 
            get{ return this.geckoWebBrowser1; }
            set{}
        }
        

        public browserDoc()
        {
            InitializeComponent();
            weblib = new BrowserScriptInterfaces();
            weblib.init(this.geckoWebBrowser1);
        }



        //protected override void OnHandleCreated(EventArgs e)
        //{
        //    base.OnHandleCreated(e);
        //}


        public void Init(BrowserEventHandler Handler_StatusChange)
        {
            OnStatusChange += Handler_StatusChange;
            b_swicthHighlightByMouse = true;
        }



        private void comboBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyCode == Keys.Enter)
            {
                this.geckoWebBrowser1.Navigate(this.comboBox_URL.Text);
                e.SuppressKeyPress = true;
            }
        }





    }
}
