/***********************************************************************
 *
 *	file: mty.c
 *
 *	܂A҂ĉB
 *
 *	$Id: mty.c 192 2008-05-26 06:29:35Z notanpe $
 *
 */

#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/timeb.h>
#include <sys/types.h>

#if defined(WIN32)

#include <windows.h>
#include <process.h>

#elif defined(__GNUC__)

#include <sys/time.h>

#endif

#include "config.h"
#include "cp932.h"
#include "crypt64.h"
#include "desconst.h"
#include "expr_parse.h"
#include "scoreboard.h"
#include "synth.h"
#include "tr64.h"
#include "translate.h"
#include "util.h"
#include "wdict.h"

#if USE_DT
#include "dt4.h"
#endif

/* CRYPT64 Lqq */
static
struct CRYPT64_DESC const *const crypt64_descs[] =
{
  &crypt64_desc,
};

/* NX */
static
struct
{
  unsigned short map[256];
} kcls[8 + 8];

/* gNX */
#define KCLS_DT0 64
#define KCLS_DT1 128
#define KCLS_K2 256

#if USE_DT
/* LpCfNX */
struct DT *kd[8 + 8];

/* CfNX */
struct DT *dtidx[0x100 + 1];
#endif

/* w肳ꂽNXƓĂL[Aclassify s */
void
key_make_map(uint8_t *key, int n)
{
  int i, j;
  unsigned c = kcls[n].map[key[n]];

#if USE_DT
  if (3 <= n && n < 7 && kd[n - 3])
	{
	  /* ̃Pc̕BɃijLN^ */
	  c = kd[n - 3]->c[0];
	  if ((0x81 <= c && c <= 0x9F)
		  || (0xE0 <= c && c <= 0xFC))
		c = KCLS_K2;
	  else
		c = (cp932[256 * key[n]]
			 | cp932[256 * (key[n] ^ 0x80)]);
#if DEBUG>=1
	  printf("*n=%d, key=%02X, cls=%04X\n",
			 n,
			 key[n],
			 c);
#endif
	}
  else if (2 <= n && n < 6 && kd[n - 2])
	{
	  return;
	}
  else if (1 <= n && n < 5 && kd[n - 1])
	{
	  return;
	}
  else if (1 <= n && n < 5 && !kd[n - 1]
		   //&& (c & KCLS_K2)
		   && (c & KCLS_DT1))
	{
	  /* 2EĂ܂ */
#if DEBUG>=1
	  printf("(%d)%02X %02X(%02X:%02X:%02X:%02X)\n",
			 n, key[n - 1], key[n],
			 cp932[(256 * key[n - 1] + key[n])],
			 cp932[(256 * key[n - 1] + key[n]) ^ 0x0080],
			 cp932[(256 * key[n - 1] + key[n]) ^ 0x8000],
			 cp932[(256 * key[n - 1] + key[n]) ^ 0x8080]);
#endif
	  if (n != 1 && n != 2
		  && (cp932[(256 * key[n - 1] + key[n]) ^ 0x0080] & KCLS_DT1))
		key[n] ^= 0x80;
	  else if (n != 2 && n != 3
			   && (cp932[(256 * key[n - 1] + key[n]) ^ 0x8000] & KCLS_DT1))
		key[n - 1] ^= 0x80;
	  else if (n > 3 && (cp932[(256 * key[n - 1] + key[n]) ^ 0x8080] & KCLS_DT1))
		key[n - 1] ^= 0x80, key[n] ^= 0x80;
	  if (cp932[256 * key[n - 1] + key[n]] & KCLS_DT1)
		{
		  for (kd[n - 1] = dtidx[key[n - 1]];
			   kd[n - 1]->c[1] != key[n];
			   kd[n - 1]++)
			assert(kd[n - 1]->c[0] == key[n - 1]);
#if DEBUG>=1
		  printf("(%02X%02X:%02X%02X)%c%c%c%c\n",
				 kd[n - 1]->c[0],
				 kd[n - 1]->c[1],
				 kd[n - 1]->c[2],
				 kd[n - 1]->c[3],
				 kd[n - 1]->c[0],
				 kd[n - 1]->c[1],
				 kd[n - 1]->c[2],
				 kd[n - 1]->c[3]);
#endif
		  return;
		}
	}
  else if (n < 4 && (c & KCLS_DT0) && kd[n] == NULL)
	{
	  /* J^Jiߍ݂܂ */
	  assert(kd[n] == NULL);
#if DEBUG>=1
	  printf("n=%d, key=%02X\n", n, key[n]);
#endif
	  kd[n] = dtidx[key[n]];
	  if (!kd[n]
		  && !(n == 1 || n == 2)
		  && dtidx[key[n] ^ 0x80])
		{
		  key[n] ^= 0x80;
		  kd[n] = dtidx[key[n]];
		}
	  if (kd[n])
		return;
	}
  else
	{
	  kd[n] = NULL;
	}
#endif

  /* Ō̕ class map 𐶐KviV */
  if (n >= 6)
	return;

  for (i = 0; i < 256; i++)
	{
	  unsigned bm = 0;
#if 1
	  if (c & KCLS_K1)
		{
		  if (cp932[256 * key[n] + i] & KCLS_K1)
			bm |= KCLS_K2 | (cp932[256 * key[n] + i] & KCLS_DT1);
		  if (cp932[256 * (key[n] ^ 0x80) + i] & KCLS_K1)
			bm |= KCLS_K2 | (cp932[256 * (key[n] ^ 0x80) + i] & KCLS_DT1);
#if 0
		  bm |= ((cp932[256 * key[n] + i] & KCLS_K1)
				 || (cp932[256 * (key[n] ^ 0x80) + i] & KCLS_K1)
				 ? KCLS_K2 : 0);
#endif
		}
	  if (c & (KCLS_AN | KCLS_KA | KCLS_K2))
		for (j = 0; j < 256; j++)
		{
		  bm |= cp932[256 * i + j] & (KCLS_AN | KCLS_KA | KCLS_K1
									  | KCLS_DT0);
#if 0
		  if (j >= 127 && !(n == 0 || n == 1))
			break;
#endif
		}
	  kcls[n + 1].map[i] = bm;
#endif
	  if (i >= 128 && !(n == 0 || n == 1))
		kcls[n + 1].map[i - 128] |= kcls[n + 1].map[i];
	}

  if (n < 6)
	kcls[n + 1].map[0x00] = kcls[n + 1].map[0x80] = 0;
  if (n == 6)
	kcls[7].map[0x00] |= KCLS_AN;
}

#if USE_DT
unsigned
dt_get(int kdn,
	   int xn,
	   int n,
	   int ch)
{
  int i;
#if DEBUG>=1
  printf("*dt_get(%d)%c%c%c%c(%02X%02X:%02X%02X)->ch=%d",
		 n,
		 kd[kdn]->c[0], kd[kdn]->c[1], kd[kdn]->c[2], kd[kdn]->c[3],
		 kd[kdn]->c[0], kd[kdn]->c[1], kd[kdn]->c[2], kd[kdn]->c[3],
		 ch);
#endif
  /* ܂͐ */
  for (i = 0;
	   kd[kdn][i].c[xn] == kd[kdn]->c[xn];
	   i++)
	;
  assert(i > 0);
  kd[kdn] += ch % i;
#if DEBUG>=1
  printf("/%d\n dt_get:  %c%c%c%c(%02X%02X:%02X%02X)->ch=%d\n",
		 i,
		 kd[kdn]->c[0], kd[kdn]->c[1], kd[kdn]->c[2], kd[kdn]->c[3],
		 kd[kdn]->c[0], kd[kdn]->c[1], kd[kdn]->c[2], kd[kdn]->c[3],
		 ch);
#endif
  return kd[kdn]->c[n];
}
#endif

/* }bv當EăZbg */
unsigned
key_set(int n, unsigned ch)
{
  int cnt = 0, i;

#if USE_DT
  if (3 <= n && n < 7 && kd[n - 3])
	{
	  return dt_get(n - 3, 2, 3, ch);
	  return kd[n - 3]->c[3];
	}
  else if (2 <= n && n < 6 && kd[n - 2])
	{
	  return dt_get(n - 2, 1, 2, ch);
	  return kd[n - 2]->c[2];
	}
  else if (1 <= n && n < 5 && kd[n - 1])
	{
	  return dt_get(n - 1, 0, 1, ch);
	  return kd[n - 1]->c[1];
	}
#endif

#if DEBUG>=3
  if (cnt == 0)
	{
	  printf("n=%d, ch=%d, (n-1)=%02X\n", n, ch, key[n - 1]);
	  int j;
	  for (i = 0; i < 16; i++)
		{
		  printf("map[0x%02X] =", 16 * i);
		  for (j = 0; j < 16; j++)
			printf(" %03X", kcls[n].map[16 * i + j]);
		  printf("\n");
		}
	}
#endif
  for (i = 0; i < 256; i++)
	{
	  if (kcls[n].map[i])
		{
		  if (ch-- == 0)
			return i;
		  cnt++;
		}
	  if (n != 1 && n != 2 && i >= 127)
		break;
	}
  /* Ȃ̂ł؂ */
  assert(cnt > 0);
  ch %= cnt;
  for (i = 0; i < 256; i++)
	if (kcls[n].map[i])
	  {
		if (ch-- == 0)
		  return i;
	  }
  assert(!"not matched");
  return 0;
}

/* bitwise key Zbg */
static
void
key_set64(struct KEY *key64,
		  int n,
		  unsigned k,
		  unsigned vk,
		  unsigned sk)
{
  int i, j;
  if (!((vk | sk) & 0x7F))
	return;

  for (i = 0; i < 7; i++)
	{
	  if (n == 7 && i < N_STRIDE) continue;
	  if (sk & (1 << i))
		{
		  /* Zbg */
		  int o = tr_pc1[n][6 - i] - 1;
		  if (o < 28)
			{
			  assert(o >= 0);
			  for (j = 0; j < N_ALU; j++)
				key64->k[0][0][o].a[j]
				= key64->k[0][1][o].a[j]
				  = -!!(k & (1 << i));
			}
		  else
			{
			  assert(o >= 28);
			  assert(o < 56);
			  for (j = 0; j < N_ALU; j++)
				key64->k[1][0][o - 28].a[j]
				  = key64->k[1][1][o - 28].a[j]
				  = -!!(k & (1 << i));
			}
		}
	  else if (vk & (1 << i))
		{
		  /* ] */
		  int o = tr_pc1[n][6 - i] - 1;
		  if (o < 28)
			{
			  assert(o >= 0);
			  for (j = 0; j < N_ALU; j++)
			  key64->k[0][0][o].a[j]
				= key64->k[0][1][o].a[j]
				= ~key64->k[0][0][o].a[j];
			}
		  else
			{
			  assert(o >= 28);
			  assert(o < 56);
			  for (j = 0; j < N_ALU; j++)
				key64->k[1][0][o - 28].a[j]
				= key64->k[1][1][o - 28].a[j]
				= ~key64->k[1][0][o - 28].a[j];
			}
		}
	}
}

/* w肳ꂽNX̊JnlɃZbg
   Õ̕NXɔ */
int
key_reset(uint8_t *key, int n)
{
  if (n >= 8)
	return 1;
  if (n == 7)
	{
	  key[7] = 0;
	  return 1;
	}

  /* 0-2 ڂ̓_Ɍ߂
	 3 ڈȍ~͏l */
  if (n >= KEY_SHUFFLE_POS)
	key[n] = key_set(n, 0);
  else
	key[n] = key_set(n, rand());

#if DEBUG>=3
  printf("key[%d]=%02X ncls=%04X\n", n, key[n], kcls[n].map[key[n]]);
#endif

  /* ZbgꂽɁAL̕NX߂ */
  key_make_map(key, n);

  return key_reset(key, n + 1);
}

/* w肳ꂽԂ̒ŁAL[ЂƂi߂
   SɃCNgłꍇ true Ԃ */
static
int
key_inc(uint8_t *key, int n)
{
  if (n >= 8)
	return 0;
  else if (n == 7)
	{
	  /* Ō̃oCg */
	  uint8_t o_k = (key[7] + (1 << N_STRIDE)) & 0x7F;
	  if (!o_k)
		return 0;	/* CNgłȂƂ͎֐i߂҂ */

	  /* i߂ */
	  key[7] = o_k;
	  return 1;
	}
  else if (key_inc(key, n + 1)
		   /*
			&& key_inc(n + 1)
		   && key_inc(n + 1)
		   && key_inc(n + 1)*/
		   )
	return 1;

  /* Salt ̓CNgȂ񑩂ɂ */
  if (n == 1 || n == 2)
	return 1;

#if DEBUG>=3
  printf("key_inc(n=%d,ck=%02X)\n", n, key[n]);
#endif

#if USE_DT
  /* ̓CNgĂ񑩂ɂ */
  if (3 <= n && n < 7 && kd[n - 3])
	{
	  if ((key[n - 3] & 0x7F) == ((kd[n - 3] + 1)->c[0] & 0x7F)
		  && (key[n - 2] & 0x7F) == ((kd[n - 3] + 1)->c[1] & 0x7F)
		  && (key[n - 1] & 0x7F) == ((kd[n - 3] + 1)->c[2] & 0x7F))
		{
		  memcpy(&key[n - 3], &(++kd[n - 3])->c[0], 4);
#if DEBUG>=2
		  printf(">dt_get:%c%c%c%c(%02X%02X:%02X%02X)\n",
				 kd[n - 3]->c[0], kd[n - 3]->c[1], kd[n - 3]->c[2], kd[n - 3]->c[3],
				 kd[n - 3]->c[0], kd[n - 3]->c[1], kd[n - 3]->c[2], kd[n - 3]->c[3]);
#endif
		  return 1;
		}
	  else
		{
		  return 0;
		}
	}
  else if (2 <= n && n < 6 && kd[n - 2])
	{
	  if ((key[n - 2] & 0x7F) == ((kd[n - 2] + 1)->c[0] & 0x7F)
		  && (key[n - 1] & 0x7F) == ((kd[n - 2] + 1)->c[1] & 0x7F))
		{
		  memcpy(&key[n - 2], &(++kd[n - 2])->c[0], 4);
#if DEBUG>=2
		  printf(">dt_get:%c%c%c%c(%02X%02X:%02X%02X)\n",
				 kd[n - 2]->c[0], kd[n - 2]->c[1], kd[n - 2]->c[2], kd[n - 2]->c[3],
				 kd[n - 2]->c[0], kd[n - 2]->c[1], kd[n - 2]->c[2], kd[n - 2]->c[3]);
#endif
		  return 1;
		}
	  else
		{
		  return 0;
		}
	  if (kd[n - 2]->c[0] == key[n - 2])
		return 1;
	  else
		return 0;
	}
  else if (1 <= n && n < 5 && kd[n - 1])
	{
	  unsigned c2 = kd[n - 1]->c[0];
	  if ((0x81 <= c2 && c2 <= 0x9F)
		  || (0xE0 <= c2 && c2 <= 0xFC))
		{
		  kd[n - 1] = NULL;
#if 0
		  if (!(n == 1 && n == 2))
			key[n] &= 0x7F;
		  if (!(n == 2 && n == 3))
			key[n - 1] &= 0x7F;
#endif
		  key_make_map(n - 1);
		}
	  else if ((key[n - 1] & 0x7F) == ((kd[n - 1] + 1)->c[0] & 0x7F))
		{
		  memcpy(&key[n - 1], &(++kd[n - 1])->c[0], 4);
#if DEBUG>=2
		  printf(">dt_get:%c%c%c%c(%02X%02X:%02X%02X)\n",
				 kd[n - 1]->c[0], kd[n - 1]->c[1], kd[n - 1]->c[2], kd[n - 1]->c[3],
				 kd[n - 1]->c[0], kd[n - 1]->c[1], kd[n - 1]->c[2], kd[n - 1]->c[3]);
#endif
		  return 1;
		}
	  else
		{
		  return 0;
		}
#if 0
	  if (kd[n - 1]->c[0] == key[n - 1])
		return 1;
	  else
		return 0;
#endif
	}
  else if (n < 4 && kd[n])
	{
	  if (0 && kd[n]->c[0] == key[n])
		return 1;
	  kd[n] = NULL;
#if 0
	  if (!(n == 1 || n == 2))
		key[n] &= 0x7F;
#endif
	}
#endif

  /* ۂɑ₵Ă݂ */
  assert(n >= 3);
  for (;;)
	{
	  if (n <= 3
		  && !(key[n] & 0x80)
		  && kcls[n].map[key[n] ^ 0x80] & (KCLS_DT0))
		{
		  /* pJ^Ji1oCg */
		  key[n] ^= 0x80;
		}
	  else
		{
		  key[n] = (key[n] & 0x7F) + 1;
		  if (key[n] >= 0x80)
			{
			  key[n] = 0xFF;	/* ɓ˓Ȃ */
			  return 0;
			}
		}

	  if (kcls[n].map[key[n]])
		{
		  key_make_map(key, n);
		  key_reset(key, n + 1);
		  return 1;
		}
	}
}

/* SɃZbg
   SaltZbg */
static
void
key_init(uint8_t *key)
{
  int i, j;

#if USE_DT
  /* ACfNXȂ}bvɂ͂߂Ő
	 ̓R[hɕł̂Ƃ */
  for (i = 0; i < dtcnt; i++)
	{
	  unsigned c = dt[i].c[0];

	  assert(dt[i].c[0]
			 && dt[i].c[1]
			 && dt[i].c[2]
			 && dt[i].c[3]);

	  /* BSD Iłɂȕ͎cOȂ珜O */
	  assert((dt[i].c[0] & 0x7F)
			 && (dt[i].c[1] & 0x7F)
			 && (dt[i].c[2] & 0x7F)
			 && (dt[i].c[3] & 0x7F));

	  /* CfNX */
	  if (!dtidx[c])
		dtidx[c] = &dt[i];

	  if ((0x81 <= c && c <= 0x9F)
		  || (0xE0 <= c && c <= 0xFC))
		{
		  /* SpȂ̂ŁA2oCg܂_ŗĂ */
		  cp932[256 * c + dt[i].c[1]] |= KCLS_DT1;
		}
	  else if (0xA1 <= c && c <= 0xDF)
		{
		  /* pJi */
		  for (j = 0; j < 256; j++)
			cp932[256 * c + j] |= KCLS_DT0;
		}
	}
  /* PcAԐl */
  dtidx[0x100] = &dt[i];
#endif

  key[8] = 0;

  /* }bvg */
  for (i = 0; i < 256; i++)
	{
	  unsigned bm = 0;
	  kcls[0].map[i] = 0;
	  for (j = 0; j < 256; j++)
		bm |= cp932[256 * i + j];
	  kcls[0].map[i] = bm & (KCLS_AN | KCLS_KA | KCLS_K1
							 | KCLS_DT0
							 );
	  if (i >= 128)
		kcls[0].map[i - 128] |= kcls[0].map[i];
	}

  key_reset(key, 0);
}

/***************************************************************
 *
 *	ŒL[̐
 *
 *	ꌩ Big Endian ɔΉ̂悤Ɍ邾낤
 *	łɎU΂Ă kludge ɂ
 *	ALU_T  64 rbgłAŖȂB
 *
 */

static
void
key_init_sk(struct KEY *key)
{
  int i, j;
  int o;
  uint64_t m;

  for (i = 5, m = 0xFFFFFFFF00000000ULL;
	   i >= 0;
	   m ^= (m >> (1 << --i)))
	{
	  o = tr_pc1[7][6 - i] - 1;
#if DEBUG>=2
	  printf("%d:%d->%2d: %08X%08X\n",
			 N_Q, i, o,
			 (unsigned)(m >> 32),
			 (unsigned)m);
#endif
	  for (j = 0; j < N_Q; j++)
		if (o < 28)
		  key->k[0][0][o     ].q[j] = key->k[0][1][o     ].q[j] = m;
		else
		  key->k[1][0][o - 28].q[j] = key->k[1][1][o - 28].q[j] = m;
	}
#if N_STRIDE==7
  /* bit 6  Little Endian ƂĈ */
  o = 0;
  assert(tr_pc1[7][0] - 1 == o);
  assert(N_Q == 2);
  key->k[0][0][o].q[0] = key->k[0][1][o].q[0] = 0x0000000000000000ULL;
  key->k[0][0][o].q[1] = key->k[0][1][o].q[1] = 0xFFFFFFFFFFFFFFFFULL;
#endif
}

/***************************************************************
 *
 *	Salt ̃Zbg
 *	Iyh̃ItZbgĉĂ̂Œ
 *
 */

void
set_salt(CODE_T *code,
		 struct CRYPT64_DESC const *desc,
		 uint8_t const *k)
{
  int i, j;

  for (i = 0; i < 2; i++)
	{
	  unsigned s = k[1 + i] & 255;
	  if (s > 'z')
		s = 0;
	  else if (s >= 'a')
		s = s - 'a' + 2 + 10 + 26;
	  else if (s >= 'A')
		s = s - 'A' + 2 + 10;
	  else if (s >= '.')
		s = s - '.';
	  else
		s = 0;

#if DEBUG>=1
	  printf("Salt %d:%3o\n", i, s & 63);
#endif
	  for (j = 0; j < 6; j++)
		{
#if DEBUG>=2
		  //printf("Salt %d:%d %+3d:%+3d",
		  printf("Salt %d:%d %08lX:%08lX",
				 i, j,
				 LSALT(desc, code, 0, i, j,  0),
				 LSALT(desc, code, 0, i, j, 24));
#endif
		if (s & (1 << j))
		  {
			LSALT(desc, code, 0, i, j,  0) = sizeof(WS_T) * (((4 * i + j + 15) & 31) - 16);
			LSALT(desc, code, 0, i, j, 24) = sizeof(WS_T) * (((4 * i + j -  1) & 31) - 16);
		  }
		else
		  {
			LSALT(desc, code, 0, i, j,  0) = sizeof(WS_T) * (((4 * i + j -  1) & 31) - 16);
			LSALT(desc, code, 0, i, j, 24) = sizeof(WS_T) * (((4 * i + j + 15) & 31) - 16);
		  }
		LSALT(desc, code, 0, i, j, 12) = sizeof(WS_T) * (((4 * i + j +  7) & 31) - 16);
		LSALT(desc, code, 0, i, j, 36) = sizeof(WS_T) * (((4 * i + j + 23) & 31) - 16);
#if DEBUG>=2
		//printf(" => %+3d:%+3d\n",
		  printf(" => %08lX:%08lX\n",
				 LSALT(desc, code, 0, i, j,  0),
				 LSALT(desc, code, 0, i, j, 24));
#endif
		}
	}
}

#define USEC_SEC 1000	/* 1b */

static
uint64_t
usec(void)
{
  uint32_t sec, msec;

#if !defined(WIN32)
  struct timeval tv;
  gettimeofday(&tv, NULL);
  sec = tv.tv_sec;
  msec = tv.tv_usec / (1000000 / USEC_SEC);
#else
  struct timeb tm;
  ftime(&tm);
  sec = tm.time;
  msec = tm.millitm / (1000 / USEC_SEC);
#endif

  return (uint64_t)USEC_SEC * sec + msec;
}

static
int
log_printf(FILE *ofp, char const *fmt, ...)
{
  int r;
  va_list ap;
  va_start(ap, fmt);
  vfprintf(stdout, fmt, ap);
  r = vfprintf(ofp, fmt, ap);
  va_end(ap);
  if (r > 0)
	return r;
  perror("log_printf");
  exit(errno);
}

/***************************************************************
 *
 *	CPU capabilities 擾
 *	[XXX] ܂ɂÂvZbT̂Ƃ͍lȂB
 *
 *	a[4] = {EAX,EBX,ECX,EDX}
 *
 */

#if defined(__GNUC__)

#define cpuid(n,a,b,c,d)	\
	asm("cpuid"		\
		: "=a"(a), "=b"(b), "=c"(c), "=d"(d)	\
		: "a"(n))

#elif defined(WIN32)

#define cpuid(n,a,b,c,d)	\
	do {int r[4]; __cpuid(r,n);	\
	(a) = r[0]; (b) = r[1]; (c) = r[2]; (d) = r[3];} while (0)

#endif

static
unsigned
cpuid_getfflags(void)
{
  unsigned a, b, c, d;
  cpuid(1, a, b, c, d);
  return d;
}

static
int
cpuid_issupported(void)
{
  unsigned m = REQUIRED_CAPS;
  return !((cpuid_getfflags() ^ m) & m);
}

/***************************************************************
 *
 *	ob`ppPbg
 *
 */

static
struct PACKET_CRYPT64 *
packet_create(int n,	/* pPbg */
			  int tn,	/* vfɂĕKvȃ[N */
			  uint8_t const *ini_key)
{
  int i;
  int siz;
  void *p;
  intptr_t a = 128;
  struct PACKET_CRYPT64 *pkts;
  assert(IS_POWER2(sizeof(struct PACKET_CRYPT64)));
  assert(n >= 1);

  siz = (a - 1
		 + (n - 1) * sizeof(struct PACKET_CRYPT64)
		 + offsetof(struct PACKET_CRYPT64, param64.hit[tn]));
  p = calloc(siz, 1);
  /* o_킹 */
  pkts = (struct PACKET_CRYPT64 *)(((intptr_t)p
									+ a - 1)
								   & -a);
#if DEBUG>=1
  fprintf(stderr,
		  "packet(n=%d,tn=%d) %d allocated; %p aligned to %p\n",
		  n, tn,
		  siz, p, pkts);
#endif

  /* ̏
	 Rs[ĉ̂́Aɂ
	 ŏIvf̃PcjĂ܂ƂɂȂ̂
	 ǂxvȂx^R[h */
  for (i = 0; i < n; i++)
	{
	  int j, k;

	  /* t[16] ́AZŎgpAall 1 Ă */
	  memset(&pkts[i].param64.t[T_INV], -1, sizeof(SLICE));

	  /* ŒL[̐ */
	  key_init_sk(&pkts[i].key64);

	  /* L[XPW[ɉ߂Ă
		 ] crypt64.S Ŋ悤ɈĂ */
	  for (j = 0; j < 28; j++)
		for (k = 0; k < N_ALU; k++)
		  pkts[i].key64.ks[j].a[k] = sizeof(WS_T) * ks_ls[j];

	  /* Ô߁AŗĂ(sv?) */
	  for (j = 0; j < 8; j++)
		key_set64(&pkts[i].key64, j, pkts[i].uk.key[j] = ini_key[j], 0, 0x7F);
	}

  return pkts;
}

/***************************************************************
 *
 *	thread
 *
 */

#define NQ_CRYPT	64
#define NQ_CMP		32

#if defined(__GNUC__)

typedef int32_t ATOMWORD_T;

#define LOCK_INC(p)	\
asm volatile ("lock incl %0"	\
			  : "=m"(*(p))	\
			  : /*nil*/		\
			  : "memory")

#define LOCK_DEC(p)	\
asm volatile ("lock decl %0"	\
			  : "=m"(*(p))	\
			  : /*nil*/		\
			  : "memory")

#define LOCK_CAS(pd,s,r)	\
({	ATOMWORD_T a;							\
	asm volatile ("lock cmpxchg %2,%1"		\
				  : "=a"(a)					\
				  : "m"(*(pd)), "r"(s), "0"(r)	\
				  : "memory");a;})

#define LOCK_CASP(pd,s,r)	\
({	void *a;								\
	asm volatile ("lock cmpxchg %2,%1"		\
				  : "=a"(a)					\
				  : "m"(*(pd)), "r"(s), "0"(r)	\
				  : "memory");a;})

#elif defined(WIN32)

typedef LONG ATOMWORD_T;

#define LOCK_INC(p) InterlockedIncrement((LONG *)(p))
#define LOCK_DEC(p) InterlockedDecrement((LONG *)(p))
#define LOCK_CAS(pd,s,r) InterlockedCompareExchange((LONG *)(pd), s, r)
#define LOCK_CASP(pd,s,r) InterlockedCompareExchangePointer((PVOID *)(pd), (PVOID)(s), (PVOID)r)

#else
#error "configuration not implemented"
#endif

#if defined(WIN32)

typedef DWORD THREAD_TIMEOUT_T;

#define THREAD_INFINITE INFINITE

typedef HANDLE THREAD_TH_T;
typedef HANDLE THREAD_EV_T;

#define thread_sleep(n) Sleep(n)
#define thread_create(th, proc, arg) {(th) = (HANDLE)_beginthread(proc, 8192, arg);}
#define thread_create_event(ev, f) {(ev) = CreateEvent(NULL, TRUE, f, NULL);}
#define thread_signal_event(ev) SetEvent(ev)
#define thread_clear_event(ev) ResetEvent(ev)
#define thread_get_tid()	GetCurrentThread()
#define thread_set_priority(tid,n)	SetThreadPriority(tid, n)
#define thread_set_affinity(tid,m)	SetThreadAffinityMask(tid, (DWORD_PTR)1 << (m))

static
int
thread_wait_event(THREAD_EV_T ev, DWORD tmo)
{
  DWORD r = WaitForSingleObject(ev, tmo);
  return (r < 0
		  ? r
		  : (r == WAIT_TIMEOUT
			 ? -1
			 : r));
}

#elif defined(_POSIX_SOURCE)

#include <pthread.h>
#include <unistd.h>

typedef int THREAD_TIMEOUT_T;

#define THREAD_INFINITE	INT_MAX

#if defined(THREAD_PRIORITY_BELOW_NOROMAL) || defined(THREAD_PRIORITY_IDLE)
#error "unsupported implementation"
#endif

#define THREAD_PRIORITY_NORMAL	14
#define THREAD_PRIORITY_BELOW_NORMAL	15
#define THREAD_PRIORITY_IDLE	16

typedef pthread_t THREAD_TH_T;
typedef struct
{
  pthread_mutex_t	m;
  pthread_cond_t	c;
  int volatile		f;
} THREAD_EV_T;

#define thread_sleep(n) (usleep(1000 * (n)) != EINVAL || sleep((n) / 1000))
#define thread_create(th, proc, arg) thread_create_p(&(th), proc, arg)
#define thread_create_event(ev, f) thread_create_event_p(&(ev), f)
#define thread_signal_event(ev) thread_set_event_p(&(ev), 1)
#define thread_clear_event(ev) thread_set_event_p(&(ev), 0)
#define thread_wait_event(ev,tmo) thread_wait_event_p(&(ev), tmo)

static
void
thread_create_p(pthread_t *th, NORETURN (*proc)(void *), void *param)
{
  pthread_create(th, NULL, (void *(*)(void *))proc, param);
}

static
void
thread_create_event_p(THREAD_EV_T *ev, int f)
{
  ev->f = f;
  pthread_cond_init(&ev->c, NULL);
  pthread_mutex_init(&ev->m, NULL);
}

static
void
thread_set_event_p(THREAD_EV_T *ev, int f)
{
  pthread_mutex_lock(&ev->m);
  if (ev->f != f)
	{
	  ev->f = f;
	  pthread_cond_broadcast(&ev->c);
	}
  pthread_mutex_unlock(&ev->m);
}

static
int
thread_wait_event_p(THREAD_EV_T *ev, int a_tmo)
{
  int timeout = a_tmo;
  struct timeval now;
  struct timespec tmo;
  int r;

  pthread_mutex_lock(&ev->m);

  /* ݎ^CAEg߂
	 ߂ǂ[ */
  gettimeofday(&now, NULL);
  tmo.tv_sec = now.tv_sec + (timeout / 1000);
  timeout %= 1000;
  timeout *= 1000;
  if (now.tv_usec >= 1000000 - timeout)
	{
	  timeout -= 1000000;
	  tmo.tv_sec++;
	}
  tmo.tv_nsec = 1000 * (now.tv_usec + timeout);
  r = 0;
  while (!ev->f)
	{
	  r = pthread_cond_timedwait(&ev->c, &ev->m, &tmo);
	  if (r == ETIMEDOUT
		  && a_tmo < THREAD_INFINITE)
		break;
	}

  pthread_mutex_unlock(&ev->m);

  return (r == ETIMEDOUT
		  ? (ETIMEDOUT < 0 ? ETIMEDOUT : -1)
		  : 0);
}

#if defined(__linux__)

/* ftHgXPW[O|V[ł
   Dxݒ肵AChXbhNĂ
   낭Ȃ̂ŁÂւ͍̌ۑB */

#include <linux/unistd.h>
_syscall0(pid_t,gettid)

#define thread_get_tid() gettid()

static
int thread_set_affinity(pid_t tid, int i)
{
  cpu_set_t m;
  CPU_ZERO(&m);
  CPU_SET(i, &m);
  return sched_setaffinity(tid, sizeof(m), &m);
}

#else

/* POSIX ł́AXbhPʂ̃XPW[OɉłȂB */

#endif

#else
#error "configuration not supported"
#endif

struct THREAD_PARAM
{
  /* ȉ͋ʏ̃Rs[ */
  CODE_T *code;
  THREAD_EV_T *p_ev_ks_activated;
  ATOMWORD_T volatile *p_nidle;		/* ҂ɓ瑝 */

  /* ȉ̓XbhŗL */
#ifdef thread_set_priority
  THREAD_TH_T th;
  int pri;
#endif
};

static
volatile ATOMWORD_T wp_crypt, rp_crypt;
static
struct PACKET_CRYPT64 *volatile q_crypt[NQ_CRYPT];

static
volatile ATOMWORD_T wp_cmp, rp_cmp;
static
struct PACKET_CRYPT64 *volatile q_cmp[NQ_CMP];

static
uint64_t
thread_avail(void)
{
#if !USE_MT

  return 0x1U;

#elif defined(WIN32)	/* Win32 API */
  DWORD_PTR mask, mask_s;
  if (!GetProcessAffinityMask(GetCurrentProcess(),
							  &mask,
							  &mask_s)
	  || !mask
	  || !mask_s)
	return 0x1U;
#if DEBUG>=1
  fprintf(stderr,
		  "m=%08X s=%08X\n",
		 (unsigned)mask,
		 (unsigned)mask_s);
#endif
  if (popcnt64(mask_s) == 1)
	/* ܂ */;
  else if (mask == mask_s)
	fprintf(stderr,
			"ʏ%d{Ƃ͂悭̂łB\n",
			popcnt64(mask));
  else
	fprintf(stderr,
			"ō͂%g{̗͂łĂƂɂ΂B\n",
			(double)popcnt64(mask) / popcnt64(mask_s));
  return mask;

#elif defined(__linux__)	/* sched.h g */

  int i;
  uint64_t m = 0;
  cpu_set_t am;
  if (sched_getaffinity(getpid(), sizeof(am), &am) < 0)
	return 0x1U;

  for (i = 0; i < 64 && i < CPU_SETSIZE; i++)
	if (CPU_ISSET(i, &am))
	  m |= 1ULL << i;

  return m;
#else

  /* XXX vZbT𒲂׏グĂ */
  return 0x01U;

#endif
}

static
NORETURN
thread_crypt64(void *a_param)
{
  struct THREAD_PARAM *param = a_param;
  CODE_T *code = param->code;
  struct PACKET_CRYPT64 *pkt;
#ifdef thread_set_priority
  THREAD_TH_T th = thread_get_tid();
  thread_set_priority(th, param->pri);
#endif

  for(;;)
	{
	  ATOMWORD_T rp;
	  ATOMWORD_T wp;

	  /* L[vo */
	  for (;;)
		{
		  while ((rp = rp_crypt,
				  WRAP(wp_crypt, NQ_CRYPT) == WRAP(rp, NQ_CRYPT)
				  /*|| q_crypt[WRAP(rp, NQ_CRYPT)] == NULL*/))
			{
			  THREAD_TIMEOUT_T tmo = (WRAP(wp_crypt, NQ_CRYPT) == WRAP(rp, NQ_CRYPT)
									  ? THREAD_INFINITE
									  : 1);
			  int r;

			  /* Q */
			  if (tmo == THREAD_INFINITE)
				{
				  LOCK_INC(param->p_nidle);
				}

			  /* v҂ */
			  r = thread_wait_event(*param->p_ev_ks_activated, tmo);

			  if (tmo == THREAD_INFINITE)
				{
				  /* Nꂽ */
				  LOCK_DEC(param->p_nidle);
				}
			  else if (r >= 0)
				{
				  /* ƐQĂ݂ */
				  thread_sleep(tmo);
				}

			  /* ̗Dx߂
				 (Ou[XgĂ邩) */
#ifdef thread_set_priority
			  if (r >= 0)
				thread_set_priority(th, param->pri);
#endif
			}

		  if (LOCK_CAS(&rp_crypt, rp + 1, rp) != rp)
			continue;
		  rp = WRAP(rp, NQ_CRYPT);
		  break;
		}

	  pkt = q_crypt[rp];
	  assert(pkt != NULL);
	  pkt = LOCK_CASP(&q_crypt[rp], NULL, pkt);
	  assert(pkt != NULL);

	  /* sĂ݂ */
	  CALL_CRYPT64(code, &pkt->key64, &pkt->param64);

	  /* ʂL[ɂ */
	  for (;;)
		{
		  while ((wp = wp_cmp,
				  WRAP(rp_cmp - 1, NQ_CMP) == WRAP(wp, NQ_CMP))
				 || q_cmp[WRAP(wp, NQ_CMP)] != NULL)
			{
#if DEBUG>=1
			  fprintf(stderr,
					  "q_cmp stalled(%d,%d) %p\n",
					  (unsigned)WRAP(wp, NQ_CMP),
					  (unsigned)WRAP(rp_cmp - 1, NQ_CMP),
					  q_cmp[WRAP(wp, NQ_CMP)]);
#endif
			  thread_sleep(1);
			}

		  if (LOCK_CAS(&wp_cmp, wp + 1, wp) != wp)
			continue;
		  wp = WRAP(wp, NQ_CMP);
		  break;
		}

	  pkt = LOCK_CASP(&q_cmp[wp], pkt, NULL);
	  assert(pkt == NULL);
	}
}

/***************************************************************
 *
 *	C[vƂ
 *
 */

int
main(int argc, char *argv[])
{
  int i;
  int mincnt;
  int nblk_hit, nblk_total;
  int nap_hit, nap_total;
  CODE_T *code = NULL;
  off_t code_cmp;
  FILE *ofp;
  FILE *sfp;	/* scoreboard */
  struct ITREE *root_expr;
  uint64_t proc_mask;
  int ks_activated;
  static THREAD_EV_T event_ks_activated;
  static ATOMWORD_T volatile nidle;
  struct THREAD_PARAM *threads = NULL;
  int nthreads;
  int npkts;
  struct PACKET_CRYPT64 *pkts, *pkt_hit;
  uint64_t pkts_vacant;
  int tn;
  int cr;

  /*  */
  uint8_t key[8 + 8];

  int xhash_loaded;

#define UPDATE_INTERVAL 8	/* x\̊Ԋu b */
  struct status {
    uint64_t startTime;	/* Jn ~b */
    uint64_t lastTime;	/* Ōɕ\ ~b */
    uint64_t loop;		/*  */
    uint64_t lastloop;	/* Ōɕ\ loop */
  } status;
  uint64_t curTime;
  uint32_t upd_int = 0;
/*
 ϑx (trips/s) * UPDATE_INTERVAL  UINT32_MAX 𒴂ƔB
 UINT32_MAX = 4294967295, ϑx = 100Mtrips/s ȂA
 4294967295 / (100 * 1000 * 1000) = 42.949 b܂ŁBia
 LOOP_FACTOR ϑx\΁AقڎwԊuɂȂB
 LOOP_FACTOR * UINT32_MAX + LOOP_FACOTR ƃI[o[t[B
 */

  if (!cpuid_issupported())
	{
	  fprintf(stderr, "̊ő点邱Ƃz肳Ă܂B\n");
	  exit(1);
	}

  assert((1 << N_STRIDE) == N_ALU * ALU_BITS);

  /* ^Qǂݍ */
  root_expr = expr_parse("target.txt");

  /* R[h𐶐EWJ
	 N\Xbhɉ
	 R[hς */
  sfp = scoreboard_open();
  fwrite(crypt64_descs[0]->pro, 1, crypt64_descs[0]->cmp_pro - crypt64_descs[0]->pro, sfp);	/* prologue & RA[v */
  proc_mask = thread_avail();
  if (proc_mask == 1U)
	{
	  /* single */
	  npkts = 1;
	  pkts_vacant = 1;
	  code_cmp = 0;
	}
  else
	{
	  /* multi */
	  fwrite(crypt64_descs[0]->ep, 1, crypt64_descs[0]->ep_end - crypt64_descs[0]->ep, sfp);	/* epilogue */

	  /* r݂̂𐶐(O) */
	  code_cmp = ftell(sfp);
	  fseek(sfp, (-code_cmp) & 63, SEEK_CUR);
	  code_cmp = ftell(sfp);
	  fwrite(crypt64_descs[0]->pro, 1, crypt64_descs[0]->crypt - crypt64_descs[0]->pro, sfp);	/* prologue */
	  npkts = 64;
	  pkts_vacant = (uint64_t)-1;	/* (1 << 64) - 1 vZȂ */
	}

  /* r𐶐 */
  fwrite(crypt64_descs[0]->cmp_pro, 1, crypt64_descs[0]->cmp_ep - crypt64_descs[0]->cmp_pro, sfp);	/* r폀 */
  tn = synth_synthesize(sfp, root_expr);
  fwrite(crypt64_descs[0]->cmp_ep, 1, crypt64_descs[0]->ep_end - crypt64_descs[0]->cmp_ep, sfp);	/* epilogue */

  /* R[hɓ\t */
  code = scoreboard_map(sfp);

  /* L[̏ */
  srand(time(NULL));
  key_init(key);
  set_salt(code, crypt64_descs[0], key);

  /* ZpPbg쐬 */
  pkts = packet_create(npkts, tn, key);
  pkt_hit = &pkts[npkts - 1];

  /* ʎY */
  thread_create_event(event_ks_activated, 1);
  ks_activated = 1;
  nthreads = 0;
  if (code_cmp)
	{
	  THREAD_TH_T h;
	  int ots = -1;
	  threads = calloc(2 * popcnt64(proc_mask), sizeof(*threads));
	  for (i = 0; proc_mask; i++, proc_mask >>= 1)
		if (proc_mask & 1)
		  {
			if (ots < 0)
			  {
				/* g̃XPW[O
				   [[ñAv͒߂ɐݒ肷̂g() */
#ifdef WIN32
				h = GetCurrentProcess();
				SetPriorityClass(h, BELOW_NORMAL_PRIORITY_CLASS);
#endif
#if defined(thread_set_priority)
				/* ŠԂ߂܂ */
				threads[nthreads].code = code;
				threads[nthreads].p_ev_ks_activated = &event_ks_activated;
				threads[nthreads].p_nidle = &nidle;
				threads[nthreads].pri = THREAD_PRIORITY_IDLE;
				thread_create(h, thread_crypt64, &threads[nthreads]);
				threads[nthreads].th = h;
				nthreads++;
#endif
				if (!code_cmp)
				  break;

				/* g̎c̐ݒAƂł */
				ots = i;
			  }
			else
			  {
				/* Xbh́A߂̗DxŁB */
				threads[nthreads].code = code;
				threads[nthreads].p_ev_ks_activated = &event_ks_activated;
				threads[nthreads].p_nidle = &nidle;
#ifdef thread_set_priority
				threads[nthreads].pri = THREAD_PRIORITY_BELOW_NORMAL;
#endif
				thread_create(h, thread_crypt64, &threads[nthreads]);
#ifdef thread_set_priority
				threads[nthreads].th = h;
#endif
#ifdef thread_get_tid
				thread_set_affinity(h, i);
#endif
				nthreads++;
			  }
		  }
#ifdef thread_get_tid
	  if (ots)
		thread_set_affinity(thread_get_tid(), ots);
#endif
	}

  if ((ofp = fopen("log.txt", "at")) == NULL)
	{
	  perror("log.txt");
	  return errno;
	}

  setvbuf(ofp, NULL, _IONBF, BUFSIZ);	/* XXX MSVCRT ł _IOLBF Ғʂɓ삵Ȃ */

  mincnt = 0x7FFFFFFF;
  nblk_hit = nblk_total = 0;
  nap_hit = nap_total = 0;
  cr = 0;
  memset( &status, 0, sizeof( struct status ) );
  status.startTime = status.lastTime = usec();
  /* T[v */
  for (;;)
	{
	  struct PACKET_CRYPT64 *pkt_c;
	  uint64_t cnt;
	  int cnt1, cnt2;
	  int k, kk;

	  /* r(may be NULL)
		 ɃL[o */
	  pkt_c = q_cmp[WRAP(rp_cmp, NQ_CMP)];
	  if (pkt_c != NULL && WRAP(rp_cmp, NQ_CMP) != WRAP(wp_cmp, NQ_CMP))
		{
		  pkt_c = LOCK_CASP(&q_cmp[WRAP(rp_cmp, NQ_CMP)], NULL, pkt_c);
		  assert(pkt_c != NULL);
		  LOCK_INC(&rp_cmp);

		  /* pPbg vacant ɉ񂵂Ă */
		  pkts_vacant |= 1ULL << (pkt_c - pkts);
		}

	  /* Salt`FW҂ */
	  if (!ks_activated)
		{
		  ATOMWORD_T rp;

		  if (pkt_c == NULL)
			{
			  if ((rp = rp_crypt,
				   WRAP(rp, NQ_CRYPT) != WRAP(wp_crypt, NQ_CRYPT))
				  && LOCK_CAS(&rp_crypt, rp + 1, rp) == rp)
				{
				  /* !ks_activate Ԃł́AvL[ɂ */
				  rp = WRAP(rp, NQ_CRYPT);
				  pkt_c = q_crypt[rp];
				  assert(pkt_c != NULL);
				  pkt_c = LOCK_CASP(&q_crypt[rp], NULL, pkt_c);
				  assert(pkt_c != NULL);
				  assert(pkt_c != pkt_hit);
				  CALL_CRYPT64(code,
							   &pkt_c->key64,
							   &pkt_c->param64);

				  /* pPbg vacant ɉ񂵂Ă */
				  pkts_vacant |= 1ULL << (pkt_c - pkts);
				}
			  else
				{
				  /* ͂肷邱ƂȂ̂ł܂Ɖ߂ */
				  if (nidle != nthreads)
					thread_sleep(1);
				}
			}

		  if (nidle == nthreads)
			{
			  assert(WRAP(rp_crypt, NQ_CRYPT) == WRAP(wp_crypt, NQ_CRYPT));
			  /* Salt `FW\ */
			  set_salt(code, crypt64_descs[0], key);
			  if (nthreads)
				thread_signal_event(event_ks_activated);
			  ks_activated = 1;
			}
		}

	  /* L[ɂ݂܂ */
	  if (!ks_activated)
		{
		  /* o^Ȃ */
		  ;
		}
	  else for (i = npkts - 1; i >= 0; i--)
		if (pkts_vacant & (1ULL << i))
		  {
			int j;

			if (i == npkts - 1)
			  {
				/* OiŁA񂩂
				   ʂĂAȂ */
				if (pkt_c != NULL)
				  continue;
			  }
			else
			  {
				/* OiŎo΂
				   ́Ad */
				if (&pkts[i] == pkt_c)
				  continue;

				/* queue full ̏ꍇ͌ */
				if (WRAP(wp_crypt, NQ_CRYPT) == WRAP(rp_crypt - 16, NQ_CRYPT)	/* XXX 16 ͂ĂƂ */
					|| q_crypt[WRAP(wp_crypt, NQ_CRYPT)] != NULL)
				  break;
			  }

			/* ̃Zbg */
			for (j = 0; j < 8; j++)
			  {
				key_set64(&pkts[i].key64, j, key[j], key[j] ^ pkts[i].uk.key[j], 0);
				pkts[i].uk.key[j] = key[j];
			  }

			if (i == npkts - 1)
			  {
				/* i CRYPT64->CMP */
				assert(pkt_c == NULL);
				pkt_c = &pkts[i];
				assert(pkt_c == pkt_hit);
			  }
			else
			  {
				/* L[ɂ */
				while (LOCK_CASP(&q_crypt[WRAP(wp_crypt, NQ_CRYPT)], &pkts[i], NULL) != NULL)
				  {
					/* ݌v͂ɗȂ */
#if DEBUG>=1
					fprintf(stderr,
							"[XXX] q_crypt Ă̂͒N? (rp=%3d, wp=%3d, v=%08X%08X)\n",
							(unsigned)WRAP(rp_crypt, NQ_CRYPT),
							(unsigned)WRAP(wp_crypt, NQ_CRYPT),
							(unsigned)(pkts_vacant >> 32),
							(unsigned)pkts_vacant);
					thread_sleep(1000);
#endif
					thread_sleep(1);
				  }
				LOCK_INC(&wp_crypt);
				pkts_vacant ^= 1ULL << i;
				assert(!(pkts_vacant & (1ULL << i)));	/*  */
			  }

			/* ͂ȂƂɈړ! */
			assert(ks_activated);
			if (!key_inc(key, 6) && !key_inc(key, KEY_SHUFFLE_POS))
			  {
				/* ̃Vbt
				   q_crypt J܂ŁAset_salt() ͂łȂ */
#if DEBUG>=1
				fprintf(stderr, "********************************SHUFFLE!\n");
#endif
				if (nthreads)
				  thread_clear_event(event_ks_activated);
				key_reset(key, 0);

				/* L[̌J܂ŃAChԂ */
				ks_activated = 0;

				/* Xbhu[Xgĉ */
#ifdef thread_set_priority
				for (j = 0; j < nthreads; j++)
				  {
					assert(threads != NULL);
					thread_set_priority(threads[j].th, THREAD_PRIORITY_NORMAL);
				  }
#endif

				/* [vs͂͂sv */
				break;
			  }
		  }

	  /* 邱ƂȂȂĂꍇ */
	  if (pkt_c == NULL)
		{
		  assert(!ks_activated);
		  continue;
		}

	  /* Ă!
		 LR ́ATuW[ōsׂ
		 FASTCALL ɏĂяô߁A
		 zg͂낢냌WX^j󂳂nYcȂ񂾂B */
	  if (pkt_c != pkt_hit)
		{
		  assert(code_cmp != 0);
		  cnt = CALL_CMP64(code + code_cmp,
						   pkt_hit->param64.hit,
						   pkt_c->param64.lr);
		}
	  else
		{
		  /* 悤₭Xbhŉ񂹂 */
		  cnt = CALL_CRYPT64(code,
							 &pkt_c->key64,
							 &pkt_c->param64);
		  if (code_cmp)
			cnt = CALL_CMP64(code + code_cmp,
							 pkt_c->param64.hit,
							 pkt_c->param64.lr);
		}

#if DEBUG>=1
	  cnt2 = (int32_t)(cnt >> 32);
	  cnt1 = (int32_t)cnt;
	  if (mincnt > cnt1 && cnt1 > 0)
		{
		  mincnt = cnt1;
		  if (cr)
			fprintf(stderr, "\n");
		  cr = 0;
		  fprintf(stderr, "cycle=%6d/%6d\n", cnt1, cnt2);
		}
#endif

	  /* qbgƂ̏
		 key  lr  pkt_c 
		 v pkt_hit ɓĂnY */
	  xhash_loaded = 0;
	  for (kk = 0; kk < N_ALU; kk++)
		{
		  ALU_T t;
		  if (!(kk & (N_ALU / N_Q - 1)))
			nblk_total++, xhash_loaded = 0;

		  t = pkt_hit->param64.hit[HIT_ANY].a[kk];
		  if (!t)
			continue;

		  nap_total += ALU_BITS;

		  for (k = 0; k < ALU_BITS; k++)
			{
			  static uint64_t xhash[64];
			  char hash[16];
			  uint8_t buf[32];
			  struct timeb tb;
			  struct tm *plt;

			  if (!(t & ((ALU_T)1 << k)))
				continue;

			  nap_hit++;

			  /* ]u */
			  if (!xhash_loaded)
				{
				  nblk_hit++;
				  CALL_TR64(&pkt_c->param64.lr[0][0].q[kk / (N_ALU / N_Q)], xhash);
				  xhash_loaded = 1;
				}

			  /* 𒲂ׂ */
			  if (!((pkt_hit->param64.hit[HIT_BOOL].a[kk] & ((ALU_T)1 << k))
					|| wdict_ishit(pkt_hit->param64.hit,
								   kk, k,
								   xhash[(ALU_BITS * kk + k) & 0x3F])))
				continue;

			  /* qbg; ƂƈႤ */
			  ftime(&tb);
			  plt = localtime(&tb.time);

			  for (i = 1; i < 11; i++)
				{
				  unsigned c = 0;
				  c = (xhash[(ALU_BITS * kk + k) & 63] >> (6 * (i - 1))) & 0x3F;	/* XXX */
				  hash[i - 1] = C64[c];
				}
			  hash[10] = 0;

			  memcpy(buf, pkt_c->uk.key, 8);
			  buf[8] = buf[9] = 0;
			  buf[7] = (buf[7] & -(1 << N_STRIDE) & 0x7F) + ALU_BITS * kk + k;
			  if (translate(buf, 0, 1))
				{
				  if (cr)
					fprintf(stderr, "\n");
				  cr = 0;
#if DEBUG>=1
				  fprintf(stderr, "%3d:", pkt_c - pkts);
#endif
				  log_printf(ofp,
							 "%s #%s"
							 "\t%04d/%02d/%02d %02d:%02d:%02d.%03d"
							 "\t(%02X %02X %02X %02X %02X %02X %02X %02X/%02X)\n",
							 hash,
							 buf,
							 plt->tm_year + 1900,
							 plt->tm_mon + 1,
							 plt->tm_mday,
							 plt->tm_hour,
							 plt->tm_min,
							 plt->tm_sec,
							 tb.millitm,
							 buf[0], buf[1], buf[2], buf[3],
							 buf[4], buf[5], buf[6], buf[7],
							 buf[8]);
				}
			  else
				{
#if DEBUG>=1
				  if (cr)
					fprintf(stderr, "\n");
				  cr = 0;
				  fprintf(stderr, "%3d:", pkt_c - pkts);
				  log_printf(ofp,
							 "%s            (%02X %02X %02X %02X %02X %02X %02X %02X   )\n",
							 hash,
							 buf[0], buf[1], buf[2], buf[3],
							 buf[4], buf[5], buf[6], buf[7]);
#endif
				}
			}
		}

	  /* xv */
	  status.loop += N_ALU * ALU_BITS;
	  if (status.loop>= status.lastloop + upd_int
		  && (curTime = usec()) != status.lastTime)
		{
		  uint64_t diffTime;
		  int a, b, c;

		  /* ʎZ(P ktrips/sec) */
		  diffTime = curTime - status.startTime;
		  a = status.loop / ((1000 / USEC_SEC) * diffTime);

		  /* (P trips/sec) */
		  diffTime = curTime - status.lastTime;
		  b = USEC_SEC * (status.loop - status.lastloop) / diffTime;

		  /* \ */
		  c = UPDATE_INTERVAL * b;

		  /* オȂǁA덷 upd_int Ƃ
			 ȂS␳ 1 b(==b)ÂʂB */
		  upd_int = (upd_int + b < c
					 ? upd_int + b
					 : c);

		  status.lastTime = curTime;
		  status.lastloop = status.loop;
#if DEBUG>=1
		  fprintf(stderr,
			  "%5d/%5d(%3d%%)",
			  nblk_hit, nblk_total, 100 * nblk_hit / nblk_total);
		  nblk_hit = nblk_total = 0;
		  if (nap_total)
			fprintf(stderr,
				"  %5d/%5d(%3d%%)",
				nap_hit, nap_total, 100 * nap_hit / nap_total);
		  else
			fprintf(stderr,
					"  -----/-----(---%%)");
		  nap_hit = nap_total = 0;
#endif
		  fprintf( stderr,
			"%6dktrips/s [%6d.%03dktrips/s]\r",
			a, b / 1000, b % 1000 );
		  cr++;
		}
	}

  return 0;
}

/*
 *	Local Variables:
 *		tab-width:	4
 *	End:
 *
 * EOF */
