/***********************************************************************
 *
 *	file: config.h
 *
 *	$Id: config.h 192 2008-05-26 06:29:35Z notanpe $
 *
 */

#ifndef CONFIG_H__
#define CONFIG_H__

/* ͂̌XbhN */
#define USE_MT 1

#define USE_DT 0

/* V[PVT[`p臒l
   2004łɊÂ̂ł 3 */
#define KEY_SHUFFLE_POS	4

#include "mtytypes.h"

/****************************************************************
 *
 *	USE_MMX ... i686-mmx
 *
 *	P6, K7 ȑÕA[LeN`ł͂𗘗pׂB
 *
 */

#if defined(USE_MMX)

#define N_STRIDE 6
typedef uint64_t	WS_T;
typedef uint32_t	ALU_T;
typedef int8_t		SALTOFS_T;

#define REQUIRED_CAPS	(CPUID_CMOV | CPUID_MMX)

#define CRYPT64_CLOBBER	/* "%ecx", "%edx", */

/****************************************************************
 *
 *	USE_64 ... x64-alu
 *
 *	AMD64 K8(Opteron, Athlon64)ł́AXMMALU̕B
 *	64-bit ALU ɑ΂ 3-issue.
 *
 */

#elif defined(USE_64)	/* 64-bit ALU */

#define N_STRIDE 6
typedef uint64_t	WS_T;
typedef uint64_t	ALU_T;
typedef int8_t		SALTOFS_T;

#define REQUIRED_CAPS	(CPUID_CMOV)

#define CRYPT64_CLOBBER /* "%rcx", "%rdx",*/ "%r8", "%r9",

/****************************************************************
 *
 *	USE_64_XMM ... x64-xmm
 *
 *	Core2 Microarchitecture ́A
 *	128-bit XMM Z悭łB
 *
 */

#elif defined(USE_64_XMM)

#define N_STRIDE 7
typedef DQWORD_T	WS_T;
typedef uint64_t	ALU_T;
typedef int32_t		SALTOFS_T;

#define REQUIRED_CAPS	(CPUID_CMOV | CPUID_SSE | CPUID_SSE2)

#define CRYPT64_CLOBBER /* "%rcx", "%rdx",*/
				   
/****************************************************************
 *
 *	USE_XMM ... default
 *
 *	SSE2ΉƌĂA[LeN`ł͑ÓB
 *
 */

#else	/* XMM */

#define N_STRIDE 7
typedef DQWORD_T	WS_T;
typedef uint32_t	ALU_T;
typedef int32_t		SALTOFS_T;

#define REQUIRED_CAPS	(CPUID_CMOV | CPUID_MMX | CPUID_SSE | CPUID_SSE2)

#define CRYPT64_CLOBBER /* "%ecx", "%edx", */

#endif

#include <limits.h>
#define ALU_BITS	(CHAR_BIT * sizeof(ALU_T))

#endif /* CONFIG_H__ */

/*
 *	Local Variables:
 *		tab-width:	4
 *	End:
 *
 * EOF */
