/**********************************************************-*-verilog-*-
 *
 *	8AȏToComparator
 *
 *	$Id: cmp8.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module cmp8(blk,
			matched);
	input [0:65] 	blk;
	output 			matched;

	wire [5:0] 		c0, c1, c2, c3, c4, c5, c6, c7, c8, c9;
	wire 			m6;

	assign 			{c0, c1, c2, c3, c4,
					 c5, c6, c7, c8, c9} = blk[6:65];

	assign 			m6 = (c2 == c3
						  && c3 == c4
						  && c4 == c5
						  && c5 == c6
						  && c6 == c7);

	assign 			matched = ((c0 == c1 && c1 == c2 && m6)
							   || (c1 == c2 && m6 && c7 == c8)
							   || (m6 && c7 == c8 && c8 == c9));
endmodule

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
