////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) Microsoft Corporation.  All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _RX62N_EDMAC_LWIP_H_1
#define _RX62N_EDMAC_LWIP_H_1 1

#include <tinyhal.h>
#include "RX62N_EDMAC_LWIP_adapter.h"
#include "types.h"
#include "..\iodefine.h"

//////////////////////////////////////////////////////////////////////////////
// RX62N_EDMAC_LWIP
//
BOOL RX62N_EDMAC_LWIP_open ( struct netif *pNetIf );
void RX62N_EDMAC_LWIP_close ( struct netif *pNetIf );
void RX62N_EDMAC_LWIP_interrupt ( struct netif *pNetIf );
err_t RX62N_EDMAC_LWIP_xmit ( struct netif *pNetIf, struct pbuf *pPBuf );
void RX62N_EDMAC_LWIP_recv ( struct netif *pNetIf );
void RX62N_EDMAC_LWIP_Init();
void RX62N_EDMAC_LWIP_setpins ( BOOL mode );
void RX62N_EDMAC_interrupt( void *param );
BOOL RX62N_EDMAC_LWIP_GetLinkStatus(void);
BOOL RX62N_EDMAC_LWIP_AutoNegotiate();
void RX62N_EDMAC_LWIP_Init ();
BOOL RX62N_EDMAC_LWIP_GetLinkSpeed( BOOL applySetting );




#define LOOP_100us          2000

#define RX62NC_PHY_ADDR    31
// ??? Is that right size????
#define RX62N_EDMAC_MAX_FRAME_SIZE 2048


enum link{
    NEGO_FAIL = 0, HALF_10M, FULL_10M, HALF_TX, FULL_TX,
};

enum init_mode{
    HALF_10T_SET            = 0,
    FULL_10T_SET            = 1,
    HALF_100TX_SET          = 2,
    FULL_100TX_SET          = 3,
    HALF_100TX_AUTONEGO_SET = 4,
    POWERDOWN_SET           = 6,
    FULL_100TX_AUTONEGO_SET = 7,
};


/* RX62N CONFIGURATION */
#define     CFG_NUM_RX62N            NETWORK_INTERFACE_COUNT                                    
#define     CFG_MAX_PACKETS_PROCESSED   10       /* The maximum number of packets to process in one shot */

#define     RX62N_FULL_DUPLEX        0           /* DON'T CHANGE adds support for full duplex */
#define     RX62N_MAXIMUM_FRAME_SIZE 1530        /* maximum frame sizes to be transmitted */
                                    
//Ether
static unsigned short   gmac_address[3] = {0x1A0E, 0x0FF8, 0x06F3};

#define ACT     0x80000000
#define DL      0x40000000
#define FP1     0x20000000
#define FP0     0x10000000
#define FE      0x08000000

#define RFOVER  0x00000200
#define RMAF    0x00000080
#define RRF     0x00000010
#define RTLF    0x00000008
#define RTSF    0x00000004
#define PRE     0x00000002
#define CERF    0x00000001

#define ITF     0x00000010
#define CND     0x00000008
#define DLC     0x00000004
#define CD      0x00000002
#define TRO     0x00000001

/****************************************************/

static unsigned long HEAP_TOP; // for memory alloc

/* CCR Values */
#define CCR_CF                  0x08
#define CCR_CB                  0x04
#define CCR_WT                  0x02
#define CCR_CE                  0x01

/*//////////////////////////////////////////////////////////////////////////*/
/* Status register bits*/
/*//////////////////////////////////////////////////////////////////////////*/
#define IMASK 0x000000f0L /* interrupt mask level field*/
#define SR_BL BIT(28)   /* exception/interrupt block bit*/

#define BASIC_MODE_CONTROL_REG              (0x0000)
#define BASIC_MODE_STATUS_REG               (0x0001)
#define      STATUS_LINK_STATUS                 0x4  
#define PHY_IDENTIFIER1_REG                 (0x0002)
#define PHY_IDENTIFIER2_REG                 (0x0003)
#define AN_ADVERTISEMENT_REG                (0x0004)
#define AN_LINK_PARTNER_ABILITY_REG         (0x0005)
#define AN_EXPANSION_REG                    (0x0006)
#define NWAY_SETUP_REG                      (0x0010)
#define LPBACK_BYPASS_RX_ERR_MASK_REG       (0x0011)
#define RX_ER_COUNTER_REG                   (0x0012)
#define BPS10M_NETIF_CONFIGURATION_REG      (0x0013)
#define PHY1_1_REG                          (0x0014)
#define PHY1_2_REG                          (0x0015)
#define PHY2_REG                            (0x0016)
#define TWISTER1_REG                        (0x0017)
#define TWISTER2_REG                        (0x0018)
#define TEST_REG                            (0x0019)

#define PHY_ST      (0x0001)
#define PHY_READ    (0x0002)
#define PHY_WRITE   (0x0001)
#define PHY_ADDR    (0x0001)


#define INVALID_PHY_ADDRESS 0xFF

static unsigned short   rtl8201bl_data[17];
static unsigned short   phy_addr[17] =
{
    BASIC_MODE_CONTROL_REG,
    BASIC_MODE_STATUS_REG,
    PHY_IDENTIFIER1_REG,
    PHY_IDENTIFIER2_REG,
    AN_ADVERTISEMENT_REG,
    AN_LINK_PARTNER_ABILITY_REG,
    AN_EXPANSION_REG,
    NWAY_SETUP_REG,
    LPBACK_BYPASS_RX_ERR_MASK_REG,
    RX_ER_COUNTER_REG,
    BPS10M_NETIF_CONFIGURATION_REG,
    PHY1_1_REG,
    PHY1_2_REG,
    PHY2_REG,
    TWISTER1_REG,
    TWISTER2_REG,
    TEST_REG
};

#define ETHERC_MDI          0x08
#define ETHERC_MDI_SRB      3       // Shift Right Bits by 3
#define ETHERC_MDO_WRITE    0x04
#define ETHERC_MDO_SLB      2       // Shift Left Bits by 2
#define ETHERC_MMD          0x02
#define ETHERC_MDC          0x01


///////////////////////////////////////////////////////////////////////////////
// PHY management
///////////////////////////////////////////////////////////////////////////////

#define OPWRITE 0x01
#define OPREAD 0x02

///////////////////////////////////////////////////////////////////////////////
// PHY Registers
///////////////////////////////////////////////////////////////////////////////

#define PHY_CTRL    0x00        // PHY Control
#define PHY_STAT    0x01        // PHY Status
#define PHY_ID1     0x02        // PHY ID # 1
#define PHY_ID2     0x03        // PHY ID # 2
#define PHY_ANEGAD  0x04        // Auto Negotiation Advertisement
#define PHY_ANEGREC 0x05        // Auto Negotiation Remote End Capacity
#define PHY_CFG1    0x10        // Configuration 1
#define PHY_CFG2    0x11        // Configuration 2
#define PHY_STATOUT 0x12        // Status Output
#define PHY_MASK    0x13        // Mask

//static char *(ptr_rxbuf[ENTRY]);        /* receive data buffer */
//static char *(ptr_txbuf[ENTRY]);        /* transmit data buffer */


static void Init_Malloc                 (                                               );
static int* Malloc_Buf                  ( int size                                      );
static int  Ether_PFC_Init              (                                               );
static int  Ether_Init                  (                                               );
static unsigned short Ether_Reg_Read    ( unsigned short reg_addr                       );
static void Ether_Reg_Write             ( unsigned short reg_addr, unsigned short data  );
static void Write_MDO                   ( vuint8_t channel, unsigned MGMTData           );
static vuint32_t Read_MDI               ( vuint8_t channel, unsigned MGMTData           );
static vuint16_t PHYAccess              ( vuint8_t channel, vuint8_t PHYAdd, vuint8_t RegAdd, vuint8_t OPCode, vuint16_t wData  );
static void Flush_All                   ( struct netif *pNetIf                                  );

// --//



/////////////////////////////// EDMAC define ////////////////////////////
// Callback functions type
typedef void (*EMAC_TxCallback)(unsigned int status);
typedef void (*EMAC_RxCallback)(unsigned int status);
typedef void (*EMAC_WakeupCallback)(void);

// Number of buffer for RX
#define RX_BUFFERS  16
// Number of buffer for TX
#define TX_BUFFERS  4

// Buffer Size
#define EMAC_RX_UNITSIZE            512     /// Fixed size for RX buffer
#define EMAC_TX_UNITSIZE            512    /// Size for ETH frame length

// Definitions used by EMAC Descriptors
#define EMAC_ADDRESS_MASK   ((UINT32)0xFFFFFFFC)
#define EMAC_LENGTH_FRAME   ((UINT32)0x0FFF)    /// Length of frame mask

// Describes the type and attribute of Transfer descriptor.
typedef struct _EmacTDescriptor {
    //UINT32 addr;
    UINT32 status;
    UINT16 TDRBL;
    UINT16 RDL;
    char* TRBA;
} EmacTDescriptor, *PEmacTDescriptor;

typedef struct {
    PEmacTDescriptor td[RX_BUFFERS];
    UINT16 idx;
} RxTd;

typedef struct {
    PEmacTDescriptor td[TX_BUFFERS];
    EMAC_TxCallback txCb[TX_BUFFERS];    /// Callback function to be invoked once TD has been processed
    EMAC_WakeupCallback wakeupCb;        /// Callback function to be invoked once several TD have been released
    UINT16 wakeupThreshold; /// Number of free TD before wakeupCb is invoked
    UINT16 head;            /// Circular buffer head pointer incremented by the upper layer (buffer to be sent)
    UINT16 tail;            /// Circular buffer head pointer incremented by the IT handler (buffer sent)
} TxTd;

// The MAC can support frame lengths up to 1536 bytes.
#define EMAC_FRAME_LENTGH_MAX       1536

//-----------------------------------------------------------------------------
// Circular buffer management
//-----------------------------------------------------------------------------
// Return count in buffer
#define CIRC_CNT(head,tail,size) (((head) - (tail)) & ((size)-1))

// Return space available, 0..size-1
// We always leave one free char as a completely full buffer 
// has head == tail, which is the same as empty
#define CIRC_SPACE(head,tail,size) CIRC_CNT((tail),((head)+1),(size))

// Return count up to the end of the buffer.  
// Carefully avoid accessing head and tail more than once,
// so they can change underneath us without returning inconsistent results
#define CIRC_CNT_TO_END(head,tail,size) \
   ({int end = (size) - (tail); \
     int n = ((head) + end) & ((size)-1); \
     n < end ? n : end;})

// Return space available up to the end of the buffer
#define CIRC_SPACE_TO_END(head,tail,size) \
   ({int end = (size) - 1 - (head); \
     int n = (end + (tail)) & ((size)-1); \
     n <= end ? n : end+1;})

// Increment head or tail
#define CIRC_INC(headortail,size) \
        headortail++;             \
        if(headortail >= size) {  \
            headortail = 0;       \
        }

#define CIRC_EMPTY(circ)     ((circ)->head == (circ)->tail)
#define CIRC_CLEAR(circ)     ((circ)->head = (circ)->tail = 0)

//////////////////////// end ///////////////////////////////////////////
    
#endif

