<?php
// $Id: search.php,v 1.3 2005/11/03 08:39:54 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //

include 'header.php';
require_once './class/search.class.php';
include XOOPS_ROOT_PATH.'/header.php';

$xoopsOption['template_main']= 'newbb_search.html';
$xoopsTpl->assign("lang_keywords", _MD_KEYWORDS);
$xoopsTpl->assign("lang_searchany", _MD_SEARCHANY);
$xoopsTpl->assign("lang_searchall", _MD_SEARCHALL);
$xoopsTpl->assign("lang_forumc", _MD_FORUMC);
$xoopsTpl->assign("lang_searchallforums", _MD_SEARCHALLFORUMS);
$xoopsTpl->assign("lang_sortby", _MD_SORTBY);
$xoopsTpl->assign("lang_date", _MD_DATE);
$xoopsTpl->assign("lang_topic", _MD_TOPIC);
$xoopsTpl->assign("lang_forum", _MD_FORUM);
$xoopsTpl->assign("lang_username", _MD_USERNAME);
$xoopsTpl->assign("lang_searchin", _MD_SEARCHIN);
$xoopsTpl->assign("lang_subject", _MD_SUBJECT);
$xoopsTpl->assign("lang_option", _MD_OPTION);// by makinosuke
$xoopsTpl->assign('forum_index_title', sprintf(_MD_FORUMINDEX,$xoopsConfig['sitename']));//by makinosuke

$xoopsTpl->assign("lang_body", _MD_BODY);
$xoopsTpl->assign("lang_forumindex", sprintf(_MD_FORUMINDEX,$xoopsConfig['sitename']));
$xoopsTpl->assign("lang_search", _MD_SEARCH);
$xoopsTpl->assign("lang_forum", _MD_FORUM);
$xoopsTpl->assign("lang_topic", _MD_TOPIC);
$xoopsTpl->assign("lang_author", _MD_AUTHOR);
$xoopsTpl->assign('lang_replies', _MD_REPLIES);
$xoopsTpl->assign('lang_views', _MD_VIEWS);
$xoopsTpl->assign("lang_possttime", _MD_POSTTIME);
$xoopsTpl->assign("lang_searchresults", _MD_SEARCHRESULTS);
$xoopsTpl->assign("img_folder", $bbImage['folder_topic']);
$xoopsTpl->assign("xoops_module_header", '<link href="style.css" type="text/css" rel="stylesheet" />');

$allowed = array("t.topic_title", "t.topic_views", "t.topic_replies", "f.forum_name", "u.uname");
$myts = MyTextSanitizer::getInstance();
$start = isset($_GET['start']) ? intval($_GET['start']) : 0;
$forum = (isset($_GET['forum']) && $_GET['forum'] != 'all') ? intval($_GET['forum']) : 'all';
$andor = (isset($_GET['addterms']) && $_GET['addterms']=='any') ? 'OR' : 'AND';
$term = (isset($_GET['term'])) ? $myts->stripSlashesGPC( $_GET['term'] ) : ""; 
if (isset($_GET['sortby'])) $sortby = (!in_array($_GET['sortby'], $allowed)) ? "" : $_GET['sortby'];

if (isset($_POST['forum'])){
	$forum = (isset($_POST['forum']) && $_POST['forum'] != 'all') ? intval($_POST['forum']) : 'all';
}
if (isset($_POST['addterms'])){
	$andor = (isset($_POST['addterms']) && $_POST['addterms']=='any') ? 'OR' : 'AND';
}
if (isset($_POST['term'])){
	$term = $myts->stripSlashesGPC( $_POST['term'] ) ;
}
if (isset($_POST['sortby'])){
	$sortby = (!in_array($_POST['sortby'], $allowed)) ? "" : $_POST['sortby'];
}
$searchboth = isset($_POST['searchboth']) ? urlencode(strip_tags($_POST['searchboth'])) : "both";

if ( !isset($_POST['submit']) && !isset($_POST['mypost']) && !isset($_GET['start'])) {
	$search = new search( "" );
	$xoopsTpl->assign("forum_selection_box", make_jumpbox(0,_MD_SEARCHALLFORUMS));
	$xoopsTpl->assign("term" ,"");
	$xoopsTpl->assign("show_results", false );
} else {
	$selstr = "p.uid,f.forum_id, p.topic_id, p.post_id, p.subject, p.post_time,p.invisible,t.topic_title,t.topic_views,t.topic_replies,f.forum_name";
	$query = 'SELECT '.$selstr.' FROM '
		.$xoopsDB->prefix('bb_forums').' f,'.$xoopsDB->prefix('bb_topics').' t,'
		.$xoopsDB->prefix('bb_posts_text').' pt, '.$xoopsDB->prefix('bb_posts').' p ';
	if ( $xoopsUser && !$xoopsUser->isadmin() ){
		$query .= " LEFT JOIN ".$xoopsDB->prefix("bb_forum_access")." a ON a.forum_id=p.forum_id";
	}
	$count_query = 'SELECT count(*) FROM '
		.$xoopsDB->prefix('bb_forums').' f,'.$xoopsDB->prefix('bb_topics').' t, '
		.$xoopsDB->prefix('bb_posts_text').' pt, '.$xoopsDB->prefix('bb_posts').' p ';
	if ( $xoopsUser && !$xoopsUser->isadmin() ){
		$count_query .= " LEFT JOIN ".$xoopsDB->prefix("bb_forum_access")." a ON a.forum_id=p.forum_id";
	}
	$search = new search( $term );
	$search->makeSuggestWords();
	$search->setKeywords( $andor );

	$search->forumChoice($forum);
	if ( isset($_POST['search_username']) && trim($_POST['search_username']) != "" ) {
		$search_username = $myts->oopsAddSlashes(trim($_POST['search_username']));
		$search->userName($search_username);
	}elseif( isset($_POST['mypost']) ){
		$search->userName($xoopsUser->uname());
	}
	$where = $search->where( $searchboth );
	$where.= " p.post_id = pt.post_id AND p.topic_id = t.topic_id AND p.forum_id = f.forum_id";
	if ( !$xoopsUser )
		$where .= " AND f.forum_type=0";
	else if( !$xoopsUser->isadmin() ){
		$where .= " AND (a.user_id=".$xoopsUser->uid()." OR f.forum_type=0)";
	}
	$query .= $where ." ORDER BY ".$sortby;
	$query .= $sortby ? "," : "";
	$query .= "p.invisible DESC,p.post_time DESC";
	$count_query .= $where;
	list($total_posts) = $xoopsDB->fetchRow($xoopsDB->query($count_query));
	$per_page = 25;
	if ( $total_posts > $per_page ) {
		include XOOPS_ROOT_PATH.'/class/pagenav.php';
		$nav = new XoopsPageNav($total_posts, $per_page, $start, "start", 
			'forum='.$forum.'&amp;addterms='.$andor .'&amp;term='.$term .'&amp;sortby='.$sortby);
		$xoopsTpl->assign('forum_page_nav', $nav->renderNav(4));
	} else {
		$xoopsTpl->assign('forum_page_nav', '');
	}
	if ( !$result = $xoopsDB->query($query,$per_page,$start) ) {
		exit("<big>"._MD_ERROROCCURED."</big><hr />"._MD_COULDNOTQUERY);
	}
	if ( !$row = $xoopsDB->getRowsNum($result) ) {
		$xoopsTpl->assign("lang_nomatch", _MD_NOMATCH);
	} else {
		while ( $row = $xoopsDB->fetchArray($result) ) {
			$isadminormod = is_adminormod($row['forum_id']);
			$uid = $xoopsUser ? $xoopsUser->uid() : 0;
 			if ( !$row['invisible'] || $isadminormod || $row['uid']==$uid ){
				// Modify By Y.Sakai
				$username = XoopsUser::getUnameFromId($row['uid'],$xoopsModuleConfig['show_name']);
				if (!$username) $username = XoopsUser::getUnameFromId($row['uid']);
				// Modify End
				$xoopsTpl->append('results', array(
					'forum_name' => $myts->makeTboxData4Show($row['forum_name']), 
					'forum_id' => $row['forum_id'], 
					'topic_id' => $row['topic_id'], 
					'topic_title' => $myts->makeTboxData4Show($row['topic_title']), 
					'topic_replies' => $row['topic_replies'], 
					'topic_views' => $row['topic_views'], 
					'user_id' => $row['uid'], 
					'user_name' => $username, 
					'invisible' => $row['invisible'], 
					'post_id' => $row['post_id'], 
					'subject' => $myts->makeTboxData4Show($row['subject']), 
					'post_time' => formatTimestamp($row['post_time'], "m"))
				);
			}
		}
	}
	$xoopsTpl->assign("forum_selection_box", make_jumpbox($forum,_MD_SEARCHALLFORUMS));
	$xoopsTpl->assign("terms" ,$search->term4disp);
	$xoopsTpl->assign("termsurl" ,urlencode($search->term4disp));
	$xoopsTpl->assign("andor" ,$andor);
	$xoopsTpl->assign("searchboth" ,$searchboth);
	$xoopsTpl->assign("show_results", true );
}
include XOOPS_ROOT_PATH.'/footer.php';
?>
