<?php
// $Id: viewtopic.php,v 1.89 2008/12/11 17:10:54 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
include 'header.php';
include XOOPS_ROOT_PATH.'/header.php';
include_once './class/NewbbViewForm.class.php';
include_once('./class/notify.class.php');

$NewbbViewForm = new NewbbViewForm();
if ($NewbbViewForm->ErrorOccured()) {
	redirect_header($NewbbViewForm->err_url,3,$NewbbViewForm->err_msg);
	exit();
}
$NewbbViewForm->SetUserStatus();
$NewbbViewForm->SanitizeHeaderInfo();
$NewbbViewForm->XTplHeaderInfo();
$NewbbViewForm->XTplIconImages();
$NewbbViewForm->XTplOrderInfo();
// For search block
require_once './class/search.class.php';
$myts = MyTextSanitizer::getInstance();
$andor = (isset($_GET['addterms']) && $_GET['addterms']=='any') ? 'OR' : 'AND';
$terms = (isset($_GET['terms'])) ? $myts->stripSlashesGPC( $_GET['terms'] ) : ""; 
$search = new search( $terms );
$xoopsTpl->assign("forum_selection_box", make_jumpbox($NewbbViewForm->forum_id(),_MD_SEARCHALLFORUMS) );
$xoopsTpl->assign("terms" ,$search->term4disp);
$xoopsTpl->assign("andor" ,$andor);
// initialize the start number of select query
$start = !empty($_GET['start']) ? intval($_GET['start']) : 0;
$post_id = !empty($_GET['post_id']) ? intval($_GET['post_id']) : 0;
$total_posts = get_total_posts($NewbbViewForm->topic_id(), 'topic');
if ($total_posts > 50) {
	$NewbbViewForm->viewmode ="flat";
	// hide link to theaded view
	$xoopsTpl->assign('lang_threaded', "" );
	$xoopsTpl->assign('lang_flat', _FLAT );
	$xoopsOption['template_main'] =  'newbb_viewtopic_flat.html';
} else {
	$xoopsTpl->assign(array('lang_threaded' => _THREADED, 'lang_flat' => _FLAT));
}
if ( $NewbbViewForm->viewmode == "thread" ) {
	$start = 0;
	$postsArray = $NewbbViewForm->getAllPosts( $total_posts, $start);
	$xoopsTpl->assign('topic_viewmode', 'thread');
	$newObjArr = array();
	foreach ( $postsArray as $eachpost ) {
		$key1 = $eachpost->postid();
		if ( (!empty($post_id) && $post_id == $key1) || ( empty($post_id) && $eachpost->parent() == 0 ) ) {
			$posterarr = $NewbbViewForm->GetPostersInfo($eachpost);
			$NewbbViewForm->XTplEachPost($eachpost,$posterarr);
		}
		$newObjArr[$key1]['obj'] = $eachpost;
		$key2 = $eachpost->parent();
		$newObjArr[$key2]['replies'][] = $key1;
		$newObjArr[$key2]['leaf'] = $key1;
	}
	$NewbbViewForm->showTree($newObjArr, $post_id);
	$xoopsTpl->assign(array('lang_subject' => _MD_SUBJECT, 'lang_date' => _MD_DATE));
} else {
	$xoopsTpl->assign(array('topic_viewmode' => 'flat', 'lang_top' => _MD_TOP, 'lang_subject' => _MD_SUBJECT, 'lang_bottom' => _MD_BOTTOM));
	$postsArray = $NewbbViewForm->getAllPosts( $NewbbViewForm->posts_per_page(), $start, $post_id);
	$posts_per_page = $NewbbViewForm->posts_per_page();
	foreach ( $postsArray as $eachpost ) {
		$posterarr = $NewbbViewForm->GetPostersInfo($eachpost);
		$NewbbViewForm->XTplEachPost($eachpost,$posterarr);
	}
	
	$pages_nav = array();
	if($total_posts > $posts_per_page){
		$temp_tid = $NewbbViewForm->topic_id();
		$temp_fid = $NewbbViewForm->forum_id();
		$temp_vm = $NewbbViewForm->viewmode;
		$temp_order = $NewbbViewForm->order();
		$temp_base_url = 'viewtopic.php?topic_id='.$temp_tid.'&amp;forum='.$temp_fid.'&amp;viewmode='.$temp_vm.'&amp;order='.$temp_order;
		if($start > 0){
			$pages_nav['previous'] = array(
				'label' => _MD_PREVPAGE,
				'url' => $temp_base_url.'&amp;start='.($start - $posts_per_page > 0 ? $start - $posts_per_page : 0)
			);
		}
		$pages_nav['pages'] = array();
		for($i = 0; $i * $posts_per_page < $total_posts - 1; $i ++){
			$pages_nav['pages'][] = array(
				'label' => $i + 1,
				'url' => $temp_base_url.'&amp;start='.($i * $posts_per_page),
				'current' => $i * $posts_per_page == $start ? 1 : 0
			);
		}
		if(($start + $posts_per_page + 1) < $total_posts){
			$pages_nav['next'] = array(
				'label' => _MD_NEXTPAGE,
				'url' => $temp_base_url.'&amp;start='.($start + $posts_per_page < $total_posts - 1 ? $start + $posts_per_page : 0)
			);
		}
	}
	$xoopsTpl->assign('pages_nav', $pages_nav);
}
if ( READ_SIGN==2 || ($NewbbViewForm->forum_type()==1 && READ_SIGN==1) ){
	$xoopsTpl->assign('read_sign', READ_SIGN);
}
if( @$_SESSION['bb_last_topic_id'] != $NewbbViewForm->topic_id ) {
	$_SESSION['bb_last_topic_id'] = $NewbbViewForm->topic_id ;
	$NewbbViewForm->CountUpTopicViews();
}
if( is_object( @$xoopsUser ) ) {
	$NewbbViewForm->UpdateUsersReadHistry( $xoopsUser->getVar('uid') );
}
$NewbbViewForm->XTplCreateJumpBox();

$notify = new notify();
$xoopsTpl->assign('notifyusers', $notify->notifyusers("thread", $NewbbViewForm->topic_id() ) );
//
// For JQuery lightbox plugin
//
$xoopsTpl->assign('xoops_module_header',
	'<link href="'.XOOPS_URL.'/modules/newbb/css/jquery.lightbox-0.5.css" type="text/css" rel="stylesheet" />
	<link rel="stylesheet" href="'.XOOPS_URL.'/modules/newbb/js/ui/themes/smoothness/ui.all.css" type="text/css" />
	<script type="text/javascript" src="'.XOOPS_URL.'/modules/newbb/js/jquery-1.2.6.min.js"></script>
	<script type="text/javascript" src="'.XOOPS_URL.'/modules/newbb/js/jquery.lightbox-0.5.min.js"></script>
	<script type="text/javascript" src="'.XOOPS_URL.'/modules/newbb/js/ui/jquery-ui-1.6.custom.min.js"></script>
    <script type="text/javascript">
	jQuery.noConflict();
	(function($){
		$(function(){
			// lightbox
			$(\'a[@href$=".jpeg"], a[@href$=".jpg"], a[@href$=".gif"], a[@href$=".png"], a[@href$=".JPEG"], a[@href$=".JPG"], a[@href$=".GIF"], a[@href$=".PNG"]\').lightBox();
			// Accordion
			$("#accordion").accordion({ header: "h3" });
			// Tabs
			$(\'#tabs\').tabs();
			// Dialog			
			$(\'#dialog\').dialog({
				autoOpen: false,
				width: 600,
				buttons: {
					"Ok": function() { 
						location.href = $(\'#dialog_link\').attr("href"); 
					}, 
					"Cancel": function() { 
						$(this).dialog("close"); 
					} 
				}
			});
			// Dialog Link
			$(\'#dialog_link\').click(function(){
				$(\'#dialog\').dialog(\'open\');
				return false;
			});
			// Datepicker
			$(\'#datepicker\').datepicker({
				inline: true
			});
			// Slider
			$(\'#slider\').slider({
				range: true,
				values: [17, 67]
			});
			//hover states on the static widgets
			$(\'#dialog_link, ul#icons li\').hover(
				function() { $(this).addClass(\'ui-state-hover\'); }, 
				function() { $(this).removeClass(\'ui-state-hover\'); }
			);
		});
	})(jQuery);
    </script>
    <link rel="stylesheet" type="text/css" media="screen,tv,print" href="style.css" />
');
//

if ($NewbbViewForm->viewmode != 'flat') {
	$xoopsOption['template_main'] =  'newbb_viewtopic_thread.html';
} else {
	$xoopsOption['template_main'] =  'newbb_viewtopic_flat.html';
}

// by makinosuke @2008/4/15
$xoopsTpl->assign('forum_index_title', sprintf(_MD_FORUMINDEX,$xoopsConfig['sitename']));

$xoopsTpl->assign("lang_keywords", _MD_KEYWORDS);
$xoopsTpl->assign("lang_searchany", _MD_SEARCHANY);
$xoopsTpl->assign("lang_searchall", _MD_SEARCHALL);
$xoopsTpl->assign("lang_forumc", _MD_FORUMC);
$xoopsTpl->assign("lang_searchallforums", _MD_SEARCHALLFORUMS);
$xoopsTpl->assign("lang_sortby", _MD_SORTBY);
$xoopsTpl->assign("lang_date", _MD_DATE);
$xoopsTpl->assign("lang_topic", _MD_TOPIC);
$xoopsTpl->assign("lang_forum", _MD_FORUM);
$xoopsTpl->assign("lang_username", _MD_USERNAME);
$xoopsTpl->assign("lang_searchin", _MD_SEARCHIN);
$xoopsTpl->assign("lang_subject", _MD_SUBJECT);

$xoopsTpl->assign("lang_body", _MD_BODY);
$xoopsTpl->assign("lang_forumindex", sprintf(_MD_FORUMINDEX,$xoopsConfig['sitename']));
$xoopsTpl->assign("lang_search", _MD_SEARCH);
$xoopsTpl->assign("lang_forum", _MD_FORUM);
$xoopsTpl->assign("lang_topic", _MD_TOPIC);
$xoopsTpl->assign("lang_author", _MD_AUTHOR);
$xoopsTpl->assign('lang_replies', _MD_REPLIES);
$xoopsTpl->assign('lang_views', _MD_VIEWS);
$xoopsTpl->assign("lang_possttime", _MD_POSTTIME);
$xoopsTpl->assign("lang_searchresults", _MD_SEARCHRESULTS);
$xoopsTpl->assign("img_folder", $bbImage['folder_topic']);
// by makinosuke @2008/4/15

include XOOPS_ROOT_PATH.'/footer.php';
?>