/*
 * Copyright (C) 2008,2009  OMRON SOFTWARE Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hiroshica.android.input.nicownn2;

import java.util.List;

import android.Manifest;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;

/**
 * The control panel preference class for Japanese IME.
 *
 * @author Copyright (C) 2009 OMRON SOFTWARE CO., LTD.  All Rights Reserved.
 */
public class NicoWnnControlPanelJAJP extends PreferenceActivity {
	private final int MENU_RESET_SYMBOL = 0;
	
	private Menu      mMenu;
	
    /** @see android.preference.PreferenceActivity#onCreate */
    @Override public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (NicoWnnJAJP.getInstance() == null) {
            new NicoWnnJAJP(this);
        }
        addPreferencesFromResource(R.xml.nicownn_pref_ja);
    }
    /*
     * 
     */
    @Override public void onStop() {
    	super.onStop();
    }

    /*
     * 
     */
    public boolean onCreateOptionsMenu(Menu menu) {
    	/* initialize the menu */
        menu.clear();
        /* [menu] add a word */
        menu.add(0, MENU_RESET_SYMBOL, 0, R.string.preference_nicownn_menu_reset_symbol);
        mMenu = menu;
        return super.onCreateOptionsMenu(menu);
    }
    /*
     *
     */
    public boolean onOptionsItemSelected(MenuItem item) {
        boolean ret;
        switch (item.getItemId()) {
        case MENU_RESET_SYMBOL:
        	if (NicoWnnJAJP.getInstance() == null) {
        		new NicoWnnJAJP(this);
        	}
        	NicoWnnJAJP.getInstance().resetSymbol();
        	Toast.makeText(getApplicationContext(), R.string.preference_nicownn_menu_reset_symbol_success, Toast.LENGTH_LONG).show();
        	
            ret = true;
            break;
        default:
            ret = false;
        }
        return ret;
    }
    
}
