/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Method;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;

/**
 * bNC^[Zv^B<p>
 * \bȟĂяoɑ΂āAĂяoΏۂ̃IuWFNg{@link MockFactory}郂bNA܂͐ݒ肳ꂽbNɂ肩C^[Zv^łB
 * ȉɁAbNC^[Zv^̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="MockInterceptor"
 *                  code="jp.ossc.nimbus.service.aop.interceptor.MockInterceptorService"&gt;
 *             &lt;attribute name="Mock"&gt;
 *                 &lt;object code="sample.MockConnection"/&gt;
 *             &lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class MockInterceptorService extends ServiceBase
 implements Interceptor, MockInterceptorServiceMBean{
    
    private static final long serialVersionUID = 5565234776209550375L;
    
    private ServiceName mockServiceName;
    private Object mock;
    
    // MockInterceptorServiceMBeanJavaDoc
    public void setMockServiceName(ServiceName name){
        mockServiceName = name;
    }
    // MockInterceptorServiceMBeanJavaDoc
    public ServiceName getMockServiceName(){
        return mockServiceName;
    }
    
    /**
     * bNݒ肷B<p>
     *
     * @param mock bN
     */
    public void setMock(Object mock) {
        this.mock = mock;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception JnɎsꍇ
     */
    public void startService() throws Exception{
        if(mockServiceName == null
            && mock == null
        ){
            throw new IllegalArgumentException("It is necessary to set any of mockServiceName or mock.");
        }
    }
    
    /**
     * ݒ肳ꂽbNĂяoΏۂ̃IuWFNgƂւāÃC^[Zv^ĂяoB<p>
     * T[rXJnĂȂꍇ́Aւs킸Ɏ̃C^[Zv^ĂяoB<br>
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    public Object invoke(
        InvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        final MethodInvocationContext ctx = (MethodInvocationContext)context;
        final Object target = ctx.getTargetObject();
        final Method targetMethod = ctx.getTargetMethod();
        try{
            if(getState() == State.STARTED){
                Object mock = null;
                if(this.mock != null){
                    mock = this.mock;
                }else if(mockServiceName != null){
                    try{
                        mock = ServiceManagerFactory
                            .getServiceObject(mockServiceName);
                    }catch(ServiceNotFoundException e){
                    }
                }
                if(mock != null){
                    Method mockMethod = null;
                    try{
                        mockMethod = mock.getClass().getMethod(
                            targetMethod.getName(),
                            targetMethod.getParameterTypes()
                        );
                        ctx.setTargetObject(mock);
                        ctx.setTargetMethod(mockMethod);
                    }catch(NoSuchMethodException e){
                        // TODO Oo
                    }
                }
            }
            return chain.invokeNext(context);
        }finally{
            if(getState() == State.STARTED){
                ctx.setTargetObject(target);
                ctx.setTargetMethod(targetMethod);
            }
        }
    }
}
