/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.*;

import javax.servlet.http.Cookie;

import jp.ossc.nimbus.core.*;

/**
 * {@link HttpServletResponseSetInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see HttpServletResponseSetInterceptorService
 */
public interface HttpServletResponseSetInterceptorServiceMBean
 extends ServletResponseSetInterceptorServiceMBean{
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#setHeader(String, String)}Őݒ肷HTTPwb_̃}bvݒ肷B<p>
     *
     * @param headers HTTPwb_̃}bv
     */
    public void setSetHeaders(Map<String, String> headers);
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#setHeader(String, String)}Őݒ肷HTTPwb_̃}bv擾B<p>
     *
     * @return HTTPwb_̃}bv
     */
    public Map<String, String> getSetHeaders();
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#setHeader(String, String)}Őݒ肷HTTPwb_ݒ肷B<p>
     *
     * @param name HTTPwb_
     * @param value HTTPwb_
     */
    public void setSetHeader(String name, String value);
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#setHeader(String, String)}Őݒ肷HTTPwb_擾B<p>
     *
     * @param name HTTPwb_
     * @return HTTPwb_
     */
    public String getSetHeader(String name);
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#setHeader(String, String)}Őݒ肷HTTPwb_폜B<p>
     *
     * @param name HTTPwb_
     */
    public void removeSetHeader(String name);
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#setHeader(String, String)}Őݒ肷HTTPwb_Sč폜B<p>
     */
    public void clearSetHeaders();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}擾lHTTPwb_ƂāA{@link javax.servlet.http.HttpServletResponse#setHeader(String, String)}Őݒ肷ۂ́AContextL[HTTPwb_̃}bsOݒ肷B<p>
     *
     * @param keys ContextL[HTTPwb_̃}bsO
     */
    public void setSetHeaderContextKeys(Properties keys);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}擾lHTTPwb_ƂāA{@link javax.servlet.http.HttpServletResponse#setHeader(String, String)}Őݒ肷ۂ́AContextL[HTTPwb_̃}bsO擾B<p>
     *
     * @return ContextL[HTTPwb_̃}bsO
     */
    public Properties getSetHeaderContextKeys();
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#addHeader(String, String)}Őݒ肷HTTPwb_ݒ肷B<p>
     *
     * @param name HTTPwb_
     * @param value HTTPwb_
     */
    public void setAddHeader(String name, String value);
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#addHeader(String, String)}Őݒ肷HTTPwb_̃}bv擾B<p>
     *
     * @return HTTPwb_̃}bv
     */
    public String[] getAddHeaders(String name);
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#addHeader(String, String)}Őݒ肷HTTPwb_폜B<p>
     *
     * @param name HTTPwb_
     */
    public void removeAddHeader(String name);
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#addHeader(String, String)}Őݒ肷HTTPwb_Sč폜B<p>
     */
    public void clearAddHeaders();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}擾lHTTPwb_ƂāA{@link javax.servlet.http.HttpServletResponse#addHeader(String, String)}Őݒ肷ۂ́AContextL[HTTPwb_̃}bsOݒ肷B<p>
     *
     * @param keys ContextL[HTTPwb_̃}bsO
     */
    public void setAddHeaderContextKeys(Properties keys);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}擾lHTTPwb_ƂāA{@link javax.servlet.http.HttpServletResponse#addHeader(String, String)}Őݒ肷ۂ́AContextL[HTTPwb_̃}bsO擾B<p>
     *
     * @return ContextL[HTTPwb_̃}bsO
     */
    public Properties getAddHeaderContextKeys();
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#addCookie(Cookie)}Őݒ肷CookieǉB<p>
     *
     * @param cookie Cookie
     */
    public void addCookie(Cookie cookie);
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#addCookie(Cookie)}Őݒ肷Cookie폜B<p>
     *
     * @param name Cookie̖O
     */
    public void removeCookie(String name);
    
    /**
     * {@link javax.servlet.http.HttpServletResponse#addCookie(Cookie)}Őݒ肷CookieSč폜B<p>
     */
    public void clearCookies();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}擾lHTTPwb_ƂĐݒ肷ۂ́AContextT[rXݒ肷B<p>
     *
     * @param name ContextT[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}擾lHTTPwb_ƂĐݒ肷ۂ́AContextT[rX擾B<p>
     *
     * @return ContextT[rX
     */
    public ServiceName getContextServiceName();
}