/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

import java.util.Set;

/**
 * bZ[WMp̃T[oRlNVC^tF[XB<p>
 * bZ[WMsT[õRlNVC^tF[XB<br>
 *
 * @author M.Takata
 */
public interface ServerConnection{
    
    /**
     * bZ[W𐶐B<br>
     *
     * @param subject TuWFNg
     * @param key L[
     * @return bZ[W
     * @exception MessageCreateException bZ[W̐Ɏsꍇ
     */
    public Message createMessage(String subject, String key) throws MessageCreateException;
    
    /**
     * w肳ꂽbZ[W̐ڑőM\ȃbZ[WɃLXgB<p>
     *
     * @param message bZ[W
     * @return LXgꂽbZ[W
     * @exception MessageException bZ[W̃LXgɎsꍇ
     */
    public Message castMessage(Message message) throws MessageException;
    
    /**
     * bZ[W𑗐MB<br>
     *
     * @param message bZ[W
     * @exception MessageSendException bZ[W̑MɎsꍇ
     */
    public void send(Message message) throws MessageSendException;
    
    /**
     * bZ[W񓯊MB<br>
     *
     * @param message bZ[W
     * @exception MessageSendException bZ[W̔񓯊MɎsꍇ
     */
    public void sendAsynch(Message message) throws MessageSendException;
    
    /**
     * NCAg̏ԕω̒ʒmł{@link ServerConnectionListener T[oRlNVXi}ǉB<br>
     *
     * @param listener T[oRlNVXi
     */
    public void addServerConnectionListener(ServerConnectionListener listener);
    
    /**
     * NCAg̏ԕω̒ʒmł{@link ServerConnectionListener T[oRlNVXi}폜B<br>
     *
     * @param listener T[oRlNVXi
     */
    public void removeServerConnectionListener(ServerConnectionListener listener);
    
    /**
     * ݐڑĂNCAg擾B<p>
     *
     * @return NCAg
     */
    public int getClientCount();
    
    /**
     * NCAgIDW擾B<p>
     *
     * @return NCAgIDW
     */
    public Set<Object> getClientIds();
    
    /**
     * w肵bZ[WMNCAgIDW擾B<p>
     *
     * @param message M郁bZ[W
     * @return NCAgIDW
     */
    public Set<Object> getReceiveClientIds(Message message);
    
    /**
     * w肵ID̃NCAgo^ĂTuWFNg擾B<p>
     *
     * @param id NCAgID
     * @return TuWFNg̏W
     */
    public Set<String> getSubjects(Object id);
    
    /**
     * w肵ID̃NCAgAw肵TuWFNgɑ΂ēo^ĂL[擾B<p>
     *
     * @param id NCAgID
     * @param subject TuWFNg
     * @return L[̏W
     */
    public Set<String> getKeys(Object id, String subject);
}