/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.resource.jms;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link SessionResourceFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see SessionResourceFactoryService
 */
public interface SessionResourceFactoryServiceMBean extends ServiceBaseMBean{
    
    /**
     * {@link jp.ossc.nimbus.service.jms.JMSSessionFactory JMSSessionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JMSSessionFactoryT[rX̃T[rX
     */
    public void setJMSSessionFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.jms.JMSSessionFactory JMSSessionFactory}T[rX̃T[rX擾B<p>
     *
     * @return JMSSessionFactoryT[rX̃T[rX
     */
    public ServiceName getJMSSessionFactoryServiceName();
    
    /**
     * JTAŊǗ郊\[Xǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isManaged JTAŊǗ郊\[X̏ꍇAtrue
     */
    public void setManaged(boolean isManaged);
    
    /**
     * JTAŊǗ郊\[Xǂ𔻒肷B<p>
     *
     * @return truȅꍇAJTAŊǗ郊\[X
     */
    public boolean isManaged();
    
    /**
     * MessageConsumerJMSNCAgbZ[WMACK̕Ԃ̃[hݒ肷B<p>
     * {@link #setAcknowledgeMode(int)}A{@link #setTransactionMode(boolean)}̗ݒ肵ĂȂꍇ́A{@link jp.ossc.nimbus.service.jms.JMSSessionFactory}̐ݒɏ]B{@link #setTransactionMode(boolean)}ݒ肵ꍇ́AftHg{@link javax.jms.Session#AUTO_ACKNOWLEDGE}B<br>
     *
     * @param mode ACK̕Ԃ̃[h
     * @see javax.jms.Session#AUTO_ACKNOWLEDGE
     * @see javax.jms.Session#CLIENT_ACKNOWLEDGE
     * @see javax.jms.Session#DUPS_OK_ACKNOWLEDGE
     */
    public void setAcknowledgeMode(int mode);
    
    /**
     * MessageConsumerJMSNCAgbZ[WMACK̕Ԃ̃[h擾B<p>
     *
     * @return ACK̕Ԃ̃[h
     */
    public int getAcknowledgeMode();
    
    /**
     * gUNVT|[g邩ǂݒ肷B<p>
     * {@link #setAcknowledgeMode(int)}A{@link #setTransactionMode(boolean)}̗ݒ肵ĂȂꍇ́A{@link jp.ossc.nimbus.service.jms.JMSSessionFactory}̐ݒɏ]B{@link #setTransactionMode(boolean)}ݒ肵ꍇ́AftHgfalseB<br>
     *
     * @param isTransacted gUNVT|[gꍇAtrue
     */
    public void setTransactionMode(boolean isTransacted);
    
    /**
     * gUNVT|[g邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAgUNVT|[g
     */
    public boolean getTransactionMode();
}