/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sql;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.jndi.JndiFinder;

/**
 * {@link DataSourceConnectionFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see DataSourceConnectionFactoryService
 */
public interface DataSourceConnectionFactoryServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * {@link Context}̃f[^\[X̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_DATASOURCE_NAME_KEY = DataSourceConnectionFactoryService.class.getName().replaceAll("\\.", "_") + "_DataSourceName";
    
    /**
     * f[^\[Xݒ肷B<p>
     *
     * @param name f[^\[X
     */
    public void setName(String name);
    
    /**
     * f[^\[X擾B<p>
     *
     * @return f[^\[X
     */
    public String getName();
    
    /**
     * {@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rXݒ肷B<p>
     *
     * @param name JndiFinderT[rX
     */
    public void setJndiFinderServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX擾B<p>
     *
     * @return JndiFinderT[rX
     */
    public ServiceName getJndiFinderServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rXݒ肷B<p>
     *
     * @param finder JndiFinderT[rX
     */
    public void setJndiFinderService(JndiFinder finder);
    
    /**
     * {@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX擾B<p>
     *
     * @return JndiFinderT[rX
     */
    public JndiFinder getJndiFinderService();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rXݒ肷B<p>
     *
     * @param name ContextT[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX擾B<p>
     *
     * @return ContextT[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rXݒ肷B<p>
     *
     * @param context ContextT[rX
     */
    public void setContextService(Context<?, ?> context);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX擾B<p>
     *
     * @return ContextT[rX
     */
    public Context<?, ?> getContextService();
    
    /**
     * {@link Context}̃f[^\[X̃L[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_DATASOURCE_NAME_KEY}B<br>
     *
     * @param key Context̃f[^\[X̃L[
     */
    public void setDataSourceNameKey(String key);
    
    /**
     * {@link Context}̃f[^\[X̃L[擾B<p>
     *
     * @return Context̃f[^\[X̃L[
     */
    public String getDataSourceNameKey();
}
