/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer;

import jp.ossc.nimbus.core.*;

/**
 * {@link FileMessageWriterService}T[rXMBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface FileMessageWriterServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * o̓t@C̕GR[fBOݒ肷B<p>
     *
     * @param encoding GR[fBO
     */
    public void setEncoding(String encoding);
    
    /**
     * o̓t@C̕GR[fBO擾B<p>
     *
     * @return GR[fBO
     */
    public String getEncoding();
    
    /**
     * o͐̃t@Cw肷B<p>
     *
     * @param file o͐t@C
     */
    public void setFile(String file);
    
    /**
     * o͐t@C擾B<p>
     *
     * @return o͐t@C
     */
    public String getFile();
    
    /**
     * o͐t@C̃vtBNXݒ肷B<p>
     * vtBNXɂ́AŒ蕶̑ɁA%ň͂񂾃L[w肷鎖łB<br>
     * L[w肳ꂽĺAReLXg܂͓͂WritableRecord擾B<br>
     *
     * @param prefix o͐t@C̃vtBNX
     */
    public void setFilePrefix(String prefix);
    
    /**
     * o͐t@C̃vtBNX擾B<p>
     *
     * @return o͐t@C̃vtBNX
     */
    public String getFilePrefix();
    
    /**
     * o͐t@C̃|XgtBNXݒ肷B<p>
     * |XgtBNXɂ́AŒ蕶̑ɁA%ň͂񂾃L[w肷鎖łB<br>
     * L[w肳ꂽĺAReLXg܂͓͂WritableRecord擾B<br>
     *
     * @param postfix o͐t@C̃|XgtBNX
     */
    public void setFilePostfix(String postfix);
    
    /**
     * o͐t@C̃|XgtBNX擾B<p>
     *
     * @return o͐t@C̃|XgtBNX
     */
    public String getFilePostfix();
    
    /**
     * t@CɒǋL邩ǂݒ肷B<p>
     * ftHǵAtrueŒǋLB<br>
     * 
     * @param isAppend t@CɒǋLꍇAtrue
     */
    public void setAppend(boolean isAppend);
    
    /**
     * t@CɒǋL邩ǂ擾B<p>
     * 
     * @return truȅꍇAt@CɒǋLB
     */
    public boolean isAppend();
    
    /**
     * t@C̃wb_ݒ肷B<p>
     * t@C݂ȂA܂́Aǉ݂łȂꍇɏo͂B<br>
     *
     * @param header wb_
     */
    public void setHeader(String header);
    
    /**
     * t@C̃wb_擾B<p>
     *
     * @return wb_
     */
    public String getHeader();
    
    /**
     * 
     * o̓Xg[邩ǂݒ肷B<p>
     * truew肵ꍇAXg[JBfalsew肵ꍇ́AXg[͊JłB<br>
     * AAL[w܂ޏo͐t@C̃vtBNXyу|XgtBNXw肳Ăꍇ́At@CIɂȂ\邽߁Afalseɂ͂łȂB<br>
     *
     * @param isClose o̓Xg[ꍇAtrue
     */
    public void setEveryTimeCloseStream(boolean isClose);
    
    /**
     * o̓Xg[邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇAo̓Xg[
     */
    public boolean isEveryTimeCloseStream();
    
    /**
     * ReLXgT[rXݒ肷B<p>
     *
     * @param name ReLXgT[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * ReLXgT[rX擾B<p>
     *
     * @return ReLXgT[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * t@CɎgpWritableElementt@Cɏo͂邩ǂݒ肷B<p>
     * ftHǵAtrueŏo͂B<br>
     *
     * @param isOutput t@CɎgpWritableElementt@Cɏo͂ꍇtrue
     */
    public void setOutputKey(boolean isOutput);
    
    /**
     * t@CɎgpWritableElementt@Cɏo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAt@CɎgpWritableElementt@Cɏo͂
     */
    public boolean isOutputKey();
    
    /**
     * ǋL邽тɍŌɏ܂Zp[^ݒ肷B<p>
     * ǋLݒ̏ꍇ̂ݎgp܂B
     * 
     * @param separator Zp[^
     */
    public void setSeparator(String separator);
    
    /**
     * ǋL邽тɍŌɏ܂Zp[^擾B<p>
     * 
     * @return Zp[^
     */
    public String getSeparator();
}
