/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link CharacterArrayEditor}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class CharacterArrayEditorTest extends BeansTestBase{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText(){
        return new Object[][]{
                {"a", new Character[]{new Character('a')}},
                {"0x63", new Character[]{new Character('c')}},
                {"\u3042", new Character[]{new Character('')}},
                {"a,", new Character[]{new Character('a')}},
                {"a,b", new Character[]{new Character('a'), new Character('b')}},
                {" \t a,b,\n    c  ", new Character[]{new Character('a'), new Character('b'), new Character('c')}},
                {"a,<!--  b\n  -->,c", new Character[]{new Character('a'), new Character('c')}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.CharacterArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.CharacterArrayEditor#getValue()",
                    "Normal"},
          dataProvider = "SetAsText")
  public void testSetText(String paramStr, Character[] answerArray){
        arrayEditorSetText(CharacterArrayEditor.class, paramStr, answerArray);
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty(){
        return new Object[][]{
                {"test.CharacterArrayEditor.value", "b", "${test.CharacterArrayEditor.value}", new Character[]{new Character('b')}},
                {"test.CharacterArrayEditor.value", "b", "a,${test.CharacterArrayEditor.value}",new Character[]{new Character('a'), new Character('b')}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.CharacterArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.CharacterArrayEditor#getValue()",
                    "Normal"},
  dataProvider = "SetAsTextProperty")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, Character[] answerArray){
        arrayEditorSetTextSystemProperty(CharacterArrayEditor.class, propertyKeyStr, propertyValStr, paramStr, answerArray);
    }
    
    @DataProvider(name = "SetAsValue")
    public Object[][] dataSetAsValue(){
        return new Object[][]{
            {new Character[]{new Character('a')}, "a"},
            {new Character[]{new Character('a'), new Character('b')}, "a,b"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.CharacterArrayEditor#setAsValue(java.lang.Character)",
                    "jp.ossc.nimbus.beans.CharacterArrayEditor#getAsText()",
                    "Normal"},
  dataProvider = "SetAsValue")
    public void testSetValue(Character[] paramArray, String answerStr){
        arrayEditorSetValue(CharacterArrayEditor.class, paramArray, answerStr);
    }
}
