/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link ClassEditor}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class ClassEditorTest extends BeansTestBase{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText(){
        return new Object[][]{
                {"java.lang.String", java.lang.String.class},
                {"java.lang.String[]", java.lang.String[].class},
                {"java.util.Map$Entry", java.util.Map.Entry.class},
                {"int", Integer.TYPE}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.ClassEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.ClassEditor#getValue()",
                    "Normal"},
          dataProvider = "SetAsText")
  public void testSetText(String paramStr, Class<?> answer){
        editorSetText(ClassEditor.class, paramStr, answer);
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty(){
        return new Object[][]{
                {"test.ClassEditor.value", "java.lang.Integer", "${test.ClassEditor.value}", java.lang.Integer.class}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.ClassEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.ClassEditor#getValue()",
                    "Normal"},
  dataProvider = "SetAsTextProperty")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, Class<?> answer){
        editorSetTextSystemProperty(ClassEditor.class, propertyKeyStr, propertyValStr, paramStr, answer);
    }
    
    @DataProvider(name = "SetAsValue")
    public Object[][] dataSetAsValue(){
        return new Object[][]{
            {java.lang.String.class, "java.lang.String"},
            {java.lang.String[].class, "[Ljava.lang.String;"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.ClassEditor#setAsValue(java.lang.Character)",
                    "jp.ossc.nimbus.beans.ClassEditor#getAsText()",
                    "Normal"},
  dataProvider = "SetAsValue")
    public void testSetValue(Class<?> param, String answerStr){
        editorSetValue(ClassEditor.class, param, answerStr);
    }
}
