/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.*;

/**
 * wb_[B<p>
 * f[^Zbg̃wb_[ŁAwb_[{@link Record R[h}łB<br>
 * R[hƓlɁÃvpeBBeanŁAXL[}`ɂāAǂ̂悤Beanɂ̂ivpeBA^Ȃǁj𓮓IɌłB<br>
 * 
 * @author M.Takata
 */
public class Header extends Record implements Serializable{
    
    private static final long serialVersionUID = -2149254849180957920L;
    
    /**
     * wb_[B<p>
     */
    protected String name;
    
    /**
     * `̃wb_[𐶐B<p>
     */
    public Header(){
    }
    
    /**
     * `̃wb_[𐶐B<p>
     *
     * @param name wb_[
     */
    public Header(String name){
        this.name = name;
    }
    
    /**
     * wb_[𐶐B<p>
     *
     * @param name wb_[
     * @param schema XL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public Header(String name, String schema)
     throws PropertySchemaDefineException{
        super(schema);
        this.name = name;
    }
    
    /**
     * wb_[𐶐B<p>
     *
     * @param name wb_[
     * @param recordSchema XL[}񂩂琶ꂽR[hXL[}
     * @exception PropertySchemaDefineException vpeB̃XL[}`Ɏsꍇ
     */
    public Header(String name, RecordSchema recordSchema){
        super(recordSchema);
        this.name = name;
    }
    
    /**
     * wb_[擾B<p>
     *
     * @return wb_[
     */
    public String getName(){
        return name;
    }
    
    /**
     * wb_[ݒ肷B<p>
     *
     * @param name wb_[
     */
    public void setName(String name){
        this.name = name;
    }
    
    private void writeObject(ObjectOutputStream out) throws IOException{
        out.defaultWriteObject();
    }
    
    private void readObject(ObjectInputStream in)
     throws IOException, ClassNotFoundException{
        in.defaultReadObject();
        if(schema != null){
            recordSchema = RecordSchema.getInstance(schema);
        }
    }
}
