/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

/**
 * T[rXT|[gC^tF[XB<p>
 * {@link ServiceBase}NXpȂĂAServiceBase̎𗘗pł悤ɂ邽߂̃C^tF[XłB<br>
 * ̃C^tF[XNX́A{@link ServiceManager}ɓo^ۂɁAServiceBaseNXŃbvēo^Bo^ꂽ̃NX̃CX^XA{@link ServiceManager#getService(String)}ŁA擾Ďgpꍇɂ́AbvꂽIuWFNg擾AServiceBasepNXƓ̋@\gpłB<br>
 * 
 * @author M.Takata
 * @see ServiceBase
 */
public interface ServiceBaseSupport{
    
    /**
     * ̃T[rXbv{@link ServiceBase}ݒ肷B<p>
     * 
     * @param service ̃T[rXbvServiceBase
     */
    public void setServiceBase(ServiceBase service);
    
    /**
     * T[rX𐶐B<p>
     * ̃T[rXɕKvȃIuWFNg̐Ȃǂ̏sB<br>
     * ̃C^tF[XimplementsăT[rXT[rXJ҂́AT[rX̐Ã\bhɎ邱ƁB<br>
     *
     * @exception Exception T[rX̐Ɏsꍇ
     * @see ServiceBase#create()
     */
    public void createService() throws Exception;
    
    /**
     * T[rXJnB<p>
     * ̃T[rX𗘗p\ȏԂɂB̃\bȟĂяóÃT[rX̋@\𗘗pł鎖ۏ؂B<br>
     * ̃C^tF[XimplementsăT[rXT[rXJ҂́AT[rX̊JnÃ\bhɎ邱ƁB<br>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     * @see ServiceBase#start()
     */
    public void startService() throws Exception;
    
    /**
     * T[rX~B<p>
     * ̃T[rX𗘗ps\ȏԂɂB̃\bȟĂяóÃT[rX̋@\𗘗pł鎖͕ۏ؂ȂB<br>
     * ̃C^tF[XimplementsăT[rXT[rXJ҂́AT[rX̒~Ã\bhɎ邱ƁB<br>
     *
     * @exception Exception T[rX̒~ɎsꍇBAAstop()ňׂāA͑sB
     * @see ServiceBase#stop()
     */
    public void stopService() throws Exception;
    
    /**
     * T[rXjB<p>
     * ̃T[rXŎgp郊\[XJB̃\bȟĂяóÃT[rX̋@\𗘗pł鎖͕ۏ؂ȂB<br>
     * ̃C^tF[XimplementsăT[rXT[rXJ҂́AT[rX̔jÃ\bhɎ邱ƁB<br>
     *
     * @exception Exception T[rX̔jɎsꍇBAAdestroy()ňׂāA͑sB
     * @see ServiceBase#destroy()
     */
    public void destroyService() throws Exception;
}