/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.util.Set;
import java.util.List;

import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.repository.Repository;

/**
 * T[rXǗC^tF[XB<p>
 * {@link Service}CX^XɖOtĊǗA񋟂C^tF[XłB<br>
 * T[rX̓o^Ao^A擾Ȃǂ̃T[rX񋟂郁\bhƁAT[rX̓o^ƂȂ{@link Repository}ݒ肷郁\bhB<br>
 * ܂A{@link Service}̃TuC^tF[XƂȂĂ邽߁ANX̓T[rXƂĎB<br>
 *
 * @author M.Takata
 */
public interface ServiceManager extends Service, RegistrationListenable{
    
    /**
     * ̃T[rX̃ftHg̃T[rXB<p>
     */
    public static final String DEFAULT_NAME = "Nimbus";
    
    /**
     * }l[W`zuB<p>
     *
     * @param metaData }l[W`
     * @exception DeploymentException zuɎsꍇ
     */
    public void deploy(ManagerMetaData metaData) throws DeploymentException;
    
    /**
     * }l[W`폜B<p>
     *
     * @param metaData }l[W`
     */
    public void undeploy(ManagerMetaData metaData);
    
    /**
     * T[rX`zuB<p>
     *
     * @param metaData T[rX`
     * @exception DeploymentException zuɎsꍇ
     */
    public void deploy(ServiceMetaData metaData) throws DeploymentException;
    
    /**
     * T[rX`폜B<p>
     *
     * @param metaData T[rX`
     */
    public void undeploy(ServiceMetaData metaData);
    
    /**
     * }l[W`擾B<p>
     *
     * @return }l[W`̏W
     */
    public Set<ManagerMetaData> getManagerMetaDataSet();
    
    /**
     * w肵ÕT[rX̒`擾B<p>
     * {@link ServiceLoader}Ń[hT[rX̒`擾B<br>
     * 
     * @param name T[rX̖O
     * @return T[rX`
     */
    public ServiceMetaData getServiceMetaData(String name);
    
    /**
     * &lt;service&gt;vf̎qvfƂĒ`ꂽ&lt;depends&gt;vf̃^f[^̃Xg擾B<p>
     * w肳ꂽT[rX̃T[rXÃ}l[WɔzuĂȂꍇ́AnullԂB܂Aw肳ꂽT[rXnameƂĎ&lt;service&gt;vfɁA&lt;depends&gt;vf`ĂȂꍇ́ÃXgԂB<br>
     *
     * @param serviceName T[rX
     * @return {@link ServiceMetaData.DependsMetaData}̃Xg
     */
    public List<ServiceMetaData.DependsMetaData> getDepends(String serviceName);
    
    /**
     * w肳ꂽT[rX&lt;depends&gt;vfɎ&lt;service&gt;vf̃^f[^̃Xg擾B<p>
     * AÃ}l[Wɓo^ꂽT[rX݂̂ΏۂƂȂB<br>
     * w肳ꂽT[rX&lt;depends&gt;vfɎT[rX`ĂȂꍇ́ÃXgԂB<br>
     *
     * @param managerName T[rXo^ĂServiceManager̖O
     * @param serviceName T[rX
     * @return {@link ServiceMetaData}̃Xg
     */
    public List<ServiceMetaData> getDependedServices(
        String managerName,
        String serviceName
    );
    
    /**
     * w肳ꂽT[rXCX^XB<p>
     *
     * @param data T[rX`
     * @return CX^XT[rX
     * @exception Exception Ɏsꍇ
     */
    public Service instanciateService(ServiceMetaData data) throws Exception;
    
    /**
     * w肳ꂽIuWFNg𐶐B<p>
     *
     * @param data T[rX`
     * @return IuWFNg
     * @exception Exception Ɏsꍇ
     */
    public Object createObject(ServiceMetaData data) throws Exception;
    
    /**
     * w肵ÕT[rX擾B<p>
     * ̃\bhŎ擾łIuWFNǵAT[rX񋟂C^tF[XɃLXgłƂ͌ȂB<br>
     * T[rX̐ENE~EjȂǂ̑sꍇɁÃ\bhŃCX^X擾B<br>
     *
     * @param name T[rX̖O
     * @return ServiceIuWFNg
     * @exception ServiceNotFoundException T[rXȂꍇ
     */
    public Service getService(String name) throws ServiceNotFoundException;
    
    /**
     * w肵ÕT[rX񋟂IuWFNg擾B<p>
     * ̃\bhŎ擾łIuWFNǵAT[rX񋟂C^tF[XɃLXgł鎖ۏ؂B<br>
     * T[rX̐ENE~EjȂǂ̑sꍇ́A{@link #getService(String)}ŃCX^X擾B<br>
     *
     * @param name T[rX̖O
     * @return ServiceIuWFNg
     * @exception ServiceNotFoundException T[rXȂꍇ
     */
    public <T> T getServiceObject(String name) throws ServiceNotFoundException;
    
    /**
     * T[rXo^B<p>
     * objɎw肷IuWFNg{@link Service}C^tF[XĂȂꍇ́AServiceC^tF[XIuWFNgɃbvēo^BɂACӂ̃IuWFNgT[rXƓlɈłB<br>
     * AAT[rX̎ɈˑēIȐ͔BȉɁAT[rXƂēo^IuWFNgA@̏ŁAB<br>
     * <ol>
     *   <li>{@link ServiceBase}̃TuNX<br>Ȃ̃RXgN^ŐBT[rX̏ɁA{@link ServiceBase#setServiceName(String)}A{@link ServiceBase#createService()}A{@link ServiceBase#startService()}ĂяoB܂A{@link ServiceManager#create()}A{@link ServiceManager#start()}A{@link ServiceManager#stop()}A{@link ServiceManager#destroy()}ĂяoƁAo^ĂServicȇΉ郁\bhĂяoBServiceBaséAJMXɑΉĂ{@link ServiceBaseMBean}C^tF[XMBeanC^tF[XƂĎĂB</li>
     *   <li>{@link FactoryServiceBase}̃TuNX<br>FactoryServiceBaséAServiceBasẽTuNXł邽߁ALServiceBasẽTuNXɏBAA{@link ServiceManager#getServiceObject(String)}ĂяoꂽꍇAFactoryServiceBase̎NX̃CX^X͕ԂɁA{@link FactoryService#newInstance()}ŐIuWFNgԂB</li>
     *  <li>{@link ServiceBaseSupport}C^tF[XNX<br>Ȃ̃RXgN^ŐAServiceBaseNXŃbvāAServiceManagerɓo^BT[rX̏ɁA{@link ServiceBase#createService()}A{@link ServiceBase#startService()}ĂяoB܂AServiceManager.create()AServiceManager.start()AServiceManager.stop()AServiceManager.destroy()ĂяoƁAServiceManagerɓo^ĂServiceBaseIuWFNgʂāA{@link ServiceBaseSupport#createService()}A{@link ServiceBaseSupport#startService()}A{@link ServiceBaseSupport#stopService()}A{@link ServiceBaseSupport#destroyService()}ĂяoBbp[łServiceBaseAJMXɑΉĂ邽߁AServiceManagerɓo^IuWFNǵAServiceBaseMBeanC^tF[XMBeanC^tF[XƂĎB܂A{@link FactoryService}C^tF[X΁ALFactoryServiceBasẽTuNXɏB</li>
     *   <li>{@link Service}C^tF[XNX<br>Ȃ̃RXgN^ŐBT[rX̏ɁA{@link Service#setServiceName(String)}A{@link Service#create()}A{@link Service#start()}ĂяoB܂AServiceManager.create()AServiceManager.start()AServiceManager.stop()AServiceManager.destroy()ĂяoƁAServicȇΉ郁\bhĂяoBAA{@link Service#getState()}ɑ΂̐ӔC𕉂KvBJMXɂ́AΉĂȂ̂ŁAΉ邽߂ɂ́AƎMBeansKvB</li>
     *   <li>LȊÕNX<br>Ȃ̃RXgN^ŐBServiceBaseSupportC^tF[XŃbvAXServiceBaseNXɃbvāAServiceManagerɓo^BService.create()AService.start()AService.stop()AService.destroy()ƓVOj`̃\bhĂꍇ́ALServiceBasẽTuNXƓBȊȌꍇ́AServiceManager.create()ĂяoƁAServiceManager֎go^鎖ƁAServiceManager.destroy()ĂяoƁAServiceManager玩g폜B܂AService#getState()́A{@link Service#CREATED}A{@link Service#DESTROYED}ȊȌԂ{@link Service#UNKNOWN}ƂȂB</li>
     * </ol>
     *
     * @param name T[rX̖O
     * @param obj T[rX񋟂IuWFNg
     * @return o^łꍇtrue
     * @exception Exception T[rX̓o^Ɏsꍇ
     */
    public boolean registerService(String name, Object obj) throws Exception;
    
    /**
     * w肳ꂽT[rXw肳ꂽT[rXœo^B<p>
     *
     * @param name T[rX̖O
     * @param service T[rX񋟂T[rXIuWFNg
     * @return o^łꍇtrue
     * @exception Exception T[rX̓o^Ɏsꍇ
     */
    public boolean registerService(String name, Service service) throws Exception;
    
    /**
     * w肳ꂽT[rX`^f[^ɏ]T[rXAw肳ꂽT[rXŃT[rXƂēo^B<p>
     *
     * @param serviceData T[rX`^f[^
     * @return o^łꍇtrue
     * @exception Exception T[rX̃CX^XɎsꍇ
     */
    public boolean registerService(ServiceMetaData serviceData)
     throws Exception;
    
    /**
     * w肳ꂽT[rX̃T[rXo^B<p>
     *
     * @param name T[rX
     * @return o^łꍇtrue
     */
    public boolean unregisterService(String name);
    
    /**
     * w肳ꂽT[rX̃T[rXo^Ă邩ׂB<p>
     *
     * @param name T[rX
     * @return o^Ăꍇtrue
     */
    public boolean isRegisteredService(String name);
    
    /**
     * o^ĂT[rXȌW擾B<p>
     *
     * @return o^ĂT[rX̏W
     */
    public Set<String> serviceNameSet();
    
    /**
     * o^Ă{@link Service}̏W擾B<p>
     *
     * @return o^ĂServicȅW
     */
    public Set<Service> serviceSet();
    
    /**
     * o^ĂT[rXIuWFNg̏W擾B<p>
     *
     * @return o^ĂT[rXIuWFNg̏W
     */
    public Set<Object> serviceObjectSet();
    
    /**
     * ̃}l[WŊǗT[rX̓o^{@link Repository}ݒ肷B<p>
     * RepositoryT[rX̒~ɁAIɃftHg̃|Wgɐ؂ւ܂B<br>
     *
     * @param manager RepositoryC^tF[XT[rXo^Ă}l[W
     * @param service RepositoryC^tF[XT[rX̃T[rX
     * @return o^ĂT[rXw肳ꂽRepositoryɑSēo^ꍇAtrue
     */
    public boolean setServiceRepository(String manager, String service);
    
    /**
     * ̃}l[WŊǗT[rX̓o^{@link Repository}ݒ肷B<p>
     *
     * @param repository RepositoryC^tF[XIuWFNg
     * @return o^ĂT[rXw肳ꂽRepositoryɑSēo^ꍇAtrue
     */
    public boolean setServiceRepository(Repository repository);
    
    /**
     * }l[WvpeB擾B<p>
     *
     * @param name vpeB
     * @return vpeBl
     */
    public String getProperty(String name);
    
    /**
     * }l[WvpeBݒ肷B<p>
     *
     * @param name vpeB
     * @param value vpeBl
     */
    public void setProperty(String name, String value);
    
    /**
     * w肳ꂽT[rX𐶐B<p>
     *
     * @param name T[rX
     * @exception Exception Ɏsꍇ
     */
    public void createService(String name) throws Exception;
    
    /**
     * w肳ꂽT[rX𐶐B<p>
     *
     * @param name T[rX
     * @param completed ꂽT[rX̏WBˑ֌Wɂ萶ꂽT[rX܂ށB
     * @exception Exception Ɏsꍇ
     */
    public void createService(String name, Set<String> completed) throws Exception;
    
    /**
     * w肳ꂽT[rXW𐶐B<p>
     *
     * @param names T[rX̏W
     */
    public void createService(Set<String> names);
    
    /**
     * w肳ꂽo^ĂȂT[rX𐶐B<p>
     * ˑ֌W͍̉sȂB
     *
     * @param service o^ĂȂT[rX
     * @param serviceData T[rX̒`
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void createService(Service service, ServiceMetaData serviceData)
     throws Exception;
    
    /**
     * o^ĂSẴT[rX𐶐B<p>
     * AAɐĂT[rX́AȂB<br>
     */
    public void createAllService();
    
    /**
     * w肳ꂽT[rXJnB<p>
     *
     * @param name T[rX
     * @exception Exception JnɎsꍇ
     */
    public void startService(String name) throws Exception;
    
    /**
     * w肳ꂽT[rXJnB<p>
     *
     * @param name T[rX
     * @param completed JnꂽT[rX̏WBˑ֌WɂJnꂽT[rX܂ށB
     * @exception Exception JnɎsꍇ
     */
    public void startService(String name, Set<String> completed) throws Exception;
    
    /**
     * w肳ꂽT[rXWJnB<p>
     *
     * @param names T[rX̏W
     */
    public void startService(Set<String> names);
    
    /**
     * w肳ꂽo^ĂȂT[rXJnB<p>
     * ˑ֌W͍̉sȂB
     *
     * @param service o^ĂȂT[rX
     * @param serviceData T[rX̒`
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService(Service service, ServiceMetaData serviceData)
     throws Exception;
    
    /**
     * o^ĂSẴT[rXJnB<p>
     * AAɊJnĂT[rX́AJnȂB<br>
     */
    public void startAllService();
    
    /**
     * w肳ꂽT[rXĊJnB<p>
     *
     * @param name T[rX
     * @exception Exception ĊJnɎsꍇ
     */
    public void restartService(String name) throws Exception;
    
    /**
     * w肳ꂽT[rXĊJnB<p>
     *
     * @param name T[rX
     * @param completed ĊJnꂽT[rX̏WBˑ֌WɂĊJnꂽT[rX܂ށB
     * @exception Exception ĊJnɎsꍇ
     */
    public void restartService(String name, Set<String> completed) throws Exception;
    
    /**
     * w肳ꂽT[rXWĊJnB<p>
     *
     * @param names T[rX̏W
     */
    public void restartService(Set<String> names);
    
    /**
     * w肳ꂽo^ĂȂT[rXĊJnB<p>
     * ˑ֌W͍̉sȂB
     *
     * @param service o^ĂȂT[rX
     * @param serviceData T[rX̒`
     * @exception Exception T[rX̍ĊJnɎsꍇ
     */
    public void restartService(Service service, ServiceMetaData serviceData)
     throws Exception;
    
    /**
     * o^ĂSẴT[rXĊJnB<p>
     */
    public void restartAllService();
    
    /**
     * w肳ꂽT[rX~B<p>
     *
     * @param name T[rX
     */
    public void stopService(String name);
    
    /**
     * w肳ꂽT[rX~B<p>
     *
     * @param name T[rX
     * @param completed ~ꂽT[rX̏WBˑ֌Wɂ~ꂽT[rX܂ށB
     */
    public void stopService(String name, Set<String> completed);
    
    /**
     * w肳ꂽT[rXW~B<p>
     *
     * @param names T[rX̏W
     */
    public void stopService(Set<String> names);
    
    /**
     * w肳ꂽo^ĂȂT[rX~B<p>
     * ˑ֌W͍̉sȂB
     *
     * @param service o^ĂȂT[rX
     * @param serviceData T[rX̒`
     */
    public void stopService(Service service, ServiceMetaData serviceData);
    
    /**
     * o^ĂSẴT[rX~B<p>
     */
    public void stopAllService();
    
    /**
     * w肳ꂽT[rXjB<p>
     *
     * @param name T[rX
     */
    public void destroyService(String name);
    
    /**
     * w肳ꂽT[rXjB<p>
     *
     * @param name T[rX
     * @param completed jꂽT[rX̏WBˑ֌WɂjꂽT[rXȂǂ܂ށB
     */
    public void destroyService(String name, Set<String> completed);
    
    /**
     * w肳ꂽT[rXWjB<p>
     *
     * @param names T[rX̏W
     */
    public void destroyService(Set<String> names);
    
    /**
     * w肳ꂽo^ĂȂT[rXjB<p>
     * ˑ֌W͍̉sȂB
     *
     * @param service o^ĂȂT[rX
     * @param serviceData T[rX̒`
     */
    public void destroyService(Service service, ServiceMetaData serviceData);
    
    /**
     * o^ĂSẴT[rXjB<p>
     */
    public void destroyAllService();
    
    /**
     * w肵fvCҋ@̃T[rXAҋ@Ă錴ƂȂĂT[rX̏W擾B<p>
     *
     * @param waitService ҋ@̃T[rX
     * @return ҋ@Ă錴ƂȂĂT[rX̏W
     */
    public Set<ServiceName> getWaitingCauses(String waitService);
    
    /**
     * ǗĂҋ@̃T[rXNAB<p>
     */
    public void clearWaitingServices();
    
    /**
     * ҋ@̃T[rX݂邩ׂB<p>
     *
     * @return ҋ@̃T[rX݂ꍇtrue
     */
    public boolean existWaitingService();
    
    /**
     * ҋ@̃T[rX̖ȌW擾B<p>
     *
     * @return ҋ@̃T[rX̖ȌW
     */
    public Set<String> getWaitingServices();
    
    /**
     * w肵fvCɎsT[rXAfvCłȂƂȂĂO擾B<p>
     *
     * @param failedService fvCɎsT[rX
     * @return fvCłȂƂȂĂO
     */
    public Throwable getFailedCause(String failedService);
    
    /**
     * ǗĂfvCɎsT[rX̏WNAB<p>
     */
    public void clearFailedServices();
    
    /**
     * fvCɎsT[rX݂邩ׂB<p>
     *
     * @return fvCɎsT[rX݂ꍇtrue
     */
    public boolean existFailedService();
    
    /**
     * fvCɎsT[rX̖ȌW擾B<p>
     *
     * @return fvCɎsT[rX̖ȌW
     */
    public Set<String> getFailedServices();
     
    /**
     * o^ꂽServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}T[rX擾B<p>
     *
     * @return o^ꂽServicẽOo͂Ɏgp{@link jp.ossc.nimbus.service.log.Logger}T[rX
     */
    public Logger getLogger();
    
    /**
     * Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rX擾B<p>
     *
     * @return Serviceł̃bZ[W擾Ɏgp{@link jp.ossc.nimbus.service.message.MessageRecordFactory}T[rX
     */
    public MessageRecordFactory getMessageRecordFactory();
    
    /**
     * w肵ÕT[rX̏ԕύXʒm{@link ServiceStateListenable}擾B<p>
     * o^ĂȂT[rXServiceStateListenable͎擾łȂB<br>
     * ܂A{@link Service}C^tF[X𒼐ڎT[rXo^ꍇÃNXServiceStateListenableĂȂƎ擾łȂB<br>
     *
     * @param name T[rX̖O
     * @return ServiceStateListenableIuWFNg
     * @exception ServiceNotFoundException T[rXȂꍇ
     */
    public ServiceStateListenable getServiceStateListenable(String name)
     throws ServiceNotFoundException;
    
    /**
     * T[rX̏ԂύXꂽĎServiceStateListenerǉB<p>
     * w肵T[rXo^ĂȂꍇARegistrationListenero^BT[rXo^ƁAServiceStateListenero^B<br>
     * ܂Aw肳ꂽT[rX{@link ServiceStateListenable}ĂȂꍇAServiceStateListenero^łȂ߉ȂB<br>
     *
     * @param name T[rX
     * @param listener ServiceStateListenerIuWFNg
     */
    public void addServiceStateListener(
        String name,
        ServiceStateListener listener
    );
    
    /**
     * T[rX̏ԂύXꂽĎServiceStateListener폜B<p>
     *
     * @param name T[rX
     * @param listener ServiceStateListenerIuWFNg
     */
    public void removeServiceStateListener(
        String name,
        ServiceStateListener listener
    );
    
    /**
     * Oo͂sLoggerT[rXݒ肷B<p>
     *
     * @param log LoggerT[rX
     */
    public void setLogger(Logger log);
    
    /**
     * bZ[WsMessageRecordFactoryT[rXݒ肷B<p>
     *
     * @param factory MessageRecordFactoryT[rX
     */
    public void setMessageRecordFactory(MessageRecordFactory factory);
}