/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.http;

import java.io.*;
import java.util.*;

/**
 * HTTPNGXgB<p>
 *
 * @author M.Takata
 */
public interface HttpRequest{
    
    /**
     * NGXgӂɎʂ_ANV擾B<p>
     *
     * @return ANV
     */
    public String getActionName();
    
    /**
     * NGXgURL擾B<p>
     *
     * @return URL
     */
    public String getURL();
    
    /**
     * NGXgURLݒ肷B<p>
     *
     * @param url URL
     */
    public void setURL(String url);
    
    /**
     * NGXgHTTP̃o[W擾B<p>
     *
     * @return HTTP̃o[W
     */
    public String getHttpVersion();
    
    /**
     * NGXgHTTP̃o[Wݒ肷B<p>
     *
     * @param version HTTP̃o[W
     */
    public void setHttpVersion(String version);
    
    /**
     * NGXgHTTPwb_̏W擾B<p>
     *
     * @return HTTPwb_̏W
     */
    public Set<String> getHeaderNameSet();
    
    /**
     * w肳ꂽOHTTPwb_擾B<p>
     * wb_ŕ̒lꍇ́Aŏ̒lB<br>
     *
     * @return HTTPwb_
     */
    public String getHeader(String name);
    
    /**
     * w肳ꂽOHTTPwb_擾B<p>
     *
     * @return HTTPwb_z
     */
    public String[] getHeaders(String name);
    
    /**
     * HTTPwb_ݒ肷B<p>
     *
     * @param name HTTPwb_
     * @param value HTTPwb_
     */
    public void setHeader(String name, String value);
    
    /**
     * HTTPwb_ݒ肷B<p>
     *
     * @param name HTTPwb_
     * @param value HTTPwb_z
     */
    public void setHeaders(String name, String[] value);
    
    /**
     * HTTPwb_ǉB<p>
     *
     * @param name HTTPwb_
     * @param value HTTPwb_
     */
    public void addHeader(String name, String value);
    
    /**
     * NGXg̃Reg^Cv擾B<p>
     *
     * @return Reg^Cv
     */
    public String getContentType();
    
    /**
     * NGXg̃Reg^Cvݒ肷B<p>
     *
     * @param type Reg^Cv
     */
    public void setContentType(String type);
    
    /**
     * NGXg̕GR[fBO擾B<p>
     *
     * @return GR[fBO
     */
    public String getCharacterEncoding();
    
    /**
     * NGXg̕GR[fBOݒ肷B<p>
     *
     * @param encoding GR[fBO
     */
    public void setCharacterEncoding(String encoding);
    
    /**
     * NGXg̃NG擾B<p>
     *
     * @return NG
     */
    public String getQueryString();
    
    /**
     * NGXg̃NGݒ肷B<p>
     *
     * @param query NG
     */
    public void setQueryString(String query);
    
    /**
     * NGXgp[^̏W擾B<p>
     *
     * @return NGXgp[^̏W
     */
    public Set<String> getParameterNameSet();
    
    /**
     * w肳ꂽÕNGXgp[^擾B<p>
     * ꃊNGXgp[^ŕ̒lꍇ́Aŏ̒lB<br>
     *
     * @return NGXgp[^
     */
    public String getParameter(String name);
    
    /**
     * w肳ꂽÕNGXgp[^擾B<p>
     *
     * @return NGXgp[^
     */
    public String[] getParameters(String name);
    
    /**
     * NGXgp[^ݒ肷B<p>
     *
     * @param name NGXgp[^
     * @param value NGXgp[^
     */
    public void setParameter(String name, String value);
    
    /**
     * NGXgp[^ݒ肷B<p>
     *
     * @param name NGXgp[^
     * @param value NGXgp[^
     */
    public void setParameters(String name, String[] value);
    
    /**
     * NGXgXg[ɏނ߂̓̓Xg[ݒ肷B<p>
     *
     * @param is ̓Xg[
     */
    public void setInputStream(InputStream is);
    
    /**
     * NGXgXg[擾B<p>
     *
     * @return NGXgXg[
     */
    public OutputStream getOutputStream();
    
    /**
     * NGXgXg[ɏނ߂̓̓IuWFNgݒ肷B<p>
     *
     * @param input ̓IuWFNg
     */
    public void setObject(Object input);
    
    /**
     * NGXgXg[ɏނ߂̓̓IuWFNg擾B<p>
     *
     * @return ̓IuWFNg
     */
    public Object getObject();
}