/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.message;

import java.util.Locale;
import java.util.List;

/**
 * bZ[WR[hB<p>
 *
 * @author H.Nakano
 */
public interface MessageRecord{
    
    /**
     * bZ[WID擾B<p>
     *
     * @return bZ[WID
     */
    public String getMessageCode();
    
    /**
     * ftHgP[̃bZ[W擾B<p>
     * 
     * @param embed ߍ݃p[^
     * @return ftHgP[̃bZ[W
     */
    public String makeMessage(Object... embed);
    
    /**
     * w肵P[̖ߍ݃bZ[W擾B<p>
     * 
     * @param lc P[
     * @param embed ߍ݃p[^
     * @return w肵P[̖ߍ݃bZ[W
     */
    public String makeMessage(Locale lc, Object... embed);
    
    /**
     * ftHgP[̃ev[gbZ[W擾B<p>
     *
     * @return ftHgP[̃ev[gbZ[W
     */
    public String getMessageTemplate();
    
    /**
     * w肵P[̃ev[gbZ[W擾B<p>
     *
     * @param lc P[
     * @return w肵P[̃ev[gbZ[W
     */
    public String getMessageTemplate(Locale lc);
    
    
    /**
     * bZ[W`t@C1sǂݍށB<p>
     *
     * @param record bZ[W`t@C1s̕
     */
    public void rec2Obj(List<String> record) throws MessageRecordParseException;
    
    /**
     * P[̃bZ[WǉB<p>
     * 
     * @param record bZ[W
     * @param locale P[w蕶
     */
    public void addMessage(List<String> record, String locale);
    
    /**
     * bZ[WR[ht@Ngݒ肷B<p>
     * 
     * @param fac bZ[WR[ht@Ng
     */
    public void setMessageRecordFactory(MessageRecordFactory fac);
    
    public void setSecret(boolean flg);
    
    public void setSecretString(String secret);
}
