/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.queue;

/**
 * QueueHandlerReiB<p>
 * 
 * @author M.Takata
 */
public interface QueueHandlerContainer<E> extends Queue<E>{
    
    /**
     * QueueHandlerݒ肷B<p>
     *
     * @param handler QueueHandler
     */
    public void setQueueHandler(QueueHandler<E> handler);
    
    /**
     * nhO̍ۂɃG[ʒm郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setHandlingErrorMessageId(String id);
    
    /**
     * nhO̍ۂɃG[AgC񐔂zʒm郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id ÕbZ[WID
     */
    public void setRetryOverErrorMessageId(String id);
    
    /**
     * nhO̍ۂɃG[ꍇɃgC񐔂ݒ肷B<p>
     *
     * @param count gC
     */
    public void setMaxRetryCount(int count);
    
    /**
     * nhO̍ۂɃG[ꍇɃgCԊuݒ肷B<p>
     *
     * @param interval gCԊu
     */
    public void setRetryInterval(long interval);
    
    /**
     * JnB<p>
     */
    public void start() throws Exception;
    
    /**
     * ~B<p>
     */
    public void stop();
    
    /**
     * ĊJB<p>
     */
    public void resume();
    
    /**
     * fB<p>
     */
    public void suspend();
    
    /**
     * fĂ邩ǂ𔻒肷B<p>
     *
     * @return fĂꍇAtrue
     */
    public boolean isSuspend();
    
    /**
     * L[҂󂯂{@link QueueHandler}Xbh̐擾B<p>
     *
     * @return QueueHandlerXbh̐
     */
    public int getQueueHandlerSize();
    
    /**
     * ݃nhÕXbh擾B<p>
     *
     * @return ݃nhÕXbh
     */
    public int getActiveQueueHandlerSize();
    
    /**
     * ݑҋ@̃Xbh擾B<p>
     *
     * @return ݑҋ@̃Xbh
     */
    public int getStandbyQueueHandlerSize();
    
    /**
     * L[̏Ԃ̕ς擾B<p>
     *
     * @return Ϗ[ms]
     */
    public long getAverageHandleProcessTime();
}
