/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.system;

/**
 * Iy[VVXeB<p>
 *
 * @author M.Takata
 */
public interface OperationSystem{
    
    /**
     * Iy[VVXe擾B<p>
     *
     * @return Iy[VVXe
     */
    public String getName();
    
    /**
     * CPU擾B<p>
     *
     * @return CPU
     */
    public int getCpuNumbers();
    
    /**
     * CPŨNbN擾B<p>
     *
     * @return CPUNbN
     */
    public long getCpuFrequency();
    
    /**
     * CPU̎gpԂ擾B<p>
     *
     * @return CPUgp
     */
    public CpuTimes getCpuTimes();
    
    /**
     * OCPUgpԂ擾̍CPUgpԂ擾B<p>
     *
     * @return CPUgp
     */
    public CpuTimes getCpuTimesDelta();
    
    /**
     * Ŏw肵CPUgpԂ̍CPUgpԂ擾B<p>
     *
     * @return CPUgp
     */
    public CpuTimes getCpuTimesDelta(CpuTimes prev);
    
    /**
     * ̎gp󋵂擾B<p>
     *
     * @return gp
     */
    public MemoryInfo getPhysicalMemoryInfo();
    
    /**
     * Xbv̎gp󋵂擾B<p>
     *
     * @return Xbvgp
     */
    public MemoryInfo getSwapMemoryInfo();
    
    /**
     * JavavZX̃vZXID擾B<p>
     *
     * @return vZXID
     */
    public int getPid();
    
    /**
     * w肳ꂽvZXIB<p>
     *
     * @param pid vZXID
     * @return vZX݂Ȃꍇfalse
     */
    public boolean kill(int pid);
    
    /**
     * w肳ꂽvZX̏擾B<p>
     *
     * @param pid vZXID
     * @return vZX
     */
    public ProcessInfo getProcessInfo(int pid);
    
    /**
     * w肳ꂽvZXIB<p>
     *
     * @param command R}h̐K\
     * @return vZX݂Ȃꍇfalse
     */
    public boolean kill(String command);
    
    /**
     * w肳ꂽvZX̏擾B<p>
     *
     * @param command R}h̐K\
     * @return vZX
     */
    public ProcessInfo getProcessInfo(String command);
    
    /**
     * SẴvZX̏擾B<p>
     *
     * @return vZX̔z
     */
    public ProcessInfo[] getProcessInfos();
}
