/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

import java.math.*;

/**
 * ۂ߃Ro[^B<p>
 * 
 * @author M.Takata
 */
public class DecimalScaleConverter implements Converter{
    
    private int scale = 0;
    private int roundingMode = BigDecimal.ROUND_HALF_UP;
    private Class<?> returnType;
    
    /**
     * XP[ݒ肷B<p>
     * ftHǵA0B<br>
     *
     * @param scale XP[
     */
    public void setScale(int scale){
        this.scale = scale;
    }
    
    /**
     * XP[擾B<p>
     *
     * @return XP[
     */
    public int getScale(){
        return scale;
    }
    
    /**
     * ۂ߃[hݒ肷B<p>
     * ftHǵA{@link BigDecimal#ROUND_HALF_UP}B<br>
     *
     * @param roundingMode ۂ߃[h
     * @see BigDecimal
     */
    public void setRoundingMode(int roundingMode){
        new BigDecimal(0.0).setScale(scale, roundingMode);
        this.roundingMode = roundingMode;
    }
    
    /**
     * ۂ߃[h擾B<p>
     *
     * @return ۂ߃[h
     */
    public int getRoundingMode(){
        return roundingMode;
    }
    
    /**
     * ϊ̖߂ľ^ݒ肷B<p>
     * ftHǵAnullŁA͂̌^ɑΉ^ŕԂB<br>
     * T|[g^́ABigDecimalADoubleAFloatAStringB<br>
     * 
     * @param type ߂ľ^
     */
    public void setReturnType(Class<?> type){
        if(type != null
            && !type.equals(BigDecimal.class)
            && !type.equals(Double.class)
            && !type.equals(Float.class)
            && !type.equals(String.class)
        ){
            throw new IllegalArgumentException("Unsupported type." + type.getName());
        }
        returnType = type;
    }
    
    /**
     * ϊ̖߂ľ^擾B<p>
     * 
     * @return ߂ľ^
     */
    public Class<?> getReturnType(){
        return returnType;
    }
    
    /**
     * w肳ꂽIuWFNgۂ߂B<p>
     * T|[gȂ^̃IuWFNgnƁÂ܂ܕԂB<br>
     *
     * @param obj ϊΏۂ̃IuWFNg
     * @return ϊ̃IuWFNg
     * @exception ConvertException ϊɎsꍇ
     */
    @Override
    public Object convert(Object obj) throws ConvertException{
        if(obj == null){
            return null;
        }
        Class<?> retType = returnType;
        BigDecimal retVal = null;
        if(obj instanceof BigDecimal){
            retVal = ((BigDecimal)obj).setScale(scale, roundingMode);
            if(retType == null){
                retType = BigDecimal.class;
            }
        }else if(obj instanceof Number){
            retVal = new BigDecimal(((Number)obj).doubleValue()).setScale(scale, roundingMode);
            if(retType == null){
                if(obj instanceof Float){
                    retType = Float.class;
                }else{
                    retType = Double.class;
                }
            }
        }else if(obj instanceof String){
            try{
                retVal = new BigDecimal((String)obj).setScale(scale, roundingMode);
            }catch(NumberFormatException e){
                throw new ConvertException(e);
            }
            if(retType == null){
                retType = String.class;
            }
        }else{
            return obj;
        }
        if(retType.equals(BigDecimal.class)){
            return retVal;
        }else if(retType.equals(Double.class)){
            return new Double(retVal.doubleValue());
        }else if(retType.equals(Float.class)){
            return new Float(retVal.floatValue());
        }else{
            return retVal.toString();
        }
    }
}
