/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;


import static org.testng.Assert.assertEquals;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link SortedMapEditorTest}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class SortedMapEditorTest extends BeansTestBase{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText() throws MalformedURLException{
        return new Object[][]{
            {"A=100", new String[]{"A"}, new String[]{"100"}, new String[]{"A"}},
            {"A=100\nB=200", new String[]{"A", "B"}, new String[]{"100", "200"}, new String[]{"A", "B"}},
            {"B=200\nA=100", new String[]{"A", "B"}, new String[]{"100", "200"}, new String[]{"A", "B"}},
            {"   A = 100  \n  <!-- B=200\nC=300 -->  \n  \"C  \" = \" 300 \"", new String[]{"A", "C  "}, new String[]{"100", " 300 "}, new String[]{"A", "C  "}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.SortedMapEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.SortedMapEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsText")
    @SuppressWarnings("unchecked")
    public void testSetAsText(String paramStr, Object[] getParamArray, Object[] answerArray, Object[] keysArray){
        SortedMapEditor editor = new SortedMapEditor();
        editor.setAsText(paramStr);
        Map<String, Object> map = (Map<String, Object>) editor.getValue();
        
        assertEquals(getParamArray.length, map.size());
        for(int i = 0 ; i < getParamArray.length ; i++){
            assertEquals(answerArray[i], map.get(getParamArray[i]));
        }
        Iterator<String> keys = map.keySet().iterator();
        int keyCount = 0;
        while(keys.hasNext()){
            assertEquals(keysArray[keyCount], keys.next());
            keyCount++;
        }
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty() throws MalformedURLException{
        return new Object[][]{
            {"test.SortedMapEditor.value", "1234", "A=${test.SortedMapEditor.value}\nB=\\u3042", new String[]{"A", "B"}, new String[]{"1234", ""}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.SortedMapEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.SortedMapEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsTextProperty")
    @SuppressWarnings("unchecked")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, Object[] getParamArray, Object[] answerArray){
        SortedMapEditor editor = new SortedMapEditor();
        System.setProperty(propertyKeyStr, propertyValStr);
        editor.setAsText(paramStr);
        Map<String, Object> map = (Map<String, Object>)editor.getValue();
        assertEquals(2, map.size());
        
        for(int i = 0 ; i < getParamArray.length ; i++){
            assertEquals(answerArray[i], map.get(getParamArray[i]));
        }
    }
    
    @Test(groups = {"jp.ossc.nimbus.beans.SortedMapEditor#setValue(java.math.BigDecimal)",
                    "jp.ossc.nimbus.beans.SortedMapEditor#getAsText()",
                    "Normal"})
    public void testSetValue(){
        SortedMapEditor editor = new SortedMapEditor();
        Map<String, Object> map = new TreeMap<String, Object>();
        map.put("A", "100");
        map.put("B", new Integer(200));
        editor.setValue(map);
        assertEquals("A=100" + System.getProperty("line.separator") + "B=200", editor.getAsText());
    }
}
