/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import static org.testng.Assert.*;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link ManagerPropertyMetaData}eXgP[XB<p>
 * 
 * @author M.Takata
 */
public class ManagerPropertyMetaDataTest{

    @DataProvider(name = "ManagerPropertyMetaData")
    public Object[][] dataManagerPropertyMetaData(){
        return new Object[][]{
            {null},
            {new ManagerMetaData()},
        };
    }
    @Test(groups = {"jp.ossc.nimbus.core.ManagerPropertyMetaData#ManagerPropertyMetaData(jp.ossc.nimbus.core.MetaData)",
                    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.PropertyMetaData#.*"},
          dataProvider = "ManagerPropertyMetaData")
    public void testManagerPropertyMetaData(MetaData parent){
        ManagerPropertyMetaData metaData = new ManagerPropertyMetaData(parent);
        assertEquals(metaData.getParent(), parent);
    }
    @Test(groups = {"jp.ossc.nimbus.core.ManagerPropertyMetaData#getTagName()",
    "Normal"},
          dependsOnGroups = {"jp\\.ossc\\.nimbus\\.core\\.PropertyMetaData#.*"})
    public void testGetTagName(){
        ManagerPropertyMetaData metaData = new ManagerPropertyMetaData(null);
        assertEquals(metaData.getTagName(), ManagerPropertyMetaData.MANAGER_PROPERTY_TAG_NAME);
    }
}
