/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Serializable;

/**
 * so[WvpeB̃XL[}`B<p>
 * 
 * @author M.Takata
 */
public class RowVersionPropertySchema implements PropertySchema, Serializable{
    
    private static final long serialVersionUID = 453895053325134198L;

    public static final String DEFAULT_PROPERTY_NAME = "RowVersion";
    
    /**
     * XL[}B<p>
     */
    protected String schema;
    
    /**
     * vpeB̖OB<p>
     */
    protected String name = DEFAULT_PROPERTY_NAME;
    
    @Override
    public void setSchema(String schema) throws PropertySchemaDefineException{
        if(schema != null && schema.length() > 0){
            name = schema;
        }
        this.schema = schema;
    }
    
    @Override
    public String getSchema(){
        return schema;
    }
    
    @Override
    public String getName(){
        return name;
    }
    
    @Override
    public Class<?> getType(){
        return Integer.TYPE;
    }
    
    @Override
    public boolean isPrimaryKey(){
        return false;
    }
    
    @Override
    public Object set(Object val) throws PropertySetException{
        if(val == null){
            return 0;
        }
        if(val instanceof Integer){
            return val;
        }else{
            throw new PropertySetException(this, "Type is invalid." + val.getClass());
        }
    }
    
    @Override
    public Object get(Object val) throws PropertyGetException{
        if(val == null){
            return 0;
        }
        return val;
    }
    
    @Override
    public Object format(Object val) throws PropertyGetException{
        return val;
    }
    
    @Override
    public Object parse(Object val) throws PropertySetException{
        if(val == null){
            return new Integer(0);
        }
        if(val instanceof Integer){
            return val;
        }else if(val instanceof Number){
            return new Integer(((Number)val).intValue());
        }else if(val instanceof String){
            try{
                return Integer.parseInt((String)val);
            }catch(NumberFormatException e){
                throw new PropertySetException(this, e);
            }
        }else{
            throw new PropertySetException(this, "Type is invalid." + val.getClass());
        }
    }
    
    @Override
    public boolean validate(Object val) throws PropertyValidateException{
        return true;
    }
    
    /**
     * ̃XL[}̕\擾B<p>
     *
     * @return \
     */
    @Override
    public String toString(){
        final StringBuilder buf = new StringBuilder(getClass().getName());
        buf.append('{');
        buf.append("name=").append(name);
        buf.append('}');
        return buf.toString();
    }
}
