/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

/**
 * vpeBGfB^Q&lt;property-editors&gt;vf^f[^B<p>
 * T[rX`t@C&lt;property-editors&gt;vfɋLqꂽei[郁^f[^ReiłB<p>
 *
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class PropertyEditorsMetaData extends MetaData
 implements Serializable{
    
    private static final long serialVersionUID = -5406841425716158865L;
    
    /**
     * &lt;nimbus&gt;vf̎qvf&lt;property-editors&gt;vf̗vfB<p>
     */
    public static final String PROPERTY_EDITORS_TAG_NAME = "property-editors";
    
    private final Map<String, PropertyEditorMetaData> propertyEditors = new LinkedHashMap<String, PropertyEditorMetaData>();
    
    private List<IfDefMetaData> ifDefMetaDataList;
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     */
    public PropertyEditorsMetaData(MetaData parent){
        super(parent);
    }
    
    /**
     * &lt;property-editors&gt;vf̎qvf&lt;property-editor&gt;擾B<p>
     * 
     * @param type PropertyEditorT|[gNX
     * @return PropertyEditor̃NX
     */
    public String getPropertyEditor(String type){
        PropertyEditorMetaData propData = propertyEditors.get(type);
        return propData == null ? null : propData.getEditor();
    }
    
    /**
     * &lt;property-editors&gt;vf̎qvf&lt;property-editor&gt;ݒ肷B<p>
     * 
     * @param type PropertyEditorT|[gNX
     * @param editor PropertyEditor̃NX
     */
    public void setPropertyEditor(String type, String editor){
        PropertyEditorMetaData propData = propertyEditors.get(type);
        if(propData != null){
            propData.setEditor(editor);
        }else{
            propData = new PropertyEditorMetaData(this);
            propData.setType(type);
            propData.setEditor(editor);
            propertyEditors.put(type, propData);
        }
    }
    
    /**
     * &lt;property-editors&gt;vf̎qvf&lt;property-editor&gt;폜B<p>
     * 
     * @param type PropertyEditorT|[gNX
     */
    public void removePropertyEditor(String type){
        propertyEditors.remove(type);
    }
    
    /**
     * &lt;property-editors&gt;vf̎qvf&lt;property-editor&gt;Sč폜B<p>
     */
    public void clearPropertyEditors(){
        propertyEditors.clear();
    }
    
    /**
     * &lt;property-editors&gt;vf̎qvf&lt;property-editor&gt;擾B<p>
     * 
     * @param type PropertyEditorT|[gNX
     * @return &lt;property-editor&gt;vf̃^f[^
     */
    public PropertyEditorMetaData getPropertyEditorMetaData(String type){
        return propertyEditors.get(type);
    }
    
    /**
     * &lt;property-editors&gt;vf̎qvf&lt;property-editor&gt;ݒ肷B<p>
     * 
     * @param propEditorData &lt;property-editor&gt;vf̃^f[^
     */
    public void setPropertyEditorMetaData(PropertyEditorMetaData propEditorData){
        propertyEditors.put(propEditorData.getType(), propEditorData);
    }
    
    /**
     * &lt;property-editors&gt;vf̎qvf&lt;property-editor&gt;typȅW擾B<p>
     * 
     * @return qvf&lt;property-editor&gt;typȅW
     */
    public Set<String> getPropertyEditorTypes(){
        return propertyEditors.keySet();
    }
    
    /**
     * &lt;property-editors&gt;vfElementp[XāAg̏Ayюqvf̃^f[^̐sB<p>
     *
     * @param element &lt;property-editors&gt;vfElement
     * @exception DeploymentException &lt;property-editors&gt;vf̉́Ǎʂɂ郁^f[^̐Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        super.importXML(element);
        if(!element.getTagName().equals(PROPERTY_EDITORS_TAG_NAME)){
            throw new DeploymentException(
                "Tag must be " + PROPERTY_EDITORS_TAG_NAME + " : "
                 + element.getTagName()
            );
        }
        
        importXMLInner(element, null);
        
        final Iterator<Element> ifDefElements = getChildrenByTagName(
            element,
            IfDefMetaData.IFDEF_TAG_NAME
        );
        while(ifDefElements.hasNext()){
            if(ifDefMetaDataList == null){
                ifDefMetaDataList = new ArrayList<IfDefMetaData>();
            }
            final IfDefMetaData ifdefData
                 = new IfDefMetaData(this);
            ifdefData.importXML((Element)ifDefElements.next());
            ifDefMetaDataList.add(ifdefData);
        }
        
        if(ifDefMetaDataList == null || ifDefMetaDataList.size() == 0){
            return;
        }
        
        for(int i = 0, imax = ifDefMetaDataList.size(); i < imax; i++){
            IfDefMetaData ifdefData = ifDefMetaDataList.get(i);
            Element ifDefElement = ifdefData.getElement();
            if(ifDefElement == null){
                continue;
            }
            
            importXMLInner(ifDefElement, ifdefData);
            
            ifdefData.setElement(null);
        }
    }
    
    protected void importXMLInner(Element element, IfDefMetaData ifdefData) throws DeploymentException{
        
        final boolean ifdefMatch
            = ifdefData == null ? true : ifdefData.isMatch();
        
        Iterator<Element> editorElements = getChildrenByTagName(
            element,
            PropertyEditorMetaData.PROPERTY_EDITOR_TAG_NAME
        );
        while(editorElements.hasNext()){
            PropertyEditorMetaData propData = new PropertyEditorMetaData(this);
            if(ifdefData != null){
                propData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(propData);
            }
            propData.importXML((Element)editorElements.next());
            if(ifdefMatch){
                if(propertyEditors.containsKey(propData.getType())){
                    throw new DeploymentException("Element of " + PropertyEditorMetaData.PROPERTY_EDITOR_TAG_NAME + " is duplicated type. type=" + propData.getType());
                }
                setPropertyEditorMetaData(propData);
            }
        }
    }
    
    @Override
    public StringBuilder toXML(StringBuilder buf){
        appendComment(buf);
        buf.append('<').append(PROPERTY_EDITORS_TAG_NAME).append('>');
        buf.append(LINE_SEPARATOR);
        final StringBuilder subBuf = new StringBuilder();
        for(PropertyEditorMetaData propData : propertyEditors.values()){
            if(propData.getIfDefMetaData() == null){
                propData.toXML(subBuf);
                subBuf.append(LINE_SEPARATOR);
            }
        }
        if(ifDefMetaDataList != null && ifDefMetaDataList.size() != 0){
            for(int i = 0, imax = ifDefMetaDataList.size(); i < imax; i++){
                IfDefMetaData ifdefData = ifDefMetaDataList.get(i);
                ifdefData.toXML(subBuf);
                subBuf.append(LINE_SEPARATOR);
            }
        }
        if(subBuf.length() != 0){
            buf.append(addIndent(subBuf));
        }
        buf.append("</").append(PROPERTY_EDITORS_TAG_NAME).append('>');
        return buf;
    }
}