/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * `FbN|Cgg[T[B<p>
 *
 * @author M.Takata
 */
public class CheckPointTracerService extends ServiceBase
 implements CheckPointTracerServiceMBean{
    
    private static final long serialVersionUID = -5613434425756392467L;
    private boolean isEnabled = true;
    private Map<String, List<CheckPoint>> checkPointTraceMap;
    
    // CheckPointTracerServiceMBeanJavaDoc
    public void setEnabled(boolean enabled){
        isEnabled = enabled;
    }
    
    // CheckPointTracerServiceMBeanJavaDoc
    public boolean isEnabled(){
        return isEnabled;
    }
    
    public void createService() throws Exception{
        checkPointTraceMap = Collections.synchronizedMap(new HashMap<String, List<CheckPoint>>());
    }
    public void stopService() throws Exception{
        clear();
    }
    
    // CheckPointTracerServiceMBeanJavaDoc
    public CheckPoint[] getCheckPointTrace(String threadName){
        if(getState() != State.STARTED){
            return new CheckPoint[0];
        }
        List<CheckPoint> checkPointTrace = checkPointTraceMap.get(threadName);
        if(checkPointTrace == null){
            return new CheckPoint[0];
        }
        synchronized(checkPointTrace){
            return checkPointTrace.toArray(new CheckPoint[checkPointTrace.size()]);
        }
    }
    
    // CheckPointTracerServiceMBeanJavaDoc
    public void clear(String threadName){
        if(getState() != State.STARTED){
            return;
        }
        List<CheckPoint> checkPointTrace = checkPointTraceMap.get(threadName);
        if(checkPointTrace == null){
            return;
        }
        synchronized(checkPointTrace){
            checkPointTrace.clear();
        }
    }
    
    // CheckPointTracerServiceMBeanJavaDoc
    public void clear(){
        if(checkPointTraceMap != null){
            checkPointTraceMap.clear();
        }
    }
    
    // CheckPointTracerServiceMBeanJavaDoc
    public void passedCheckPoint(String threadName, CheckPoint point){
        if(getState() != State.STARTED || !isEnabled){
            return;
        }
        List<CheckPoint> checkPointTrace = checkPointTraceMap.get(threadName);
        if(checkPointTrace == null){
            checkPointTrace = new ArrayList<CheckPoint>();
            checkPointTraceMap.put(threadName, checkPointTrace);
        }
        synchronized(checkPointTrace){
            checkPointTrace.add(point);
        }
    }
}
