/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Map;

import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link ExceptionHandlingInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see ExceptionHandlingInterceptorService
 */
public interface ExceptionHandlingInterceptorServiceMBean
 extends ServletFilterInterceptorServiceMBean{
    
    /**
     * ONX{@link ExceptionHandler}T[rX̃T[rX̃}bsOݒ肷B<p>
     * ONX̎ɑ΂āAtꍇ́AONX()̏ŎwłB<br>
     * ́AThe Apache Jakarta Project Commons Jexl(http://jakarta.apache.org/commons/jexl/)gpB<br>
     * ÕvpeBQƂꍇ́Aprop:get(exception, vpeB)Ŏw肷B<br>
     * ServletRequest̃vpeBQƂꍇ́AvpeB\镶"@request.""@"ň͂Ŏw肷B<br>
     * ServletResponsẽvpeBQƂꍇ́AvpeB\镶"@response.""@"ň͂Ŏw肷B<br>
     * ŌAvpeB̊TÓAJava Beans̃vpeB̊TOLA{@link jp.ossc.nimbus.beans.PropertyFactory PropertyFactory}̋Kɏ]B<br>
     * <pre>
     *  F"java.sql.SQLException(exception.ErrorCode == 1013)"=Nimbus#SQLExceptionHandler
     * </pre>
     *
     * @param map ONXExceptionHandlerT[rX̃T[rX̃}bsOBONX=ExceptionHandlerT[rX̃T[rX
     */
    public void setExceptionAndHandlerMapping(Map<String, String> map);
    
    /**
     * ONX{@link ExceptionHandler}T[rX̃T[rX̃}bsO擾B<p>
     *
     * @return ONXExceptionHandlerT[rX̃T[rX̃}bsO
     */
    public Map<String, String> getExceptionAndHandlerMapping();
    
    /**
     * OɃ}bsOꂽ{@link ExceptionHandler}T[rXȂꍇɎgpExceptionHandlerT[rX̃T[rXݒ肷B<p>
     *
     * @param name ExceptionHandlerT[rX̃T[rX
     */
    public void setDefaultExceptionHandlerServiceName(ServiceName name);
    
    /**
     * OɃ}bsOꂽ{@link ExceptionHandler}T[rXȂꍇɎgpExceptionHandlerT[rX̃T[rX擾B<p>
     *
     * @return ExceptionHandlerT[rX̃T[rX
     */
    public ServiceName getDefaultExceptionHandlerServiceName();
}
