/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * `[gB<p>
 *
 * @author k2-taniguchi
 */
public class ChartConditionImpl
 implements ChartCondition, java.io.Serializable {
    
    private static final long serialVersionUID = 3418497509927014515L;
    
    /** vbgXg */
    private Map<String, List<PlotCondition>> plotConditionMap;
    private List<PlotCondition> plotConditionList;
    private String title;
    private String titleFontName;
    private int titleFontStyle = -1;
    private int titleFontSize = -1;
    private String defaultSubtitleFontName;
    private int defaultSubtitleFontStyle = Integer.MIN_VALUE;
    private int defaultSubtitleFontSize = Integer.MIN_VALUE;
    private Map<Integer, String> subtitleFontNameMap;
    private Map<Integer, Integer> subtitleFontStyleMap;
    private Map<Integer, Integer> subtitleFontSizeMap;

    /**
     * RXgN^B<p>
     */
    public ChartConditionImpl() {
    }

    // ChartConditionJavaDoc
    public void addPlotCondition(PlotCondition plotCondition) {
        if(plotConditionMap == null){
            plotConditionMap = new HashMap<String, List<PlotCondition>>();
        }
        if(plotConditionList == null){
            plotConditionList = new ArrayList<PlotCondition>();
        }
        List<PlotCondition> conds = null;
        if(plotConditionMap.containsKey(plotCondition.getName())){
            conds = plotConditionMap.get(plotCondition.getName());
        }else{
            conds = new ArrayList<PlotCondition>();
            plotConditionMap.put(plotCondition.getName(), conds);
        }
        conds.add(plotCondition);
        plotConditionList.add(plotCondition);
    }

    // ChartConditionJavaDoc
    public PlotCondition[] getPlotConditions(String plotName) {
        if(plotConditionMap == null){
            return new PlotCondition[0];
        }
        if(plotConditionMap.containsKey(plotName)){
            List<PlotCondition> conds = plotConditionMap.get(plotName);
            return conds.toArray(new PlotCondition[conds.size()]);
        }
        return new PlotCondition[0];
    }

    // ChartConditionJavaDoc
    public PlotCondition[] getPlotConditions() {
        if(plotConditionList == null){
            return new PlotCondition[0];
        }
        return (PlotCondition[]) plotConditionList
            .toArray(new PlotCondition[plotConditionList.size()]);
    }

    // ChartConditionJavaDoc
    public Iterator<String> getPlotNames() {
        return plotConditionMap.keySet().iterator();
    }

    // ChartConditionJavaDoc
    public void setTitle(String title) {
        this.title = title;
    }

    // ChartConditionJavaDoc
    public String getTitle() {
        return title;
    }

    // ChartConditionJavaDoc
    public void setTitleFontName(String name) {
        titleFontName = name;
    }

    // ChartConditionJavaDoc
    public String getTitleFontName() {
        return titleFontName;
    }

    // ChartConditionJavaDoc
    public void setTitleFontStyle(int style) {
        titleFontStyle = style;
    }

    // ChartConditionJavaDoc
    public int getTitleFontStyle() {
        return titleFontStyle;
    }

    // ChartConditionJavaDoc
    public void setTitleFontSize(int size) {
        titleFontSize = size;
    }

    // ChartConditionJavaDoc
    public int getTitleFontSize() {
        return titleFontSize;
    }

    // ChartConditionJavaDoc
    public void setDefaultSubtitleFontName(String name) {
        defaultSubtitleFontName = name;
    }

    // ChartConditionJavaDoc
    public String getDefaultSubtitleFontName() {
        return defaultSubtitleFontName;
    }

    // ChartConditionJavaDoc
    public void setDefaultSubtitleFontStyle(int style) {
        defaultSubtitleFontStyle = style;
    }

    // ChartConditionJavaDoc
    public int getDefaultSubtitleFontStyle() {
        return defaultSubtitleFontStyle;
    }

    // ChartConditionJavaDoc
    public void setDefaultSubtitleFontSize(int size) {
        defaultSubtitleFontSize = size;
    }

    // ChartConditionJavaDoc
    public int getDefaultSubtitleFontSize() {
        return defaultSubtitleFontSize;
    }

    // ChartConditionJavaDoc
    public void setSubtitleFontName(int index, String name) {
        if (subtitleFontNameMap == null) {
            subtitleFontNameMap = new HashMap<Integer, String>();
        }
        subtitleFontNameMap.put(index, name);
    }

    // ChartConditionJavaDoc
    public String getSubtitleFontName(int index) {
        if(subtitleFontNameMap == null){
            return null;
        }
        Integer key = new Integer(index);
        if (subtitleFontNameMap.containsKey(key)) {
            return subtitleFontNameMap.get(key);
        }
        return null;
    }

    // ChartConditionJavaDoc
    public void setSubtitleFontStyle(int index, int style) {
        if (subtitleFontStyleMap == null) {
            subtitleFontStyleMap = new HashMap<Integer, Integer>();
        }
        subtitleFontStyleMap.put(index, new Integer(style));
    }

    // ChartConditionJavaDoc
    public int getSubtitleFontStyle(int index) {
        if(subtitleFontStyleMap == null){
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (subtitleFontStyleMap.containsKey(key)) {
            return subtitleFontStyleMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    // ChartConditionJavaDoc
    public void setSubtitleFontSize(int index, int size) {
        if (subtitleFontSizeMap == null) {
            subtitleFontSizeMap = new HashMap<Integer, Integer>();
        }
        subtitleFontSizeMap.put(index, size);
    }

    // ChartConditionJavaDoc
    public int getSubtitleFontSize(int index) {
        if(subtitleFontSizeMap == null){
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (subtitleFontSizeMap.containsKey(key)) {
            return subtitleFontSizeMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

}
