/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link TimeSeriesCollectionFactoryService}MBeanC^tF[XB<p>
 *
 * @author M.Takata
 */
public interface TimeSeriesCollectionFactoryServiceMBean extends ServiceBaseMBean{
    
    /** l܂Ƃ߂鏈^Cv : Jn */
    public static final int COLLATE_DATA_TYPE_START = 1;
    /** l܂Ƃ߂鏈^Cv : I */
    public static final int COLLATE_DATA_TYPE_END = 2;
    /** l܂Ƃ߂鏈^Cv : S */
    public static final int COLLATE_DATA_TYPE_ALL = 3;
    /** l܂Ƃ߂鏈^Cv :  */
    public static final int COLLATE_DATA_TYPE_AVERAGE = 4;
    /** l܂Ƃ߂鏈^Cv : OHLC */
    public static final int COLLATE_DATA_TYPE_OHLC = 5;
    /** l܂Ƃ߂鏈^Cv : v */
    public static final int COLLATE_DATA_TYPE_SUM = 6;
    
    /**
     * ԖɃf[^Wv1_ɏW񂷂ꍇɁA1_̎ƂāAԂ̊JnԂ̗pʁB<p>
     */
    public static final int COLLATE_DATA_DATE_TYPE_START = 1;
    
    /**
     * ԖɃf[^Wv1_ɏW񂷂ꍇɁA1_̎ƂāAԂ̏IԂ̗pʁB<p>
     */
    public static final int COLLATE_DATA_DATE_TYPE_END = 2;
    
    /**
     * f[^Zbgݒ肷B<p>
     * ftHǵAT[rXB<br>
     *
     * @param name f[^Zbg
     */
    public void setName(String name);
    
    /**
     * f[^Zbg擾B<p>
     *
     * @return f[^Zbg
     */
    public String getName();
    
    /**
     * w肳ꂽV[YTimePeriodNXݒ肷B<p>
     * 
     * @param seriesName V[Y
     * @param clazz TimePeriodNX
     */
    public void setTimePeriodClass(String seriesName, Class<?> clazz);
    
    /**
     * w肳ꂽV[YTimePeriodNX擾B<p>
     * 
     * @param seriesName V[Y
     * @return TimePeriodNX
     */
    public Class<?> getTimePeriodClass(String seriesName);
    
    /**
     * l܂Ƃ߂ꍇ̏^Cvݒ肷B<p>
     * 
     * @param type ^Cv
     */
    public void setCollateDataType(int type);
    
    /**
     * l܂Ƃ߂ꍇ̏^Cv擾B<p>
     * 
     * @return ^Cv
     */
    public int getCollateDataType();
    
    /**
     * l𖳎邩擾B<p>
     * 
     * @return true:/false:Ȃ
     */
    public boolean isIgnoreSameValue();
    
    /**
     * l𖳎邩ݒ肷B<p>
     * 
     * @param isIgnore true:/false:Ȃ
     */
    public void setIgnoreSameValue(boolean isIgnore);
    
    /**
     * w肳ꂽԃtB[hƎw肳ꂽԂ̒ŁAf[^܂Ƃ߂Ԃݒ肷B<p>
     * 
     * @param field ԃtB[h
     * @param period Ԃ̒
     */
    public void setCollateDataPeriod(int field, int period);
    
    /**
     * w肳ꂽԃtB[hƎw肳ꂽԂ̒ŁA͑Ώۂ̃f[^ǂԂœĂ̂ݒ肷B<p>
     * 
     * @param field ԃtB[h
     * @param period Ԃ̒
     */
    public void setInputDataPeriod(int field, int period);
    
    /**
     * @\gp邩ݒ肷B<p>
     * 
     * @param isAuto true:/false:Ȃ
     */
    public void setAutoTimesharing(boolean isAuto);
    
    /**
     * @\gp邩擾B<P>
     * 
     * @return true:/false:Ȃ
     */
    public boolean isAutoTimesharing();
    
    /**
     * ԖɃf[^Wv1_ɏW񂷂ꍇɁA1_̎ǂ̂悤ɍ̗p邩ݒ肷B<p>
     * ftHǵA{@link #COLLATE_DATA_DATE_TYPE_START}B<br>
     *
     * @param type ̗̍p@
     * @see #COLLATE_DATA_DATE_TYPE_START
     * @see #COLLATE_DATA_DATE_TYPE_END
     */
    public void setCollateDataDateType(int type);
    
    /**
     * ԖɃf[^Wv1_ɏW񂷂ꍇɁA1_̎ǂ̂悤ɍ̗p邩擾B<p>
     *
     * @return ̗̍p@
     */
    public int getCollateDataDateType();
}
