/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import java.util.HashMap;
import java.util.Map;

public class XYPlotConditionImpl extends PlotConditionImpl
    implements XYPlotCondition {
    
    private static final long serialVersionUID = 8417050199185753740L;
    
    /** c̉ */
    private Map<Integer, Boolean> rangeAxisVisibleMap = null;
    private String defaultDomainAxisTickLabelFontName;
    private int defaultDomainAxisTickLabelFontStyle = Integer.MIN_VALUE;
    private int defaultDomainAxisTickLabelFontSize = Integer.MIN_VALUE;
    private String defaultRangeAxisTickLabelFontName;
    private int defaultRangeAxisTickLabelFontStyle = Integer.MIN_VALUE;
    private int defaultRangeAxisTickLabelFontSize = Integer.MIN_VALUE;
    private Map<Integer, String> domainAxisTickLabelFontNameMap;
    private Map<Integer, Integer> domainAxisTickLabelFontStyleMap;
    private Map<Integer, Integer> domainAxisTickLabelFontSizeMap;
    private Map<Integer, String> rangeAxisTickLabelFontNameMap;
    private Map<Integer, Integer> rangeAxisTickLabelFontStyleMap;
    private Map<Integer, Integer> rangeAxisTickLabelFontSizeMap;
    private String defaultDomainAxisLabelFontName;
    private int defaultDomainAxisLabelFontStyle = Integer.MIN_VALUE;
    private int defaultDomainAxisLabelFontSize = Integer.MIN_VALUE;
    private String defaultRangeAxisLabelFontName;
    private int defaultRangeAxisLabelFontStyle = Integer.MIN_VALUE;
    private int defaultRangeAxisLabelFontSize = Integer.MIN_VALUE;
    private Map<Integer, String> domainAxisLabelFontNameMap;
    private Map<Integer, Integer> domainAxisLabelFontStyleMap;
    private Map<Integer, Integer> domainAxisLabelFontSizeMap;
    private Map<Integer, String> rangeAxisLabelFontNameMap;
    private Map<Integer, Integer> rangeAxisLabelFontStyleMap;
    private Map<Integer, Integer> rangeAxisLabelFontSizeMap;

    // XYPlotConditionJavaDoc
    public void setRangeAxisVisible(int index, Boolean visible) {
        if(rangeAxisVisibleMap == null){
            rangeAxisVisibleMap = new HashMap<Integer, Boolean>();
        }
        rangeAxisVisibleMap.put(index, visible);
    }

    // XYPlotConditionJavaDoc
    public Boolean isRangeAxisVisible(int index) {
        if(rangeAxisVisibleMap == null){
            return null;
        }
        Integer key = new Integer(index);
        if (rangeAxisVisibleMap.containsKey(key)) {
            return rangeAxisVisibleMap.get(key);
        }
        return null;
    }

    public Map<Integer, Boolean> getRangeAxisVisibleMap() {
        return rangeAxisVisibleMap;
    }

    public void addRangeAxisVisibleMap(Map<Integer, Boolean> map) {
        if (rangeAxisVisibleMap == null) {
            rangeAxisVisibleMap = new HashMap<Integer, Boolean>();
        }
        rangeAxisVisibleMap.putAll(map);
    }

//    public Map getDomainAxisTickLabelFontMap() {
//        return domainAxisTickLabelFontMap;
//    }
//
//    public void addDomainAxisTickLabelFontMap(Map map) {
//        if(domainAxisTickLabelFontMap == null){
//            domainAxisTickLabelFontMap = new HashMap();
//        }
//        domainAxisTickLabelFontMap.putAll(map);
//    }

    public void setDefaultDomainAxisTickLabelFontName(String name) {
        defaultDomainAxisTickLabelFontName = name;
    }

    public String getDefaultDomainAxisTickLabelFontName() {
        return defaultDomainAxisTickLabelFontName;
    }

    public void setDefaultDomainAxisTickLabelFontStyle(int style) {
        defaultDomainAxisTickLabelFontStyle = style;
    }

    public int getDefaultDomainAxisTickLabelFontStyle() {
        return defaultDomainAxisTickLabelFontStyle;
    }

    public void setDefaultDomainAxisTickLabelFontSize(int size) {
        defaultDomainAxisTickLabelFontSize = size;
    }

    public int getDefaultDomainAxisTickLabelFontSize() {
        return defaultDomainAxisTickLabelFontSize;
    }

    public void setDefaultRangeAxisTickLabelFontName(String name) {
        defaultRangeAxisTickLabelFontName = name;
    }

    public String getDefaultRangeAxisTickLabelFontName() {
        return defaultRangeAxisTickLabelFontName;
    }

    public void setDefaultRangeAxisTickLabelFontStyle(int style) {
        defaultRangeAxisTickLabelFontStyle = style;
    }

    public int getDefaultRangeAxisTickLabelFontStyle() {
        return defaultRangeAxisTickLabelFontStyle;
    }

    public void setDefaultRangeAxisTickLabelFontSize(int size) {
        defaultRangeAxisTickLabelFontSize = size;
    }

    public int getDefaultRangeAxisTickLabelFontSize() {
        return defaultRangeAxisTickLabelFontSize;
    }

    public void setDomainAxisTickLabelFontName(int index, String name) {
        if (domainAxisTickLabelFontNameMap == null) {
            domainAxisTickLabelFontNameMap = new HashMap<Integer, String>();
        }
        domainAxisTickLabelFontNameMap.put(index, name);
    }

    public String getDomainAxisTickLabelFontName(int index) {
        if (domainAxisTickLabelFontNameMap == null) {
            return null;
        }
        Integer key = new Integer(index);
        if(domainAxisTickLabelFontNameMap.containsKey(key)){
            return (String) domainAxisTickLabelFontNameMap.get(key);
        }
        return null;
    }

    public Map<Integer, String> getDomainAxisTickLabelFontNameMap() {
        return domainAxisTickLabelFontNameMap;
    }

    public void addDomainAxisTickLabelFontNameMap(Map<Integer, String> map) {
        if (domainAxisTickLabelFontNameMap == null) {
            domainAxisTickLabelFontNameMap = new HashMap<Integer, String>();
        }
        domainAxisTickLabelFontNameMap.putAll(map);
    }

    public void setDomainAxisTickLabelFontStyle(int index, int style) {
        if (domainAxisTickLabelFontStyleMap == null) {
            domainAxisTickLabelFontStyleMap = new HashMap<Integer, Integer>();
        }
        domainAxisTickLabelFontStyleMap.put(index, style);
    }

    public int getDomainAxisTickLabelFontStyle(int index) {
        if (domainAxisTickLabelFontStyleMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (domainAxisTickLabelFontStyleMap.containsKey(key)) {
            return domainAxisTickLabelFontStyleMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    public Map<Integer, Integer> getDomainAxisTickLabelFontStyleMap() {
        return domainAxisTickLabelFontStyleMap;
    }

    public void addDomainAxisTickLabelFontStyleMap(Map<Integer, Integer> map) {
        if (domainAxisTickLabelFontStyleMap == null) {
            domainAxisTickLabelFontStyleMap = new HashMap<Integer, Integer>();
        }
        domainAxisTickLabelFontStyleMap.putAll(map);
    }

    public void setDomainAxisTickLabelFontSize(int index, int size) {
        if (domainAxisTickLabelFontSizeMap == null) {
            domainAxisTickLabelFontSizeMap = new HashMap<Integer, Integer>();
        }
        domainAxisTickLabelFontSizeMap.put(index, size);
    }

    public int getDomainAxisTickLabelFontSize(int index) {
        if (domainAxisTickLabelFontSizeMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (domainAxisTickLabelFontSizeMap.containsKey(key)) {
            return domainAxisTickLabelFontSizeMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    public Map<Integer, Integer> getDomainAxisTickLabelFontSizeMap() {
        return domainAxisTickLabelFontSizeMap;
    }

    public void addDomainAxisTickLabelFontSizeMap(Map<Integer, Integer> map) {
        if (domainAxisTickLabelFontSizeMap == null) {
            domainAxisTickLabelFontSizeMap = new HashMap<Integer, Integer>();
        }
        domainAxisTickLabelFontSizeMap.putAll(map);
    }

    public void setRangeAxisTickLabelFontName(int index, String name) {
        if (rangeAxisTickLabelFontNameMap == null) {
            rangeAxisTickLabelFontNameMap = new HashMap<Integer, String>();
        }
        rangeAxisTickLabelFontNameMap.put(index, name);
    }

    public String getRangeAxisTickLabelFontName(int index) {
        if (rangeAxisTickLabelFontNameMap == null) {
            return null;
        }
        Integer key = new Integer(index);
        if(rangeAxisTickLabelFontNameMap.containsKey(key)){
            return rangeAxisTickLabelFontNameMap.get(key);
        }
        return null;
    }

    public Map<Integer, String> getRangeAxisTickLabelFontNameMap() {
        return rangeAxisTickLabelFontNameMap;
    }

    public void addRangeAxisTickLabelFontNameMap(Map<Integer, String> map) {
        if (rangeAxisTickLabelFontNameMap == null) {
            rangeAxisTickLabelFontNameMap = new HashMap<Integer, String>();
        }
        rangeAxisTickLabelFontNameMap.putAll(map);
    }

    public void setRangeAxisTickLabelFontStyle(int index, int style) {
        if (rangeAxisTickLabelFontStyleMap == null) {
            rangeAxisTickLabelFontStyleMap = new HashMap<Integer, Integer>();
        }
        rangeAxisTickLabelFontStyleMap.put(index, style);
    }

    public int getRangeAxisTickLabelFontStyle(int index) {
        if (rangeAxisTickLabelFontStyleMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (rangeAxisTickLabelFontStyleMap.containsKey(key)) {
            return rangeAxisTickLabelFontStyleMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    public Map<Integer, Integer> getRangeAxisTickLabelFontStyleMap() {
        return rangeAxisTickLabelFontStyleMap;
    }

    public void addRangeAxisTickLabelFontStyleMap(Map<Integer, Integer> map) {
        if (rangeAxisTickLabelFontStyleMap == null) {
            rangeAxisTickLabelFontStyleMap = new HashMap<Integer, Integer>();
        }
        rangeAxisTickLabelFontStyleMap.putAll(map);
    }

    public void setRangeAxisTickLabelFontSize(int index, int size) {
        if (rangeAxisTickLabelFontSizeMap == null) {
            rangeAxisTickLabelFontSizeMap = new HashMap<Integer, Integer>();
        }
        rangeAxisTickLabelFontSizeMap.put(index, size);
    }

    public int getRangeAxisTickLabelFontSize(int index) {
        if (rangeAxisTickLabelFontSizeMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (rangeAxisTickLabelFontSizeMap.containsKey(key)) {
            return rangeAxisTickLabelFontSizeMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    public Map<Integer, Integer> getRangeAxisTickLabelFontSizeMap() {
        return rangeAxisTickLabelFontSizeMap;
    }

    public void addRangeAxisTickLabelFontSizeMap(Map<Integer, Integer> map) {
        if (rangeAxisTickLabelFontSizeMap == null) {
            rangeAxisTickLabelFontSizeMap = new HashMap<Integer, Integer>();
        }
        rangeAxisTickLabelFontSizeMap.putAll(map);
    }

    public void setDefaultDomainAxisLabelFontName(String name) {
        defaultDomainAxisLabelFontName = name;
    }

    public String getDefaultDomainAxisLabelFontName() {
        return defaultDomainAxisLabelFontName;
    }

    public void setDefaultDomainAxisLabelFontStyle(int style) {
        defaultDomainAxisLabelFontStyle = style;
    }

    public int getDefaultDomainAxisLabelFontStyle() {
        return defaultDomainAxisLabelFontStyle;
    }

    public void setDefaultDomainAxisLabelFontSize(int size) {
        defaultDomainAxisLabelFontSize = size;
    }
    public int getDefaultDomainAxisLabelFontSize() {
        return defaultDomainAxisLabelFontSize;
    }

    public void setDefaultRangeAxisLabelFontName(String name) {
        defaultRangeAxisLabelFontName = name;
    }

    public String getDefaultRangeAxisLabelFontName() {
        return defaultRangeAxisLabelFontName;
    }

    public void setDefaultRangeAxisLabelFontStyle(int style) {
        defaultRangeAxisLabelFontStyle = style;
    }

    public int getDefaultRangeAxisLabelFontStyle() {
        return defaultRangeAxisLabelFontStyle;
    }

    public void setDefaultRangeAxisLabelFontSize(int size) {
        defaultRangeAxisLabelFontSize = size;
    }

    public int getDefaultRangeAxisLabelFontSize() {
        return defaultRangeAxisLabelFontSize;
    }

    public void setDomainAxisLabelFontName(int index, String name) {
        if (domainAxisLabelFontNameMap == null) {
            domainAxisLabelFontNameMap = new HashMap<Integer, String>();
        }
        domainAxisLabelFontNameMap.put(new Integer(index), name);
    }
    public String getDomainAxisLabelFontName(int index) {
        if (domainAxisLabelFontNameMap == null) {
            return null;
        }
        Integer key = new Integer(index);
        if(domainAxisLabelFontNameMap.containsKey(key)){
            return domainAxisLabelFontNameMap.get(key);
        }
        return null;
    }

    public Map<Integer, String> getDomainAxisLabelFontNameMap() {
        return domainAxisLabelFontNameMap;
    }

    public void addDomainAxisLabelFontNameMap(Map<Integer, String> map) {
        if (domainAxisLabelFontNameMap == null) {
            domainAxisLabelFontNameMap = new HashMap<Integer, String>();
        }
        domainAxisLabelFontNameMap.putAll(map);
    }

    public void setDomainAxisLabelFontStyle(int index, int style) {
        if (domainAxisLabelFontStyleMap == null) {
            domainAxisLabelFontStyleMap = new HashMap<Integer, Integer>();
        }
        domainAxisLabelFontStyleMap.put(index, style);
    }
    public int getDomainAxisLabelFontStyle(int index) {
        if (domainAxisLabelFontStyleMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (domainAxisLabelFontStyleMap.containsKey(key)) {
            return domainAxisLabelFontStyleMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    public Map<Integer, Integer> getDomainAxisLabelFontStyleMap() {
        return domainAxisLabelFontStyleMap;
    }

    public void addDomainAxisLabelFontStyleMap(Map<Integer, Integer> map) {
        if (domainAxisLabelFontStyleMap == null) {
            domainAxisLabelFontStyleMap = new HashMap<Integer, Integer>();
        }
        domainAxisLabelFontStyleMap.putAll(map);
    }

    public void setDomainAxisLabelFontSize(int index, int size) {
        if (domainAxisLabelFontSizeMap == null) {
            domainAxisLabelFontSizeMap = new HashMap<Integer, Integer>();
        }
        domainAxisLabelFontSizeMap.put(index, size);
    }

    public int getDomainAxisLabelFontSize(int index) {
        if (domainAxisLabelFontSizeMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (domainAxisLabelFontSizeMap.containsKey(key)) {
            return domainAxisLabelFontSizeMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    public Map<Integer, Integer> getDomainAxisLabelFontSizeMap() {
        return domainAxisLabelFontSizeMap;
    }

    public void addDomainAxisLabelFontSizeMap(Map<Integer, Integer> map) {
        if (domainAxisLabelFontSizeMap == null) {
            domainAxisLabelFontSizeMap = new HashMap<Integer, Integer>();
        }
        domainAxisLabelFontSizeMap.putAll(map);
    }

    public void setRangeAxisLabelFontName(int index, String name) {
        if (rangeAxisLabelFontNameMap == null) {
            rangeAxisLabelFontNameMap = new HashMap<Integer, String>();
        }
        rangeAxisLabelFontNameMap.put(index, name);
    }

    public String getRangeAxisLabelFontName(int index) {
        if (rangeAxisLabelFontNameMap == null) {
            return null;
        }
        Integer key = new Integer(index);
        if(rangeAxisLabelFontNameMap.containsKey(key)){
            return rangeAxisLabelFontNameMap.get(key);
        }
        return null;
    }

    public Map<Integer, String> getRangeAxisLabelFontNameMap() {
        return rangeAxisLabelFontNameMap;
    }

    public void addRangeAxisLabelFontNameMap(Map<Integer, String> map) {
        if (rangeAxisLabelFontNameMap == null) {
            rangeAxisLabelFontNameMap = new HashMap<Integer, String>();
        }
        rangeAxisLabelFontNameMap.putAll(map);
    }

    public void setRangeAxisLabelFontStyle(int index, int style) {
        if (rangeAxisLabelFontStyleMap == null) {
            rangeAxisLabelFontStyleMap = new HashMap<Integer, Integer>();
        }
        rangeAxisLabelFontStyleMap.put(index, style);
    }

    public int getRangeAxisLabelFontStyle(int index) {
        if (rangeAxisLabelFontStyleMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (rangeAxisLabelFontStyleMap.containsKey(key)) {
            return rangeAxisLabelFontStyleMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    public Map<Integer, Integer> getRangeAxisLabelFontStyleMap() {
        return rangeAxisLabelFontStyleMap;
    }

    public void addRangeAxisLabelFontStyleMap(Map<Integer, Integer> map) {
        if (rangeAxisLabelFontStyleMap == null) {
            rangeAxisLabelFontStyleMap = new HashMap<Integer, Integer>();
        }
        rangeAxisLabelFontStyleMap.putAll(map);
    }

    public void setRangeAxisLabelFontSize(int index, int size) {
        if (rangeAxisLabelFontSizeMap == null) {
            rangeAxisLabelFontSizeMap = new HashMap<Integer, Integer>();
        }
        rangeAxisLabelFontSizeMap.put(index, size);
    }

    public int getRangeAxisLabelFontSize(int index) {
        if (rangeAxisLabelFontSizeMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer key = new Integer(index);
        if (rangeAxisLabelFontSizeMap.containsKey(key)) {
            return rangeAxisLabelFontSizeMap.get(key);
        }
        return Integer.MIN_VALUE;
    }

    public Map<Integer, Integer> getRangeAxisLabelFontSizeMap() {
        return rangeAxisLabelFontSizeMap;
    }

    public void addRangeAxisLabelFontSizeMap(Map<Integer, Integer> map) {
        if (rangeAxisLabelFontSizeMap == null) {
            rangeAxisLabelFontSizeMap = new HashMap<Integer, Integer>();
        }
        rangeAxisLabelFontSizeMap.putAll(map);
    }

}
