/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.*;

/**
 * JMSbZ[WRV[}t@NgB<p>
 * 
 * @author M.Takata
 */
public interface JMSMessageConsumerFactory{
    
    /**
     * ̃t@NgێĂSession擾B<p>
     * createConsumer\bhŁAMessageConsumer𐶐ۂɁASessionw肵Ȃꍇ́ASessiongpB<br>
     *
     * @return ̃t@NgێĂSessionBSessionێĂȂꍇnullB
     */
    public Session getSession();
    
    /**
     * ̃t@NgSession̎擾Ɏgp{@link JMSSessionFactory}T[rX擾B<p>
     *
     * @return {@link JMSSessionFactory}T[rX
     */
    public JMSSessionFactory getSessionFactory();
    
    /**
     * ̃t@NgێĂDestination擾B<p>
     * createConsumer\bhŁAMessageConsumer𐶐ۂɁADestinationw肵Ȃꍇ́ADestinationgpB<br>
     *
     * @return ̃t@NgێĂDestinationBDestinationێĂȂꍇnullB
     */
    public Destination getDestination();
    
    /**
     * MessageConsumer𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * ܂ADestinatiońA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * QƑŔAT[rX̎Ɉˑ邪Aɐݒ肪ȂnullAfalseB<br>
     *
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer()
     throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * ܂ADestinatiońA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * ŔAT[rX̎Ɉˑ邪Aɐݒ肪ȂfalseB<br>
     *
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(String messageSelector)
     throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * ܂ADestinatiońA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     *
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal DestinationTopicŁAtrueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂBDestinationQueuȅꍇ̓͋K肳ĂȂB
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * QƑŔAT[rX̎Ɉˑ邪Aɐݒ肪ȂnullAfalseB<br>
     *
     * @param destination zMQueue܂Topic
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(Destination destination)
     throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * ŔAT[rX̎Ɉˑ邪Aɐݒ肪ȂfalseB<br>
     *
     * @param destination zMQueue܂Topic
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        Destination destination,
        String messageSelector
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     *
     * @param destination zMQueue܂Topic
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal DestinationTopicŁAtrueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂBDestinationQueuȅꍇ̓͋K肳ĂȂB
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        Destination destination,
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * w肳ꂽSession{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * DestinatiońA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * QƑŔAT[rX̎Ɉˑ邪Aɐݒ肪ȂnullAfalseB<br>
     *
     * @param session Session
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(Session session)
     throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * w肳ꂽSession{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * DestinatiońA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * ŔAT[rX̎Ɉˑ邪Aɐݒ肪ȂfalseB<br>
     *
     * @param session Session
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        Session session,
        String messageSelector
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * w肳ꂽSession{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * DestinatiońA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     *
     * @param session Session
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal DestinationTopicŁAtrueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂBDestinationQueuȅꍇ̓͋K肳ĂȂB
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        Session session,
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * w肳ꂽSession{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * QƑŔAT[rX̎Ɉˑ邪Aɐݒ肪ȂnullAfalseB<br>
     *
     * @param session Session
     * @param destination zMQueue܂Topic
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        Session session,
        Destination destination
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * w肳ꂽSession{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     * ŔAT[rX̎Ɉˑ邪Aɐݒ肪ȂfalseB<br>
     *
     * @param session Session
     * @param destination zMQueue܂Topic
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        Session session,
        Destination destination,
        String messageSelector
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * MessageConsumer𐶐B<p>
     * w肳ꂽSession{@link Session#createConsumer(Destination, String, boolean)}\bhŐB<br>
     *
     * @param session Session
     * @param destination zMQueue܂Topic
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal DestinationTopicŁAtrueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂBDestinationQueuȅꍇ̓͋K肳ĂȂB
     * @return MessageConsumer
     * @exception JMSMessageConsumerCreateException MessageConsumer̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        Session session,
        Destination destination,
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * TopicSubscriber𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createDurableSubscriber(Topic, String)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * ܂ATopićA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇA܂getDestination()TopicłȂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     *
     * @param name TopicSubscriberʂ閼O
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(String name)
     throws JMSMessageConsumerCreateException;
    
    /**
     * TopicSubscriber𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createDurableSubscriber(Topic, String)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     *
     * @param topic zMTopic
     * @param name TopicSubscriberʂ閼O
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(
        Topic topic,
        String name
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * TopicSubscriber𐶐B<p>
     * w肳ꂽSessionA{@link Session#createDurableSubscriber(Topic, String)}\bhŐB<br>
     * TopićA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇA܂getDestination()TopicłȂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     *
     * @param session Session
     * @param name TopicSubscriberʂ閼O
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(
        Session session,
        String name
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * TopicSubscriber𐶐B<p>
     * w肳ꂽSessionA{@link Session#createDurableSubscriber(Topic, String)}\bhŐB<br>
     *
     * @param session Session
     * @param topic zMTopic
     * @param name TopicSubscriberʂ閼O
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(
        Session session,
        Topic topic,
        String name
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * TopicSubscriber𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createDurableSubscriber(Topic, String, String, boolean)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     * ܂APTopićA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇA܂getDestination()TopicłȂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     *
     * @param name TopicSubscriberʂ閼O
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal trueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂB
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(
        String name,
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * TopicSubscriber𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createDurableSubscriber(Topic, String, String, boolean)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     *
     * @param topic zMTopic
     * @param name TopicSubscriberʂ閼O
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal trueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂB
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(
        Topic topic,
        String name,
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * TopicSubscriber𐶐B<p>
     * w肳ꂽSessionA{@link Session#createDurableSubscriber(Topic, String, String, boolean)}\bhŐB<br>
     * PTopićA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇA܂getDestination()TopicłȂꍇ́AJMSMessageConsumerCreateExceptionthrowB<br>
     *
     * @param session Session
     * @param name TopicSubscriberʂ閼O
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal trueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂB
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(
        Session session,
        String name,
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException;
    
    /**
     * TopicSubscriber𐶐B<p>
     * w肳ꂽSessionA{@link Session#createDurableSubscriber(Topic, String, String, boolean)}\bhŐB<br>
     *
     * @param session Session
     * @param topic zMTopic
     * @param name TopicSubscriberʂ閼O
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal trueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂB
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(
        Session session,
        Topic topic,
        String name,
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException;
}
