/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.*;

/**
 * JMS Topic TuXNCot@NgB<p>
 * JMS1.0ł́AQueueSessionTopicSessioñC^tF[XꂳĂȂ߁ATopicSessionTopicSubscribersB<br>
 * 
 * @author M.Takata
 */
public class JMSTopicSubscriberFactoryService
 extends JMSMessageConsumerFactoryService{
    
    private static final long serialVersionUID = -8754717063746944540L;
    
    /**
     * TopicSubscriber𐶐B<p>
     * {@link #createConsumer(Session, Destination, String, boolean)}\bhĂяôƓBŚANoLocal̒lKpB<br>
     *
     * @param session TopicSession
     * @param destination zMTopic
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        Session session,
        Destination destination,
        String messageSelector
    ) throws JMSMessageConsumerCreateException{
        return createConsumer(session, destination, messageSelector, isNoLocal);
    }
    
    /**
     * TopicSubscriber𐶐B<p>
     * w肳ꂽTopicSession{@link TopicSession#createSubscriber(Topic, String, boolean)}\bhŐB<br>
     *
     * @param session TopicSession
     * @param destination zMTopic
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal trueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂ
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public MessageConsumer createConsumer(
        Session session,
        Destination destination,
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException{
        if(session == null){
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if(!(session instanceof TopicSession)){
            throw new JMSMessageConsumerCreateException("Session is not TopicSession.");
        }
        if(destination == null){
            throw new JMSMessageConsumerCreateException("Destination is null.");
        }
        if(!(destination instanceof Topic)){
            throw new JMSMessageConsumerCreateException("Destination is not Topic.");
        }
        try{
            return ((TopicSession)session).createSubscriber(
                (Topic)destination,
                messageSelector,
                noLocal
            );
        }catch(JMSException e){
            throw new JMSMessageConsumerCreateException(e);
        }
    }
    
    /**
     * TopicSubscriber𐶐B<p>
     * w肳ꂽSessionA{@link TopicSession#createDurableSubscriber(Topic, String)}\bhŐB<br>
     *
     * @param session TopicSession
     * @param topic zMTopic
     * @param name TopicSubscriberʂ閼O
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(
        Session session,
        Topic topic,
        String name
    ) throws JMSMessageConsumerCreateException{
        if(session == null){
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if(!(session instanceof TopicSession)){
            throw new JMSMessageConsumerCreateException("Session is not TopicSession.");
        }
        if(topic == null){
            throw new JMSMessageConsumerCreateException("Topic is null.");
        }
        try{
            return ((TopicSession)session).createDurableSubscriber(topic, name);
        }catch(JMSException e){
            throw new JMSMessageConsumerCreateException(e);
        }
    }
    
    /**
     * TopicSubscriber𐶐B<p>
     * w肳ꂽTopicSessionA{@link TopicSession#createDurableSubscriber(Topic, String, String, boolean)}\bhŐB<br>
     *
     * @param session TopicSession
     * @param topic zMTopic
     * @param name TopicSubscriberʂ閼O
     * @param messageSelector MbZ[WI邽߂̃bZ[WZN^
     * @param noLocal trueݒ肵ꍇA[J瑗MꂽbZ[W͎MȂ悤ɂȂB
     * @return TopicSubscriber
     * @exception JMSMessageConsumerCreateException TopicSubscriber̐Ɏsꍇ
     */
    public TopicSubscriber createDurableSubscriber(
        Session session,
        Topic topic,
        String name,
        String messageSelector,
        boolean noLocal
    ) throws JMSMessageConsumerCreateException{
        if(session == null){
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if(!(session instanceof TopicSession)){
            throw new JMSMessageConsumerCreateException("Session is not TopicSession.");
        }
        if(topic == null){
            throw new JMSMessageConsumerCreateException("Topic is null.");
        }
        try{
            return ((TopicSession)session).createDurableSubscriber(
                topic,
                name,
                messageSelector,
                noLocal
            );
        }catch(JMSException e){
            throw new JMSMessageConsumerCreateException(e);
        }
    }
}
