/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

import java.util.Set;

/**
 * bZ[WMp̃NCAgRlNVC^tF[XB<p>
 * bZ[WMsNCAg̃RlNVC^tF[XB<br>
 * 
 * @author M.Takata
 */
public interface ClientConnection{
    
    /**
     * ̃RlNVT[rXƂēo^{@link jp.ossc.nimbus.core.ServiceManager ServiceManager}̖Oݒ肷B<p>
     *
     * @param name ServiceManager̖O
     */
    public void setServiceManagerName(String name);
    
    /**
     * T[oƐڑB<p>
     *
     * @exception ConnectException T[oƂ̐ڑɎsꍇ
     */
    public void connect() throws ConnectException;
    
    /**
     * T[oƐڑB<p>
     *
     * @param id NCAgʂID
     * @exception ConnectException T[oƂ̐ڑɎsꍇ
     */
    public void connect(Object id) throws ConnectException;
    
    /**
     * zMė~TuWFNgT[oɗvB<br>
     *
     * @param subject TuWFNg
     * @exception MessageSendException T[oւ̗vɎsꍇ
     */
    public void addSubject(String subject) throws MessageSendException;
    
    /**
     * zMė~TuWFNgƃL[T[oɗvB<br>
     *
     * @param subject TuWFNg
     * @param keys L[
     * @exception MessageSendException T[oւ̗vɎsꍇ
     */
    public void addSubject(String subject, String[] keys) throws MessageSendException;
    
    /**
     * zMė~TuWFNgT[oɗvB<br>
     *
     * @param subject TuWFNg
     * @exception MessageSendException T[oւ̗vɎsꍇ
     */
    public void removeSubject(String subject) throws MessageSendException;
    
    /**
     * zMė~TuWFNgƃL[T[oɗvB<br>
     *
     * @param subject TuWFNg
     * @param keys L[
     * @exception MessageSendException T[oւ̗vɎsꍇ
     */
    public void removeSubject(String subject, String[] keys) throws MessageSendException;
    
    /**
     * zMJnT[oɗvB<br>
     *
     * @exception MessageSendException T[oւ̗vɎsꍇ
     */
    public void startReceive() throws MessageSendException;
    
    /**
     * w肵ߋ̎Ԃ̃f[^zMJnT[oɗvB<br>
     *
     * @param from Jn
     * @exception MessageSendException T[oւ̗vɎsꍇ
     */
    public void startReceive(long from) throws MessageSendException;
    
    /**
     * zM~T[oɗvB<br>
     *
     * @exception MessageSendException T[oւ̗vɎsꍇ
     */
    public void stopReceive() throws MessageSendException;
    
    /**
     * zMJnĂ邩ǂ𔻒肷B<br>
     *
     * @return zMJnĂꍇtrue
     */
    public boolean isStartReceive();
    
    /**
     * o^ĂTuWFNg擾B<p>
     *
     * @return TuWFNg̏W
     */
    public Set<String> getSubjects();
    
    /**
     * w肳ꂽTuWFNgɑ΂ēo^ĂL[擾B<p>
     *
     * @param subject TuWFNg
     * @return L[̏W
     */
    public Set<String> getKeys(String subject);
    
    /**
     * bZ[WM̒ʒmł{@link MessageListener bZ[WXi}ݒ肷B<br>
     *
     * @param listener bZ[WXi
     */
    public void setMessageListener(MessageListener listener);
    
    /**
     * ڑĂ邩ǂ𔻒肷B<p>
     *
     * @return ڑĂꍇtrue
     */
    public boolean isConnected();
    
    /**
     * ̐ڑID擾B<p>
     *
     * @return ̐ڑID
     */
    public Object getId();
    
    /**
     * T[oƐؒfB<p>
     */
    public void close();
}