/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

import java.util.Set;

/**
 * bZ[WMC^tF[XB<p>
 * {@link MessageListener}o^ǗāAŜƂĕKvȃTuWFNg̓o^ǗsAeMessageListenerɂꂼꂪKvƂ郁bZ[WzMB<br>
 * 
 * @author M.Takata
 */
public interface MessageReceiver{
    
    /**
     * w肵{@link MessageListener}ɑ΂āAw肵TuWFNg̃bZ[WzM悤ɓo^B<p>
     *
     * @param listener bZ[WXi
     * @param subject TuWFNg
     * @exception MessageSendException TuWFNgo^̃NGXgMɎsꍇ
     */
    public void addSubject(MessageListener listener, String subject) throws MessageSendException;
    
    /**
     * w肵{@link MessageListener}ɑ΂āAw肵TuWFNgw肵L[̃bZ[WzM悤ɓo^B<p>
     *
     * @param listener bZ[WXi
     * @param subject TuWFNg
     * @param keys L[
     * @exception MessageSendException TuWFNgo^̃NGXgMɎsꍇ
     */
    public void addSubject(MessageListener listener, String subject, String[] keys) throws MessageSendException;
    
    /**
     * w肵{@link MessageListener}ɑ΂āAw肵TuWFNg̃bZ[WzMB<p>
     *
     * @param listener bZ[WXi
     * @param subject TuWFNg
     * @exception MessageSendException TuWFNg̃NGXgMɎsꍇ
     */
    public void removeSubject(MessageListener listener, String subject) throws MessageSendException;
    
    /**
     * w肵{@link MessageListener}ɑ΂āAw肵TuWFNgw肵L[̃bZ[WzMB<p>
     *
     * @param listener bZ[WXi
     * @param subject TuWFNg
     * @param keys L[
     * @exception MessageSendException TuWFNg̃NGXgMɎsꍇ
     */
    public void removeSubject(MessageListener listener, String subject, String[] keys) throws MessageSendException;
    
    /**
     * w肵{@link MessageListener}ɑ΂SẴbZ[WzMB<p>
     *
     * @param listener bZ[WXi
     * @exception MessageSendException TuWFNg̃NGXgMɎsꍇ
     */
    public void removeMessageListener(MessageListener listener) throws MessageSendException;
    
    /**
     * w肵{@link MessageListener}ɑ΂ēo^ĂTuWFNg擾B<p>
     *
     * @param listener bZ[WXi
     * @return TuWFNg̏W
     */
    public Set<String> getSubjects(MessageListener listener);
    
    /**
     * w肵{@link MessageListener}Aw肳ꂽTuWFNgɑ΂ēo^ĂL[擾B<p>
     *
     * @param listener bZ[WXi
     * @param subject TuWFNg
     * @return L[̏W
     */
    public Set<String> getKeys(MessageListener listener, String subject);
    
    /**
     * {@link ClientConnection}擾B<p>
     *
     * @return ClientConnection
     */
    public ClientConnection getClientConnection();
    
    /**
     * {@link ClientConnection}ڑB<p>
     *
     * @exception Exception ڑɎsꍇ
     */
    public void connect() throws Exception;
    
    /**
     * {@link ClientConnection}ؒfB<p>
     */
    public void close();
    
    /**
     * ڑĂ邩ǂ𔻒肷B<p>
     *
     * @return ڑĂꍇtrue
     */
    public boolean isConnected();
    
    /**
     * bZ[W̎MJnB<br>
     *
     * @exception MessageSendException MJñNGXgMɎsꍇ
     */
    public void startReceive() throws MessageSendException;
    
    /**
     * bZ[W̎M~B<br>
     *
     * @exception MessageSendException M~̃NGXgMɎsꍇ
     */
    public void stopReceive() throws MessageSendException;
    
    /**
     * zMJnĂ邩ǂ𔻒肷B<br>
     *
     * @return zMJnĂꍇtrue
     */
    public boolean isStartReceive();
    
    /**
     * gpĂڑID擾B<p>
     *
     * @return gpĂڑID
     */
    public Object getId();
}