/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.queue;

/**
 * QueueC^tF[XB<p>
 * 
 * @author H.Nakano
 */
public interface Queue<E>{
    
    /**
     * L[Ƀf[^𓊓B<p>
     * 
     * @param item IuWFNg
     */
    public void push(E item);
    
    /**
     * L[f[^oB<p>
     * L[f[^擾ł܂ŁAɑ҂B<br>
     * 
     * @return L[擾IuWFNg
     */
    public E get();
    
    /**
     * L[f[^oB<p>
     * w肵Ԃ߂܂łɃL[f[^擾łȂꍇ́AnullԂB<br>
     * 
     * @param timeOutMs ^CAEg[ms]
     * @return L[擾IuWFNg
     */
    public E get(long timeOutMs);
    
    /**
     * L[f[^ǂށB<p>
     * QƂ邾ŁAL[f[^͎oȂB<br>
     * 
     * @return L[擾IuWFNg
     */
    public E peek();
    
    /**
     * L[f[^ǂށB<br>
     * QƂ邾ŁAL[f[^͎oȂB<br>
     * w肵Ԃ߂܂łɃL[f[^ǂ߂Ȃꍇ́AnullԂB<br>
     * 
     * @param timeOutMs ^CAEg[ms]
     * @return L[擾IuWFNg
     */
    public E peek(long timeOutMs);
    
    /**
     * L[w肵f[^폜B<p>
     *
     * @param item 폜Ώۂ̃IuWFNg
     */
    public void remove(Object item);
    
    /**
     * L[B<p>
     */
    public void clear();
    
    /**
     * L[TCY擾B<p>
     * 
     * @return L[i[
     */
    public int size();
    
    /**
     * L[ɓꂽ擾B<p>
     *
     * @return L[
     */
    public long getCount();
    
    /**
     * L[擾҂JnB<p>
     * {@link #release()}ďoɁAL[擾҂󂯕t悤ɂB
     */
    public void accept();
    
    /**
     * L[擾҂JAL[擾҂󂯕tȂ悤ɂB<p>
     */
    public void release();
}
