/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.*;

import jp.ossc.nimbus.core.*;

/**
 * {@link DatabaseScheduleManagerService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface DatabaseScheduleManagerServiceMBean extends ServiceBaseMBean{
    
    /**
     * XPW[̐Ԃ̊ĎɎsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_CONTROL_STATE_CHECK_ERROR = "DSM__00001";
    
    /**
     * XPW[̃^CI[o[ĎɎsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_TIMEOVER_CHECK_ERROR = "DSM__00002";
    
    /**
     * XPW[̃^CI[o[ĎŃ^CI[o[XPW[𔭌ꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_TIMEOVER_ERROR = "DSM__00003";
    
    /**
     * XPW[e[u̓tJ̓ttH[}bg̃ftHglB<p>
     */
    public static final String DEFAULT_DATE_FORMAT = "yyyyMMdd";
    
    /**
     * XPW[e[uyуXPW[}X^e[u̎J̎tH[}bg̃ftHglB<p>
     */
    public static final String DEFAULT_TIME_FORMAT = "HHmmssSSS";
    
    /**
     * XPW[ʂ{@link ScheduleMaker}T[rX̃}bsOݒ肷B<p>
     *
     * @param mapping XPW[ʂScheduleMakerT[rX̃}bsOBXPW[=ScheduleMakerT[rX
     */
    public void setScheduleMakerTypeMapping(Properties mapping);
    
    /**
     * XPW[ʂ{@link ScheduleMaker}T[rX̃}bsO擾B<p>
     *
     * @return XPW[ʂScheduleMakerT[rX̃}bsO
     */
    public Properties getScheduleMakerTypeMapping();
    
    /**
     * ftHg{@link ScheduleMaker}T[rX̃T[rXݒ肷B<p>
     * w肵Ȃꍇ́A{@link DefaultScheduleMakerService}KpB<br>
     *
     * @param name ScheduleMakerT[rX̃T[rX
     */
    public void setDefaultScheduleMakerServiceName(ServiceName name);
    
    /**
     * ftHg{@link ScheduleMaker}T[rX̃T[rX擾B<p>
     *
     * @return ScheduleMakerT[rX̃T[rX
     */
    public ServiceName getDefaultScheduleMakerServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.connection.ConnectionFactory ConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ConnectionFactoryT[rX̃T[rX
     */
    public void setConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.connection.ConnectionFactory ConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getConnectionFactoryServiceName();
    
    /**
     * XPW[e[u̓tJ̓ttH[}bgݒ肷B<p>
     * ftHǵA{@link #DEFAULT_DATE_FORMAT}B<br>
     * 
     * @param format ttH[}bg
     */
    public void setDateFormat(String format);
    
    /**
     * XPW[e[u̓tJ̓ttH[}bg擾B<p>
     * 
     * @return ttH[}bg
     */
    public String getDateFormat();
    
    /**
     * XPW[e[uyуXPW[}X^e[u̎J̎tH[}bgݒ肷B<p>
     * ftHǵA{@link #DEFAULT_TIME_FORMAT}B<br>
     * 
     * @param format tH[}bg
     */
    public void setTimeFormat(String format);
    
    /**
     * XPW[e[uyуXPW[}X^e[u̎J̎tH[}bg擾B<p>
     * 
     * @return tH[}bg
     */
    public String getTimeFormat();
    
    /**
     * XPW[e[uyуXPW[ˑ֌We[u̍XV[UIDJ̒lݒ肷B<p>
     * ftHǵA[JzXgB<br>
     * 
     * @param id XV[UID
     */
    public void setUpdateUserId(String id);
    
    /**
     * XPW[e[uyуXPW[ˑ֌We[u̍XV[UIDJ̒l擾B<p>
     * 
     * @return XV[UID
     */
    public String getUpdateUserId();
    
    /**
     * XPW[}X^e[ũXL[}擾B<p>
     *
     * @return XPW[}X^e[ũXL[}
     */
    public DatabaseScheduleManagerService.ScheduleMasterTableSchema getScheduleMasterTableSchema();
    
    /**
     * XPW[}X^e[ũXL[}ݒ肷B<p>
     *
     * @param schema XPW[}X^e[ũXL[}
     */
    public void setScheduleMasterTableSchema(DatabaseScheduleManagerService.ScheduleMasterTableSchema schema);
    
    /**
     * XPW[ˑ֌W}X^e[ũXL[}擾B<p>
     *
     * @return XPW[ˑ֌W}X^e[ũXL[}
     */
    public DatabaseScheduleManagerService.ScheduleDependsMasterTableSchema getScheduleDependsMasterTableSchema();
    
    /**
     * XPW[ˑ֌W}X^e[ũXL[}ݒ肷B<p>
     *
     * @param schema XPW[ˑ֌W}X^e[ũXL[}
     */
    public void setScheduleDependsMasterTableSchema(DatabaseScheduleManagerService.ScheduleDependsMasterTableSchema schema);
    
    /**
     * XPW[e[ũXL[}擾B<p>
     *
     * @return XPW[e[ũXL[}
     */
    public DatabaseScheduleManagerService.ScheduleTableSchema getScheduleTableSchema();
    
    /**
     * XPW[e[ũXL[}ݒ肷B<p>
     *
     * @param schema XPW[e[ũXL[}
     */
    public void setScheduleTableSchema(DatabaseScheduleManagerService.ScheduleTableSchema schema);
    
    /**
     * XPW[ˑ֌We[ũXL[}擾B<p>
     *
     * @return XPW[ˑ֌We[ũXL[}
     */
    public DatabaseScheduleManagerService.ScheduleDependsTableSchema getScheduleDependsTableSchema();
    
    /**
     * XPW[ˑ֌We[ũXL[}ݒ肷B<p>
     *
     * @param schema XPW[ˑ֌We[ũXL[}
     */
    public void setScheduleDependsTableSchema(DatabaseScheduleManagerService.ScheduleDependsTableSchema schema);
    
    /**
     * XPW[ID𔭔ԂSQLݒ肷B<p>
     *
     * @param query SQL
     */
    public void setNextScheduleIdSelectQuery(String query);
    
    /**
     * XPW[ID𔭔ԂSQL擾B<p>
     *
     * @return SQL
     */
    public String getNextScheduleIdSelectQuery();
    
    /**
     * Ԃ`FbNԊu[ms]ݒ肷B<p>
     * ftHǵA1bB<br>
     *
     * @param interval Ԋu[ms]
     */
    public void setControlStateCheckInterval(long interval);
    
    /**
     * Ԃ`FbNԊu[ms]𔻒肷B<p>
     *
     * @return Ԋu[ms]
     */
    public long getControlStateCheckInterval();
    
    /**
     * őxԂ`FbNԊu[ms]ݒ肷B<p>
     * ftHǵA1bB<br>
     *
     * @param interval Ԋu[ms]
     */
    public void setTimeoverCheckInterval(long interval);
    
    /**
     * őxԂ`FbNԊu[ms]𔻒肷B<p>
     *
     * @return Ԋu[ms]
     */
    public long getTimeoverCheckInterval();
    
    /**
     * T[rX̊JnɃVXetgāAXPW[쐬邩ǂݒ肷B<p>
     *
     * @param isMake 쐬ꍇAtrue
     */
    public void setMakeScheduleOnStart(boolean isMake);
    
    /**
     * T[rX̊JnɃVXetgāAXPW[쐬邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA쐬
     */
    public boolean isMakeScheduleOnStart();
    
    /**
     * {@link #findExecutableSchedules(Date, String[])}ĂяoɁAYXPW[̃R[hbN邩ǂݒ肷B<p>
     * ftHǵAfalseŃbNȂB<br>
     *
     * @param isLock bNꍇtrue
     */
    public void setLockForFindExecutable(boolean isLock);
    
    /**
     * {@link #findExecutableSchedules(Date, String[])}ĂяoɁAYXPW[̃R[hbN邩ǂ𔻒肷B<p>
     *
     * @return bNꍇtrue
     */
    public boolean isLockForFindExecutable();
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService NX^}T[rX̃T[rXݒ肷B<p>
     * ̑ݒ肵ꍇANX^T[rX{@link jp.ossc.nimbus.service.distribute.ClusterService#isMain() ClusterService.isMain()}=trueƂȂĂꍇ̂݁AԂ̃`FbNyсAőxԂ̃`FbNsB<br>
     *
     * @param name NX^T[rX̃T[rX
     */
    public void setClusterServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.distribute.ClusterService NX^}T[rX̃T[rX擾B<p>
     *
     * @return NX^T[rX̃T[rX
     */
    public ServiceName getClusterServiceName();
    
    /**
     * XPW[ID𔭔Ԃ{@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rXݒ肷B<p>
     *
     * @param name SequenceT[rX̃T[rX
     */
    public void setSequenceServiceName(ServiceName name);
    
    /**
     * XPW[ID𔭔Ԃ{@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rX擾B<p>
     *
     * @return SequenceT[rX̃T[rX
     */
    public ServiceName getSequenceServiceName();
    
    /**
     * ŎgpSQLŕACONCAT֐gǂݒ肷B<p>
     * ftHǵAfalseŁA"||"ŘAB<br>
     *
     * @param isUse CONCAT֐gꍇtrue
     */
    public void setUseConcatFunction(boolean isUse);
    
    /**
     * ŎgpSQLŕACONCAT֐gǂ𔻒肷B<p>
     *
     * @return truȅꍇACONCAT֐g
     */
    public boolean isUseConcatFunction();
    
    /**
     * w肳ꂽt̃XPW[쐬B<p>
     *
     * @param date t
     * @throws ScheduleMakeException XPW[쐬Ɏsꍇ
     */
    public void makeSchedule(Date date) throws ScheduleMakeException;
    
    /**
     * SẴXPW[B<p>
     *
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findAllSchedules() throws ScheduleManageException;
    
    /**
     * w肳ꂽXPW[B<p>
     *
     * @param id XPW[ID
     * @return XPW[
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public Schedule findSchedule(String id) throws ScheduleManageException;
    
    /**
     * w肳ꂽԂ̃XPW[B<p>
     *
     * @param from Ԃ̊Jn
     * @param to Ԃ̏I
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findSchedules(Date from, Date to) throws ScheduleManageException;
    
    /**
     * w肳ꂽԂ̃XPW[B<p>
     *
     * @param states XPW[Ԃ̔z
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findSchedules(int[] states) throws ScheduleManageException;
    
    /**
     * w肳ꂽԁAw肳ꂽԂ̃XPW[B<p>
     *
     * @param from Ԃ̊Jn
     * @param to Ԃ̏I
     * @param states XPW[Ԃ̔z
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findSchedules(Date from, Date to, int[] states) throws ScheduleManageException;
    
    /**
     * w肳ꂽƎsʂŎs\ȃXPW[B<p>
     *
     * @param date 
     * @param executorTypes sʔz
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findExecutableSchedules(Date date, String[] executorTypes) throws ScheduleManageException;
    
    /**
     * w肳ꂽsL[ƎsʁAŎs\ȃXPW[B<p>
     *
     * @param date 
     * @param executorTypes sʔz
     * @param executorKey sL[
     * @return XPW[Xg
     * @exception ScheduleManageException XPW[̌Ɏsꍇ
     */
    public List<Schedule> findExecutableSchedules(Date date, String[] executorTypes, String executorKey) throws ScheduleManageException;
    
    /**
     * XPW[o^B<p>
     *
     * @param masterId XPW[}X^ID
     * @param time XPW[
     * @param taskName ^XN
     * @param input ̓f[^
     * @param depends ˑXPW[}X^ID̔z
     * @param executorKey ScheduleExecutor肷L[
     * @param executorType ScheduleExecutor̎
     * @param retryInterval gCԊu[ms]
     * @param retryEndTime gCI
     * @param maxDelayTime őx[ms]
     * @exception ScheduleManageException XPW[̓o^Ɏsꍇ
     */
    public void addSchedule(
        String masterId,
        Date time,
        String taskName,
        Object input,
        String[] depends,
        String executorKey,
        String executorType,
        long retryInterval,
        Date retryEndTime,
        long maxDelayTime
    ) throws ScheduleManageException;
    
    /**
     * XPW[ύXB<p>
     *
     * @param id XPW[ID
     * @param time 
     * @return XPW[XVꂽꍇtrue
     * @exception ScheduleManageException XPW[̍XVɎsꍇ
     */
    public boolean reschedule(String id, Date time) throws ScheduleManageException;
    
    /**
     * XPW[폜B<p>
     *
     * @param id XPW[ID
     * @return XPW[폜ꂽꍇtrue
     * @exception ScheduleManageException XPW[̍폜Ɏsꍇ
     */
    public boolean removeSchedule(String id) throws ScheduleManageException;
    
    /**
     * XPW[폜B<p>
     *
     * @param masterId XPW[}X^ID
     * @return XPW[폜ꂽꍇtrue
     * @exception ScheduleManageException XPW[̍폜Ɏsꍇ
     */
    public boolean removeScheduleByMasterId(String masterId) throws ScheduleManageException;
    
    /**
     * w肳ꂽt̃XPW[폜B<p>
     *
     * @param date t
     * @return XPW[폜ꂽꍇtrue
     * @exception ScheduleManageException XPW[̍폜Ɏsꍇ
     */
    public boolean removeSchedule(Date date) throws ScheduleManageException;
    
    /**
     * XPW[s{@link ScheduleExecutor}ݒ肷B<p>
     *
     * @param id XPW[ID
     * @param key ScheduleExecutor肷L[
     */
    public void setExecutorKey(String id, String key) throws ScheduleManageException;
    
    /**
     * w肳ꂽXPW[̏Ԃ擾B<p>
     *
     * @param id XPW[ID
     * @return 
     * @exception ScheduleStateControlException XPW[Ԃ̎擾Ɏsꍇ
     */
    public int getState(String id) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̐Ԃ擾B<p>
     *
     * @param id XPW[ID
     * @return 
     * @exception ScheduleStateControlException XPW[Ԃ̎擾Ɏsꍇ
     */
    public int getControlState(String id) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̏ԂύXB<p>
     *
     * @param id XPW[ID
     * @param state 
     * @return ԂύXꂽꍇtrue
     * @exception ScheduleStateControlException XPW[Ԃ̕ύXɎsꍇ
     */
    public boolean changeState(String id, int state) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̏ԂύXB<p>
     *
     * @param id XPW[ID
     * @param state 
     * @param output s
     * @return ԂύXꂽꍇtrue
     * @exception ScheduleStateControlException XPW[Ԃ̕ύXɎsꍇ
     */
    public boolean changeState(String id, int state, Object output) throws ScheduleStateControlException;
    
    /**
     * w肳ꂽXPW[̐ԂύXB<p>
     *
     * @param id XPW[ID
     * @param state 
     * @return ԂύXꂽꍇtrue
     * @exception ScheduleStateControlException XPW[Ԃ̕ύXɎsꍇ
     */
    public boolean changeControlState(String id, int state) throws ScheduleStateControlException;
}
