/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.converter;

/**
 * J^JiЂ炪ȃRo[^B<p>
 * <table border=5 align=center>
 *     <tr><th>J^Ji</th><th>Ђ炪</th></tr>
 *     <tr><td>A</td><td></td></tr>
 *     <tr><td>@</td><td></td></tr>
 *     <tr><td>C</td><td></td></tr>
 *     <tr><td>B</td><td></td></tr>
 *     <tr><td>E</td><td></td></tr>
 *     <tr><td>D</td><td></td></tr>
 *     <tr><td>G</td><td></td></tr>
 *     <tr><td>F</td><td></td></tr>
 *     <tr><td>I</td><td></td></tr>
 *     <tr><td>H</td><td></td></tr>
 *     <tr><td>J</td><td></td></tr>
 *     <tr><td>K</td><td></td></tr>
 *     <tr><td>L</td><td></td></tr>
 *     <tr><td>M</td><td></td></tr>
 *     <tr><td>N</td><td></td></tr>
 *     <tr><td>O</td><td></td></tr>
 *     <tr><td>P</td><td></td></tr>
 *     <tr><td>Q</td><td></td></tr>
 *     <tr><td>R</td><td></td></tr>
 *     <tr><td>S</td><td></td></tr>
 *     <tr><td>T</td><td></td></tr>
 *     <tr><td>U</td><td></td></tr>
 *     <tr><td>V</td><td></td></tr>
 *     <tr><td>W</td><td></td></tr>
 *     <tr><td>X</td><td></td></tr>
 *     <tr><td>Y</td><td></td></tr>
 *     <tr><td>Z</td><td></td></tr>
 *     <tr><td>[</td><td></td></tr>
 *     <tr><td>\</td><td></td></tr>
 *     <tr><td>]</td><td></td></tr>
 *     <tr><td>^</td><td></td></tr>
 *     <tr><td>_</td><td></td></tr>
 *     <tr><td>`</td><td></td></tr>
 *     <tr><td>a</td><td></td></tr>
 *     <tr><td>b</td><td></td></tr>
 *     <tr><td>c</td><td></td></tr>
 *     <tr><td>d</td><td></td></tr>
 *     <tr><td>e</td><td></td></tr>
 *     <tr><td>f</td><td></td></tr>
 *     <tr><td>g</td><td></td></tr>
 *     <tr><td>h</td><td></td></tr>
 *     <tr><td>i</td><td></td></tr>
 *     <tr><td>j</td><td></td></tr>
 *     <tr><td>k</td><td></td></tr>
 *     <tr><td>l</td><td></td></tr>
 *     <tr><td>m</td><td></td></tr>
 *     <tr><td>n</td><td></td></tr>
 *     <tr><td>o</td><td></td></tr>
 *     <tr><td>p</td><td></td></tr>
 *     <tr><td>q</td><td></td></tr>
 *     <tr><td>r</td><td></td></tr>
 *     <tr><td>s</td><td></td></tr>
 *     <tr><td>t</td><td></td></tr>
 *     <tr><td>u</td><td></td></tr>
 *     <tr><td>v</td><td></td></tr>
 *     <tr><td>w</td><td></td></tr>
 *     <tr><td>x</td><td></td></tr>
 *     <tr><td>y</td><td></td></tr>
 *     <tr><td>z</td><td></td></tr>
 *     <tr><td>{</td><td></td></tr>
 *     <tr><td>|</td><td></td></tr>
 *     <tr><td>}</td><td></td></tr>
 *     <tr><td>~</td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td></td><td></td></tr>
 *     <tr><td>R</td><td>T</td></tr>
 *     <tr><td>S</td><td>U</td></tr>
 * </table>
 * 
 * @author M.Takata
 */
public class KatakanaHiraganaCharacterConverter
 extends AbstractCharacterConverter implements java.io.Serializable{
    
    private static final long serialVersionUID = 2219660761265490304L;
    
    /**
     * J^JiЂ炪ȕϊ\ϊʒ萔B<p>
     */
    public static final int KATAKANA_TO_HIRAGANA = POSITIVE_CONVERT;
    
    /**
     * Ђ炪ȁJ^Jiϊ\ϊʒ萔B<p>
     */
    public static final int HIRAGANA_TO_KATAKANA = REVERSE_CONVERT;
    
    /**
     * [SpJi][Sp] ̔zB
     */
    protected final static char CONV_CHARS[][] = {
        {'\u30a2','\u3042'}, //{'A',''}
        {'\u30a1','\u3041'}, //{'@',''}
        {'\u30a4','\u3044'}, //{'C',''}
        {'\u30a3','\u3043'}, //{'B',''}
        {'\u30a6','\u3046'}, //{'E',''}
        {'\u30a5','\u3045'}, //{'D',''}
        {'\u30a8','\u3048'}, //{'G',''}
        {'\u30a7','\u3047'}, //{'F',''}
        {'\u30aa','\u304a'}, //{'I',''}
        {'\u30a9','\u3049'}, //{'H',''}
        {'\u30ab','\u304b'}, //{'J',''}
        {'\u30ac','\u304c'}, //{'K',''}
        {'\u30ad','\u304d'}, //{'L',''}
        {'\u30ae','\u304e'}, //{'M',''}
        {'\u30af','\u304f'}, //{'N',''}
        {'\u30b0','\u3050'}, //{'O',''}
        {'\u30b1','\u3051'}, //{'P',''}
        {'\u30b2','\u3052'}, //{'Q',''}
        {'\u30b3','\u3053'}, //{'R',''}
        {'\u30b4','\u3054'}, //{'S',''}
        {'\u30b5','\u3055'}, //{'T',''}
        {'\u30b6','\u3056'}, //{'U',''}
        {'\u30b7','\u3057'}, //{'V',''}
        {'\u30b8','\u3058'}, //{'W',''}
        {'\u30b9','\u3059'}, //{'X',''}
        {'\u30ba','\u305a'}, //{'Y',''}
        {'\u30bb','\u305b'}, //{'Z',''}
        {'\u30bc','\u305c'}, //{'[',''}
        {'\u30bd','\u305d'}, //{'\',''}
        {'\u30be','\u305e'}, //{']',''}
        {'\u30bf','\u305f'}, //{'^',''}
        {'\u30c0','\u3060'}, //{'_',''}
        {'\u30c1','\u3061'}, //{'`',''}
        {'\u30c2','\u3062'}, //{'a',''}
        {'\u30c3','\u3063'}, //{'b',''}
        {'\u30c4','\u3064'}, //{'c',''}
        {'\u30c5','\u3065'}, //{'d',''}
        {'\u30c6','\u3066'}, //{'e',''}
        {'\u30c7','\u3067'}, //{'f',''}
        {'\u30c8','\u3068'}, //{'g',''}
        {'\u30c9','\u3069'}, //{'h',''}
        {'\u30ca','\u306a'}, //{'i',''}
        {'\u30cb','\u306b'}, //{'j',''}
        {'\u30cc','\u306c'}, //{'k',''}
        {'\u30cd','\u306d'}, //{'l',''}
        {'\u30ce','\u306e'}, //{'m',''}
        {'\u30cf','\u306f'}, //{'n',''}
        {'\u30d0','\u3070'}, //{'o',''}
        {'\u30d1','\u3071'}, //{'p',''}
        {'\u30d2','\u3072'}, //{'q',''}
        {'\u30d3','\u3073'}, //{'r',''}
        {'\u30d4','\u3074'}, //{'s',''}
        {'\u30d5','\u3075'}, //{'t',''}
        {'\u30d6','\u3076'}, //{'u',''}
        {'\u30d7','\u3077'}, //{'v',''}
        {'\u30d8','\u3078'}, //{'w',''}
        {'\u30d9','\u3079'}, //{'x',''}
        {'\u30da','\u307a'}, //{'y',''}
        {'\u30db','\u307b'}, //{'z',''}
        {'\u30dc','\u307c'}, //{'{',''}
        {'\u30dd','\u307d'}, //{'|',''}
        {'\u30de','\u307e'}, //{'}',''}
        {'\u30df','\u307f'}, //{'~',''}
        {'\u30e0','\u3080'}, //{'',''}
        {'\u30e1','\u3081'}, //{'',''}
        {'\u30e2','\u3082'}, //{'',''}
        {'\u30e4','\u3084'}, //{'',''}
        {'\u30e3','\u3083'}, //{'',''}
        {'\u30e6','\u3086'}, //{'',''}
        {'\u30e5','\u3085'}, //{'',''}
        {'\u30e8','\u3088'}, //{'',''}
        {'\u30e7','\u3087'}, //{'',''}
        {'\u30e9','\u3089'}, //{'',''}
        {'\u30ea','\u308a'}, //{'',''}
        {'\u30eb','\u308b'}, //{'',''}
        {'\u30ec','\u308c'}, //{'',''}
        {'\u30ed','\u308d'}, //{'',''}
        {'\u30ee','\u308e'}, //{'',''}
        {'\u30ef','\u308f'}, //{'',''}
        {'\u30f0','\u3090'}, //{'',''}
        {'\u30f1','\u3091'}, //{'',''}
        {'\u30f2','\u3092'}, //{'',''}
        {'\u30f3','\u3093'}, //{'',''}
        {'\u30fd','\u309d'}, //{'R','T'}
        {'\u30fe','\u309e'}  //{'S','U'}
    };
    
    /**
     * J^JiЂ炪ȕϊʂ̃J^JiЂ炪ȃRo[^𐶐B<p>
     */
    public KatakanaHiraganaCharacterConverter(){
        super(KATAKANA_TO_HIRAGANA);
    }
    
    /**
     * J^JiЂ炪ȃRo[^𐶐B<p>
     *
     * @param type ϊ
     * @see #KATAKANA_TO_HIRAGANA
     * @see #HIRAGANA_TO_KATAKANA
     */
    public KatakanaHiraganaCharacterConverter(int type){
        super(type);
    }
    
    /**
     * ϊLN^z擾B<p>
     *
     * @return {@link #CONV_CHARS}
     */
    @Override
    protected char[][] getConvertChars(){
        return CONV_CHARS;
    }
}
