/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.util.validator;

import java.io.*;
import java.util.*;

import jp.ossc.nimbus.beans.*;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;

/**
 * of[^B<p>
 * The Apache Jakarta Project Commons Jexl(http://jakarta.apache.org/commons/jexl/)gpŌ؂B<br>
 * 
 * @author M.Takata
 */
public class ConditionValidator implements Validator, Serializable{
    
    private static final long serialVersionUID = -8050401813918879584L;
    
    private Condition condition;
    
    /**
     * ݒ肷B<p>
     * ́AThe Apache Jakarta Project Commons Jexl(http://jakarta.apache.org/commons/jexl/)̕@ɏ]B<br>
     * {@link #validate(Object obj)}̈objŎQƂɂ́A"value"ƋLqB<br>
     * ܂Aobj̃vpeBQƂꍇ́A"@vpeB@"̂悤ɋLqB<br>
     * ŌAvpeB̊TÓAJava Beans̃vpeB̊TOLA{@link jp.ossc.nimbus.beans.PropertyFactory PropertyFactory}̋Kɏ]B<br>
     * Fvalue != null && @length@ &gt; 3<br>
     *
     * @param condition 
     * @exception ValidateException sȏꍇ
     */
    public void setCondition(String condition) throws ValidateException{
        this.condition = new Condition(condition);
    }
    
    /**
     * 擾B<p>
     *
     * @return 
     */
    public String getCondition(){
        return condition == null ? null : condition.toString();
    }
    
    /**
     * w肳ꂽIuWFNgɍv邩؂B<p>
     *
     * @param obj ؑΏۂ̃IuWFNg
     * @return ،ʁBؐ̏ꍇtrue
     * @exception ValidateException ؂Ɏsꍇ
     */
    @Override
    public boolean validate(Object obj) throws ValidateException{
        return condition == null ? true : condition.evaluate(obj);
    }
    
    private static class Condition implements Serializable{
        
        private static final long serialVersionUID = 7720035195219210280L;
        
        private transient Expression expression;
        private String condition;
        
        private static final String PROP_FUNCTION_NAME = "prop";
        private static final String VALUE = "value";
        
        @SuppressWarnings("unused")
		Condition() throws ValidateException{
            this("true");
        }
        
        Condition(String cond) throws ValidateException{
            initCondition(cond);
        }
        
        private void initCondition(String cond) throws ValidateException{
            JexlEngine jexl = new JexlEngine();
            jexl.setSilent(true);
            Map<String, Object> funcs = new HashMap<String, Object>();
            PropertyAccess propAccess = new PropertyAccess();
            propAccess.setIgnoreNullProperty(true);
            funcs.put(PROP_FUNCTION_NAME, propAccess);
            jexl.setFunctions(funcs);
            try{
                expression = jexl.createExpression(cond);
            }catch(Exception e){
                throw new ValidateException(e);
            }
            evaluate("", true);
            condition = cond;
        }
        
        public boolean evaluate(Object object) throws ValidateException{
            return evaluate(object, false);
        }
        
        protected boolean evaluate(Object object, boolean isTest)
         throws ValidateException{
            JexlContext jexlContext = new MapContext();
            jexlContext.set(VALUE, object);
            
            try{
                Object exp = expression.evaluate(jexlContext);
                if(exp instanceof Boolean){
                    return ((Boolean)exp).booleanValue();
                }else{
                    if(exp == null && isTest){
                        return true;
                    }
                    throw new ValidateException(expression.getExpression());
                }
            }catch(Exception e){
                throw new ValidateException(e);
            }
        }
        
        public String toString(){
            return condition;
        }
        
        private void readObject(ObjectInputStream in)
         throws IOException, ClassNotFoundException{
            in.defaultReadObject();
            try{
                initCondition(condition);
            }catch(Exception e){
                // NȂ͂
            }
        }
    }
}