/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.lang.reflect.Method;

import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link MethodArrayEditor}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class MethodArrayEditorTest extends BeansTestBase{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText() throws SecurityException, NoSuchMethodException{
        return new Object[][]{
                {"java.util.HashMap#put(java.lang.Object\\, java.lang.Object)", 
                    new Method[]{
                        java.util.HashMap.class.getMethod("put",new Class[]{java.lang.Object.class, java.lang.Object.class})
                        }
                },
                {"java.util.HashMap#put(java.lang.Object\\, java.lang.Object),", 
                    new Method[]{
                        java.util.HashMap.class.getMethod("put",new Class[]{java.lang.Object.class, java.lang.Object.class})
                    }
                },
                {"java.util.HashMap#put(java.lang.Object\\, java.lang.Object),java.util.HashMap#get(java.lang.Object)", 
                    new Method[]{
                        java.util.HashMap.class.getMethod("put",new Class[]{java.lang.Object.class, java.lang.Object.class}),
                        java.util.HashMap.class.getMethod("get",new Class[]{java.lang.Object.class})}
                },
                {" \t java.util.HashMap#put(java.lang.Object\\, java.lang.Object),java.util.HashMap#get(java.lang.Object)\n    , java.util.HashMap#size()    ", 
                    new Method[]{
                        java.util.HashMap.class.getMethod("put",new Class[]{java.lang.Object.class, java.lang.Object.class}), 
                        java.util.HashMap.class.getMethod("get",new Class[]{java.lang.Object.class}), 
                        java.util.HashMap.class.getMethod("size", (Class<?>[])null)
                    }
                },
                {"java.util.HashMap#put(java.lang.Object\\, java.lang.Object),\n<!--  java.util.HashMap#get(java.lang.Object)  -->,\njava.util.HashMap#size()", 
                    new Method[]{
                        java.util.HashMap.class.getMethod("put",new Class[]{java.lang.Object.class, java.lang.Object.class}), 
                        java.util.HashMap.class.getMethod("size", (Class<?>[])null)
                    }
                }
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.MethodArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.MethodArrayEditor#getValue()",
                    "Normal"},
          dataProvider = "SetAsText")
    public void testSetText(String paramStr, Method[] answerArray){
        arrayEditorSetText(MethodArrayEditor.class, paramStr, answerArray);
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty() throws SecurityException, NoSuchMethodException{
        return new Object[][]{
                {"test.MethodArrayEditor.value", "java.util.HashMap#get(java.lang.Object)", 
                    "java.util.HashMap#put(java.lang.Object\\, java.lang.Object),${test.MethodArrayEditor.value}", 
                    new Method[]{
                        java.util.HashMap.class.getMethod("put",new Class[]{java.lang.Object.class, java.lang.Object.class}),
                        java.util.HashMap.class.getMethod("get",new Class[]{java.lang.Object.class})
                    }
                }
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.MethodArrayEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.MethodArrayEditor#getValue()",
                    "Normal"},
      dataProvider = "SetAsTextProperty")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, Method[] answerArray){
        arrayEditorSetTextSystemProperty(MethodArrayEditor.class, propertyKeyStr, propertyValStr, paramStr, answerArray);
    }
    
    @DataProvider(name = "SetAsValue")
    public Object[][] dataSetAsValue() throws SecurityException, NoSuchMethodException{
        return new Object[][]{
            {new Method[]{java.util.HashMap.class.getMethod("put",new Class[]{java.lang.Object.class, java.lang.Object.class})}, "java.util.HashMap#put(java.lang.Object\\,java.lang.Object)"},
            {new Method[]{
                    java.util.HashMap.class.getMethod("put",new Class[]{java.lang.Object.class, java.lang.Object.class}),
                    java.util.HashMap.class.getMethod("get",new Class[]{java.lang.Object.class}
                )
            }, "java.util.HashMap#put(java.lang.Object\\,java.lang.Object),java.util.HashMap#get(java.lang.Object)"}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.MethodArrayEditor#setAsValue(java.lang.Character)",
                    "jp.ossc.nimbus.beans.MethodArrayEditor#getAsText()",
                    "Normal"},
      dataProvider = "SetAsValue")
    public void testSetValue(Method[] paramArray, String answerStr){
        arrayEditorSetValue(MethodArrayEditor.class, paramArray, answerStr);
    }
}
