/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2011 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;
import java.util.Properties;

import static org.testng.Assert.assertEquals;
import org.testng.annotations.Test;
import org.testng.annotations.DataProvider;

/**
 * {@link PropertiesEditor}eXgP[XB<p>
 * 
 * @author Y.Kunisaki
 */
public class PropertiesEditorTest{
    @DataProvider(name = "SetAsText")
    public Object[][] dataSetAsText(){
        return new Object[][]{
                {"A=100", new Object[]{"A"}, new Object[]{"100"}},
                {"A=100\nB=200", new Object[]{"A", "B"}, new Object[]{"100", "200"}},
                {"B=200\nA=100", new Object[]{"A", "B"}, new Object[]{"100", "200"}},
                {"   A = 100  \n  <!-- B=200\nC=300 -->  \n  \"C  \" = \" 300 \"", new Object[]{"A ", "\"C  \" "}, new Object[]{" 100", " \" 300 \""}},
                {"   A=100  \n  <!-- B=200\nC=300 -->  \n  C   =  300 ", new Object[]{"A", "C   "}, new Object[]{"100", "  300"}}
            };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.PropertiesEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.PropertiesEditor#getValue()",
                    "Normal"},
          dataProvider = "SetAsText")
    public void testSetText(String paramStr, Object[] getParamArray, Object[] answerArray) throws SecurityException, NoSuchMethodException{
        PropertiesEditor editor = new PropertiesEditor();
        editor.setAsText(paramStr);
        Properties prop = (Properties)editor.getValue();
        assertEquals(getParamArray.length, prop.size());
        for(int i = 0 ; i < getParamArray.length ; i++){
            assertEquals(prop.get(getParamArray[i]), answerArray[i]);
        }
    }
    
    @DataProvider(name = "SetAsTextProperty")
    public Object[][] dataSetAsTextProperty() throws SecurityException, NoSuchMethodException{
        return new Object[][]{
                {"test.PropertiesEditor.value", "1234", "A=${test.PropertiesEditor.value}\nB=\\u3042", new Object[]{"A", "B"}, new Object[]{"1234", ""}}
        };
    }
    @Test(groups = {"jp.ossc.nimbus.beans.PropertiesEditor#setAsText(java.lang.String)",
                    "jp.ossc.nimbus.beans.PropertiesEditor#getValue()",
                    "Normal"},
        dataProvider = "SetAsTextProperty")
    public void testSetTypeSystemProperty(String propertyKeyStr, String propertyValStr, String paramStr, Object[] getParamArray, Object[] answerArray) throws SecurityException, NoSuchMethodException{
        PropertiesEditor editor = new PropertiesEditor();
        System.setProperty(propertyKeyStr, propertyValStr);
        editor.setAsText(paramStr);
        Properties prop = (Properties)editor.getValue();
        assertEquals(2, prop.size());
        
        for(int i = 0 ; i < getParamArray.length ; i++){
            assertEquals(prop.get(getParamArray[i]), answerArray[i]);
        }
    }
    
    @Test(groups = {"jp.ossc.nimbus.beans.PropertiesEditor#setAsValue(java.lang.Character)",
                    "jp.ossc.nimbus.beans.PropertiesEditor#getAsText()",
                    "Normal"})
    public void testSetValue(){
        PropertiesEditor editor = new PropertiesEditor();
        Properties prop = new Properties();
        prop.setProperty("A", "100");
        prop.setProperty("B", "200");
        editor.setValue(prop);
        assertEquals("A=100" + System.getProperty("line.separator") + "B=200", editor.getAsText());
    }
}
