/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.util.*;
import java.lang.reflect.*;
import java.io.*;

import jp.ossc.nimbus.beans.dataset.*;

/**
 * }bvvpeBB<p>
 * CӂBeańAvpeB̃L[tvpeBɃANZX邽߂{@link Property}B<br>
 * ȉ̂悤ȃL[tvpeBɃANZX^CvZ[tȃR[hB<br>
 * <pre>
 *   Object propValue = obj.getHoge("fuga");
 *   obj.setHoge("fuga", propValue);
 * </pre>
 * }bvvpeBgŁÃR[h<br>
 * <pre>
 *   MappedProperty prop = new MappedProperty();
 *   prop.parse("hoge(fuga)");
 *   Object propValue = prop.getProperty(obj);
 *   prop.setProperty(obj, propValue);
 * </pre>
 * ƂR[hɒu鎖łB<br>
 * ̃R[h́A璷ɂȂĂ邪AΏۂƂȂBeaň^⃁\bh^CvZ[tɏȂIȃR[hɂȂĂB<br>
 * <p>
 * ̃}bvvpeBł́Aȉ̂悤BeañvpeBɑ΂ANZX@pӂĂB<br>
 * <table border="1">
 *   <tr bgcolor="#CCCCFF"><th rowspan="3">ANZX@</th><th>Java\</th><th rowspan="3">vpeB\</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>vpeB擾</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>vpeBݒ</th></tr>
 *   <tr><td rowspan="2">L[tvpeB</td><td>bean.getHoge("fuga")</td><td rowspan="2">hoge(fuga)</td></tr>
 *   <tr><td>bean.setHoge("fuga", value)</td></tr>
 *   <tr><td rowspan="2">߂ljava.util.Map̒PvpeB</td><td>((java.util.Map)bean.getHoge()).get("fuga")</td><td rowspan="2">hoge(fuga)</td></tr>
 *   <tr><td>((java.util.Map)bean.getHoge()).set("fuga", value)</td></tr>
 *   <tr><td rowspan="2">߂lget(String)\bhCӂ̃NX̒PvpeB</td><td>bean.getHoge().get("fuga")</td><td rowspan="2">hoge(fuga)</td></tr>
 *   <tr><td>bean.getHoge().set("fuga", value)</td></tr>
 *   <tr><td rowspan="2">java.util.Map̗vf</td><td>bean.get("fuga")</td><td rowspan="2">(fuga)</td></tr>
 *   <tr><td>bean.set("fuga", value)</td></tr>
 *   <tr><td rowspan="2">get(String)\bhCӂ̃NX̗vf</td><td>bean.get("fuga")</td><td rowspan="2">(fuga)</td></tr>
 *   <tr><td>bean.set("fuga", value)</td></tr>
 * </table>
 * 
 * @author M.Takata
 */
public class MappedProperty extends SimpleProperty implements Serializable{
    
    private static final long serialVersionUID = 8407662267357861189L;
    
    private static final String MSG_00001 = "Illegal MappedProperty : ";
    private static final String MSG_00002
        = "Length of property literal must be not null.";
    private static final String RECORD_PROP_NAME = "Property";
    
    /**
     * }bvvpeBGetter\bhB<p>
     */
    protected static final String GET_METHOD_NAME = "get";
    
    /**
     * }bvvpeBGetter\bhB<p>
     */
    protected static final String IS_METHOD_NAME = "is";
    
    /**
     * }bvvpeBGetter\bḧ^zB<p>
     */
    protected static final Class<?>[] GET_METHOD_ARGS
        = new Class[]{String.class};
    
    /**
     * }bvvpeBSetter\bhB<p>
     */
    protected static final String SET_METHOD_NAME = "set";
    
    /**
     * L[B<p>
     */
    protected String key;
    
    /**
     * }bvvpeBGetter\bhLbVB<p>
     */
    protected transient Map<Class<?>, Method> mappedReadMethodCache = new HashMap<Class<?>, Method>();
    
    /**
     * }bvvpeBSetter\bhLbVB<p>
     */
    protected transient Map<Class<?>, Object> mappedWriteMethodCache = new HashMap<Class<?>, Object>();
    
    /**
     * ̃}bvvpeB𐶐B<p>
     */
    public MappedProperty(){
        super();
    }
    
    /**
     * w肵vpeBŁAL[null̃}bvvpeB𐶐B<p>
     *
     * @param name vpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public MappedProperty(String name) throws IllegalArgumentException{
        super(name);
    }
    
    /**
     * w肵vpeBƃL[̃}bvvpeB𐶐B<p>
     *
     * @param name vpeB
     * @param key L[
     * @exception IllegalArgumentException namenullw肵ꍇ
     */
    public MappedProperty(String name, String key)
     throws IllegalArgumentException{
        super(name);
        this.key = key;
    }
    
    /**
     * ̃vpeB\vpeB擾B<p>
     *
     * @return vpeB(L[)
     */
    @Override
    public String getPropertyName(){
        return super.getPropertyName() + '(' + key + ')';
    }
    
    /**
     * vpeBݒ肷B<p>
     *
     * @param prop vpeB
     * @exception IllegalArgumentException w肳ꂽvpeBnull̏ꍇ
     */
    @Override
    protected void setPropertyName(String prop)
     throws IllegalArgumentException{
        if(prop == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        property = prop;
    }
    
    /**
     * w肵vpeB͂B<p>
     * Ŏw\ȕ́A<br>
     * &nbsp;vpeB(L[)<br>
     * łB<br>
     * AAvpeB͏ȗB<br>
     *
     * @param prop vpeB
     * @exception IllegalArgumentException w肳ꂽvpeB̃vpeBIuWFNg͂łȂꍇ
     */
    @Override
    public void parse(String prop) throws IllegalArgumentException{
        final int startMappedDelim = prop.indexOf('(');
        final int endMappedDelim = prop.indexOf(')');
        if(startMappedDelim == -1 || endMappedDelim == -1
            || endMappedDelim - startMappedDelim < 1
            || endMappedDelim != prop.length() - 1){
            throw new IllegalArgumentException(MSG_00001 + prop);
        }else{
            key = prop.substring(
                startMappedDelim + 1,
                endMappedDelim
            );
            setPropertyName(prop.substring(0, startMappedDelim));
        }
    }
    
    /**
     * L[擾B<p>
     *
     * @return L[
     */
    public String getKey(){
        return key;
    }
    
    /**
     * L[ݒ肷B<p>
     *
     * @param key L[
     */
    public void setKey(String key){
        this.key = key;
    }
    
    @Override
    public Class<?> getPropertyType(Object obj) throws NoSuchPropertyException{
        return (Class<?>)getPropertyType(obj, false);
    }
    
    @Override
    public Type getPropertyGenericType(Object obj) throws NoSuchPropertyException{
        return getPropertyType(obj, true);
    }
        
    @SuppressWarnings("unchecked")
    protected Type getPropertyType(Object obj, boolean isGeneric) throws NoSuchPropertyException{
        if(obj == null){
            return java.lang.Object.class;
        }
        if(obj instanceof Record
            && RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName())){
            final Record record = (Record)obj;
            final RecordSchema recSchema = record.getRecordSchema();
            if(recSchema != null){
                final PropertySchema propSchema = recSchema.getPropertySchema(getKey());
                if(propSchema != null){
                    final Class<?> type = propSchema.getType();
                    if(type != null){
                        return type;
                    }
                }
            }
        }
        final Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if(property.length() == 0){
            return getMappedObjectPropertyType(clazz, isGeneric);
        }else{
            if(mappedReadMethodCache.containsKey(clazz)){
                readMethod = mappedReadMethodCache.get(clazz);
            }else{
                readMethod = getReadMappedMethod(clazz);
                mappedReadMethodCache.put(clazz, readMethod);
            }
            if(readMethod == null){
                Method setMethod = getWriteMappedMethod(clazz, null);
                if(setMethod != null){
                    if(mappedWriteMethodCache.containsKey(clazz)){
                        final Object methodObj
                             = mappedWriteMethodCache.get(clazz);
                        if(!(methodObj instanceof Method)){
                            Map<Class<?>, Method> overloadMap = (Map<Class<?>, Method>)methodObj;
                            if(overloadMap.size() > 2
                                || (overloadMap.size() == 2
                                        && !overloadMap.containsKey(null))
                            ){
                                return null;
                            }
                        }
                    }
                    return isGeneric ? setMethod.getGenericParameterTypes()[1] : setMethod.getParameterTypes()[1];
                }
                Type retType = null;
                try{
                    retType = isGeneric ? super.getPropertyGenericType(obj) : super.getPropertyType(obj);
                }catch(NoSuchPropertyException e){
                    throw new NoSuchPropertyException(clazz, property + '(' + key + ')');
                }
                return getMappedObjectPropertyType(retType, isGeneric);
            }else{
                return isGeneric ? readMethod.getGenericReturnType() : readMethod.getReturnType();
            }
        }
    }
    
    @Override
    public boolean isReadable(Object obj){
        try{
            getProperty(obj);
        }catch(NoSuchPropertyException e){
            return false;
        }catch(InvocationTargetException e){
            return false;
        }
        return true;
    }
    
    @Override
    public boolean isWritable(Object obj, Class<?> clazz){
        final Class<?> objClazz = obj.getClass();
        Method readMethod = null;
        Method writeMethod = null;
        if(getMethodCache.containsKey(objClazz) && getMethodCache.get(objClazz) != null){
            readMethod = getMethodCache.get(objClazz);
            return isWritableNoMappedProperty(obj, readMethod, clazz);
        }else if(property.length() == 0){
            return isWritableMappedObjectProperty(obj, clazz);
        }else{
            writeMethod = getWriteMappedMethod(objClazz, clazz);
            if(writeMethod == null){
                Object prop = null;
                try{
                    prop = super.getProperty(obj);
                }catch(NoSuchPropertyException e){
                    return false;
                }catch(InvocationTargetException e){
                    return false;
                }
                if(prop == null){
                    return false;
                }
                return isWritableMappedObjectProperty(obj, clazz);
            }else{
                return true;
            }
        }
    }
    
    /**
     * w肵IuWFNgÃvpeB\vpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @return vpeBl
     * @exception NoSuchReadablePropertyException w肳ꂽvpeBGetter݂Ȃꍇ
     * @exception NullKeyPropertyException w肳ꂽvpeB̃L[t߂lAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public Object getProperty(Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if(getMethodCache.containsKey(clazz) && getMethodCache.get(clazz) != null){
            readMethod = getMethodCache.get(clazz);
            if(readMethod.getParameterTypes().length == 0){
                return getNoMappedProperty(obj, readMethod);
            }else{
                final Object prop = super.getProperty(obj);
                if(prop == null){
                    throw new NoSuchPropertyException(
                        clazz,
                        property + '(' + key + ')'
                    );
                }
                return getMappedObjectProperty(prop.getClass(), prop);
            }
        }else if(mappedReadMethodCache.containsKey(clazz)){
            readMethod = mappedReadMethodCache.get(clazz);
            return getMappedProperty(obj, readMethod);
        }else if(property.length() == 0){
            return getMappedObjectProperty(clazz, obj);
        }else{
            readMethod = getReadMappedMethod(clazz);
            if(readMethod == null){
                final Object prop = super.getProperty(obj);
                if(prop == null){
                    throw new NoSuchPropertyException(
                        clazz,
                        property + '(' + key + ')'
                    );
                }
                return getMappedObjectProperty(prop.getClass(), prop);
            }else{
                mappedReadMethodCache.put(clazz, readMethod);
                return getMappedProperty(obj, readMethod);
            }
        }
    }
    
    /**
     * w肵IuWFNg̃L[tGetterigetvpeB(String)jĂяovpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod L[tGetterigetvpeB(String)j
     * @return vpeBl
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    protected Object getMappedProperty(Object obj, Method readMethod)
     throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        try{
            return readMethod.invoke(obj, key);
        }catch(IllegalAccessException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '(' + key + ')',
                e
            );
        }catch(IllegalArgumentException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '(' + key + ')',
                e
            );
        }
    }
    
    /**
     * w肵IuWFNg̃L[t߂lGetteriL[tIuWFNg getvpeB()jĂяoA߂lvpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod L[t߂lGetteriL[tIuWFNg getvpeB()j
     * @return vpeBl
     * @exception NullKeyPropertyException w肳ꂽvpeB̃L[t߂lAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇA܂͖߂lL[t߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽBean܂̓L[t߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    protected Object getNoMappedProperty(Object obj, Method readMethod)
     throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        Object mappedObj = getMappedObject(obj, readMethod);
        if(mappedObj == null){
            if(isIgnoreNullProperty){
                return null;
            }else{
                throw new NullKeyPropertyException(
                    clazz,
                    property + '(' + key + ')'
                );
            }
        }else{
            return getMappedObjectProperty(mappedObj.getClass(), mappedObj);
        }
    }
    
    /**
     * w肵L[tIuWFNg̃NXÃ}bvvpeBL[̃vpeB^擾B<p>
     * ŌAL[tIuWFNgƂ́A{@link java.util.Map}AL[tGetteriget(String)jIuWFNĝꂩłB
     *
     * @param mappedType L[tIuWFNǧ^
     * @param isGeneric truȅꍇǍ^Ԃ
     * @return vpeB^
     * @exception NoSuchPropertyException w肳ꂽL[t߂lAL[t߂lłȂꍇ
     */
    protected Type getMappedObjectPropertyType(Type mappedType, boolean isGeneric)
     throws NoSuchPropertyException{
        Class<?> mappedClazz = null;
        if(mappedType instanceof Class){
            mappedClazz = (Class<?>)mappedType;
        }else if(mappedType instanceof ParameterizedType){
            mappedClazz = (Class<?>)((ParameterizedType)mappedType).getRawType();
        }else{
            return isGeneric ? mappedType : Object.class;
        }
        if(Map.class.isAssignableFrom(mappedClazz)){
            if(mappedType instanceof ParameterizedType){
                Type valueType = ((ParameterizedType)mappedType).getActualTypeArguments()[1];
                if(isGeneric){
                    return valueType;
                }else if(valueType instanceof Class){
                    return valueType;
                }else if(valueType instanceof ParameterizedType){
                    return ((ParameterizedType)valueType).getRawType();
                }else{
                    return Object.class;
                }
            }else{
                return Object.class;
            }
        }else{
            Method getMethod = null;
            try{
                getMethod = mappedClazz.getMethod(
                    GET_METHOD_NAME,
                    GET_METHOD_ARGS
                );
            }catch(NoSuchMethodException e){
                Method setMethod = null;
                final Method[] methods = mappedClazz.getMethods();
                if(methods == null || methods.length == 0){
                    throw new NoSuchPropertyException(mappedClazz, property + '(' + key + ')');
                }
                for(Method method : methods){
                    if(!SET_METHOD_NAME.equals(method.getName())
                        || !Modifier.isPublic(method.getModifiers())
                        || Modifier.isNative(method.getModifiers())){
                        continue;
                    }
                    final Class<?>[] params = method.getParameterTypes();
                    if(params == null || params.length != 2
                         || !params[0].equals(String.class)
                    ){
                        continue;
                    }
                    if(setMethod == null){
                        setMethod = method;
                    }else{
                        // młȂ̂ŃG[
                        throw new NoSuchPropertyException(
                            mappedClazz,
                            property + '(' + key + ')'
                        );
                    }
                }
                if(setMethod == null){
                    throw new NoSuchPropertyException(mappedClazz, property + '(' + key + ')');
                }
                return isGeneric ? setMethod.getGenericParameterTypes()[1] : setMethod.getParameterTypes()[1];
            }
            if(!Modifier.isPublic(getMethod.getModifiers()) || Modifier.isNative(getMethod.getModifiers())){
                throw new NoSuchPropertyException(mappedClazz, property + '(' + key + ')');
            }
            return isGeneric ? getMethod.getGenericReturnType() : getMethod.getReturnType();
        }
    }
    
    /**
     * w肵L[tIuWFNgÃ}bvvpeBL[̃vpeBl擾B<p>
     * ŌAL[tIuWFNgƂ́A{@link java.util.Map}AL[tGetteriget(String)jIuWFNĝꂩłB
     *
     * @param obj L[tIuWFNg
     * @return vpeBl
     * @exception NoSuchPropertyException w肳ꂽL[t߂lAL[t߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽL[t߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    @SuppressWarnings("unchecked")
    protected Object getMappedObjectProperty(Class<?> clazz, Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        if(Map.class.isAssignableFrom(clazz)){
            final Map<Object, Object> map = (Map<Object, Object>)obj;
            return map.get(key);
        }else{
            final Class<?> mappedClazz = clazz;
            if(!isAccessableClass(mappedClazz)){
                final Class<?>[] interfaces = mappedClazz.getInterfaces();
                for(Class<?> itf : interfaces){
                    if(isAccessableClass(itf)){
                        try{
                            return getMappedObjectProperty(itf, obj);
                        }catch(NoSuchPropertyException e){
                        }
                    }
                }
                final Class<?> superClass = mappedClazz.getSuperclass();
                if(superClass != null){
                    return getMappedObjectProperty(
                        superClass,
                        obj
                    );
                }
                throw new NoSuchPropertyException(mappedClazz, property + '(' + key + ')');
            }
            Method getMethod = null;
            try{
                getMethod = mappedClazz.getMethod(
                    GET_METHOD_NAME,
                    GET_METHOD_ARGS
                );
            }catch(NoSuchMethodException e){
                throw new NoSuchPropertyException(mappedClazz, property + '(' + key + ')');
            }
            if(Modifier.isPublic(getMethod.getModifiers()) && !Modifier.isNative(getMethod.getModifiers())){
                try{
                    return getMethod.invoke(
                        obj,
                        key
                    );
                }catch(IllegalAccessException e){
                    // NȂ͂
                    throw new NoSuchPropertyException(
                        mappedClazz,
                        property + '(' + key + ')',
                        e
                    );
                }catch(IllegalArgumentException e){
                    // NȂ͂
                    throw new NoSuchPropertyException(
                        mappedClazz,
                        property + '(' + key + ')',
                        e
                    );
                }
            }else{
                throw new NoSuchPropertyException(mappedClazz, property + '(' + key + ')');
            }
        }
    }
    
    /**
     * w肵IuWFNgɁÃvpeB\vpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param value ݒ肷vpeBl
     * @exception NoSuchReadablePropertyException w肳ꂽvpeBGetter݂Ȃꍇ
     * @exception NullKeyPropertyException w肳ꂽvpeB̃L[t߂lAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        setProperty(obj, value == null ? null : value.getClass(), value);
    }
    
    /**
     * w肵IuWFNgɁÃvpeB\vpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param type vpeB̌^
     * @param value ݒ肷vpeBl
     * @exception NoSuchReadablePropertyException w肳ꂽvpeBGetter݂Ȃꍇ
     * @exception NullKeyPropertyException w肳ꂽvpeB̃L[t߂lAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Class<?> type, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        Method readMethod = null;
        Method writeMethod = null;
        if(getMethodCache.containsKey(clazz) && getMethodCache.get(clazz) != null){
            readMethod = getMethodCache.get(clazz);
            setNoMappedProperty(obj, readMethod, value);
        }else if(property.length() == 0){
            setMappedObjectProperty(clazz, obj, value);
        }else{
            if(type == null && value != null){
                type = value.getClass();
            }
            writeMethod = getWriteMappedMethod(
                clazz,
                type
            );
            if(writeMethod == null){
                final Object prop = super.getProperty(obj);
                if(prop == null){
                    throw new NoSuchPropertyException(
                        clazz,
                        property + '(' + key + ')'
                    );
                }
                setMappedObjectProperty(prop.getClass(), prop, value);
            }else{
                setMappedProperty(obj, writeMethod, value);
            }
        }
    }
    
    /**
     * w肵IuWFNg̃L[tSetterisetvpeB(String, Cӂ̃NX)jĂяovpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param writeMethod L[tSetterisetvpeB(String, Cӂ̃NX)j
     * @param value ݒ肷vpeBl
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    protected void setMappedProperty(
        Object obj,
        Method writeMethod,
        Object value
    ) throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        try{
            final Class<?> paramType = writeMethod.getParameterTypes()[1];
            if(value instanceof Number
                 && !paramType.isPrimitive()
                 && !paramType.equals(value.getClass())
            ){
                value = castPrimitiveWrapper(paramType, (Number)value);
            }
            writeMethod.invoke(obj, key, value);
        }catch(IllegalAccessException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '(' + key + ')',
                e
            );
        }catch(IllegalArgumentException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '(' + key + ')',
                e
            );
        }
    }
    
    /**
     * w肵IuWFNg̃L[t߂lGetteriL[tIuWFNg getvpeB()jĂяoA̖߂l擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod L[t߂lGetteriL[tIuWFNg getvpeB()j
     * @return w肵IuWFNg̃L[t߂l
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇA܂͖߂lL[t߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽBean܂̓L[t߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    protected Object getMappedObject(
        Object obj,
        Method readMethod
    ) throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        Object mappedObj = null;
        try{
            mappedObj = readMethod.invoke(obj);
        }catch(IllegalAccessException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '(' + key + ')',
                e
            );
        }catch(IllegalArgumentException e){
            // NȂ͂
            throw new NoSuchPropertyException(
                clazz,
                property + '(' + key + ')',
                e
            );
        }
        return mappedObj;
    }
    
    /**
     * w肵IuWFNg̃L[t߂lGetteriL[tIuWFNg getvpeB()jĂяoA߂lɃvpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod L[t߂lGetteriL[tIuWFNg getvpeB()j
     * @param value vpeBl
     * @exception NullKeyPropertyException w肳ꂽvpeB̃L[t߂lAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇA܂͖߂lL[t߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽBean܂̓L[t߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    protected void setNoMappedProperty(
        Object obj,
        Method readMethod,
        Object value
    ) throws NoSuchPropertyException, InvocationTargetException{
        final Class<?> clazz = obj.getClass();
        Object mappedObj = getMappedObject(obj, readMethod);
        if(mappedObj == null){
            throw new NullKeyPropertyException(
                clazz,
                property + '(' + key + ')'
            );
        }else{
            setMappedObjectProperty(mappedObj.getClass(), mappedObj, value);
        }
    }
    
    /**
     * w肵IuWFNg̃L[t߂lGetteriL[tIuWFNg getvpeB()jĂяoA̖߂lɃvpeBlݒ\肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param readMethod L[t߂lGetteriL[tIuWFNg getvpeB()j
     * @param clazz vpeB̌^
     * @return w肵IuWFNg̃L[t߂lɃvpeBlݒ\ȏꍇtrue
     */
    protected boolean isWritableNoMappedProperty(
        Object obj,
        Method readMethod,
        Class<?> clazz
    ){
        Object mappedObj = null;
        try{
            mappedObj = getMappedObject(obj, readMethod);
        }catch(NoSuchPropertyException e){
            return false;
        }catch(InvocationTargetException e){
            return false;
        }
        if(mappedObj == null){
            return false;
        }else{
            return isWritableMappedObjectProperty(mappedObj, clazz);
        }
    }
    
    /**
     * w肵L[tIuWFNgɁÃ}bvvpeBL[̃vpeBlݒ\肷B<p>
     * ŌAL[tIuWFNgƂ́A{@link java.util.Map}AL[tSetteriset(String, vpeBľ^ɓKCӂ̃NX)jIuWFNĝꂩłB
     *
     * @param obj L[tIuWFNg
     * @param clazz vpeB̌^
     * @return w肵L[tIuWFNgɁÃ}bvvpeBL[̃vpeBlݒ\ȏꍇtrue
     */
    protected boolean isWritableMappedObjectProperty(Object obj, Class<?> clazz){
        final Class<?> mappedClazz = obj.getClass();
        if(obj instanceof Map<?, ?>){
            return true;
        }else{
            Method setMethod = null;
            Class<?> valueClass = clazz == null ? null : clazz;
            final Method[] methods = mappedClazz.getMethods();
            if(methods == null || methods.length == 0){
                return false;
            }
            for(Method method : methods){
                if(!SET_METHOD_NAME.equals(method.getName())
                    || !Modifier.isPublic(method.getModifiers())
                    || Modifier.isNative(method.getModifiers())){
                    continue;
                }
                final Class<?>[] params = method.getParameterTypes();
                if(params == null || params.length != 2
                     || !params[0].equals(String.class)
                     ||(valueClass != null
                         && !isAssignableFrom(params[1], valueClass))
                ){
                    continue;
                }
                if(setMethod == null
                     || isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                    setMethod = method;
                }
            }
            if(setMethod == null){
                return false;
            }
            return true;
        }
    }
    
    /**
     * w肵L[tIuWFNgɁÃ}bvvpeBL[̃vpeBlݒ肷B<p>
     * ŌAL[tIuWFNgƂ́A{@link java.util.Map}AL[tSetteriset(String, vpeBľ^ɓKCӂ̃NX)jIuWFNĝꂩłB
     *
     * @param obj L[tIuWFNg
     * @param value vpeBl
     * @exception NoSuchPropertyException w肳ꂽL[t߂lAL[t߂lłȂꍇ
     * @exception InvocationTargetException w肳ꂽL[t߂l̃ANZTĂяoʁAOthrowꂽꍇ
     */
    @SuppressWarnings("unchecked")
    protected void setMappedObjectProperty(Class<?> clazz, Object obj, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        if(obj instanceof Map){
            final Map<Object, Object> map = (Map<Object, Object>)obj;
            map.put(key, value);
        }else{
            if(!isAccessableClass(clazz)){
                final Class<?>[] interfaces = clazz.getInterfaces();
                for(Class<?> itf : interfaces){
                    if(isAccessableClass(itf)){
                        try{
                            setMappedObjectProperty(itf, obj, value);
                            return;
                        }catch(NoSuchPropertyException e){
                        }
                    }
                }
                final Class<?> superClass = clazz.getSuperclass();
                if(superClass != null){
                    setMappedObjectProperty(superClass, obj, value);
                    return;
                }
                throw new NoSuchPropertyException(clazz, property + '(' + key + ')');
            }
            Method setMethod = null;
            Class<?> valueClass = value == null ? null : value.getClass();
            final Method[] methods = clazz.getMethods();
            if(methods == null || methods.length == 0){
                throw new NoSuchPropertyException(clazz, property + '(' + key + ')');
            }
            for(Method method : methods){
                if(!SET_METHOD_NAME.equals(method.getName())
                    || !Modifier.isPublic(method.getModifiers())
                    || Modifier.isNative(method.getModifiers())){
                    continue;
                }
                final Class<?>[] params = method.getParameterTypes();
                if(params == null || params.length != 2
                     || !params[0].equals(String.class)
                     ||(valueClass != null
                         && !isAssignableFrom(params[1], valueClass))
                ){
                    continue;
                }
                if(setMethod == null
                     || isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                    setMethod = method;
                }
            }
            if(setMethod == null){
                throw new NoSuchPropertyException(clazz, property + '(' + key + ')');
            }
            try{
                setMethod.invoke(
                    obj,
                    key, value
                );
            }catch(IllegalAccessException e){
                // NȂ͂
                throw new NoSuchPropertyException(
                    clazz,
                    property + '(' + key + ')',
                    e
                );
            }catch(IllegalArgumentException e){
                // NȂ͂
                throw new NoSuchPropertyException(
                    clazz,
                    property + '(' + key + ')',
                    e
                );
            }
        }
    }
    
    /**
     * w肳ꂽNXL[tGetterigetvpeB(String)j\bh擾B<p>
     * \bhȂꍇ́AnullԂB
     *
     * @param clazz ΏۂBeañNXIuWFNg
     * @return L[tGetterigetvpeB(String)j\bh
     */
    protected Method getReadMappedMethod(Class<?> clazz){
        if(!isAccessableClass(clazz)){
            final Class<?>[] interfaces = clazz.getInterfaces();
            for(Class<?> itf : interfaces){
                final Method method = getReadMappedMethod(itf);
                if(method != null){
                    return method;
                }
            }
            final Class<?> superClass = clazz.getSuperclass();
            if(superClass != null){
                return getReadMappedMethod(superClass);
            }
            return null;
        }
        final StringBuilder methodName = new StringBuilder(GET_METHOD_NAME);
        if(property.length() != 0){
            char capital = property.charAt(0);
            if(Character.isUpperCase(capital)){
                methodName.append(property);
            }else{
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if(property.length() > 1){
                    methodName.append(property.substring(1));
                }
            }
        }
        try{
            return clazz.getMethod(
                methodName.toString(),
                GET_METHOD_ARGS
            );
        }catch(NoSuchMethodException e){
            try{
                return clazz.getMethod(
                    property,
                    GET_METHOD_ARGS
                );
            }catch(NoSuchMethodException e2){
                methodName.delete(0, 3);
                methodName.insert(0, IS_METHOD_NAME);
                try{
                    return clazz.getMethod(
                        methodName.toString(),
                        GET_METHOD_ARGS
                    );
                }catch(NoSuchMethodException e3){
                    return null;
                }
            }
        }
    }
    
    /**
     * w肳ꂽNXL[tSetterisetvpeB(String, Ŏw肵param̃NX^)j\bh擾B<p>
     * \bhȂꍇ́AnullԂB
     *
     * @param clazz ΏۂBeañNXIuWFNg
     * @param param ݒ肷l̃NXIuWFNg
     * @return L[tSetterisetvpeB(String, Ŏw肵param̃NX^)j\bh
     */
    @SuppressWarnings("unchecked")
    protected Method getWriteMappedMethod(Class<?> clazz, Class<?> param){
        if(mappedWriteMethodCache.containsKey(clazz)){
            final Object methodObj = mappedWriteMethodCache.get(clazz);
            if(methodObj instanceof Method){
                return (Method)methodObj;
            }
            final Map<Class<?>, Method> overloadMap = (Map<Class<?>, Method>)methodObj;
            if(param == null){
                if(overloadMap.size() == 1){
                    return overloadMap.values().iterator().next();
                }else{
                    Method setMethod = overloadMap.get(null);
                    if(setMethod != null){
                        return setMethod;
                    }
                    final Object[] classes = overloadMap.keySet().toArray();
                    for(Object keyClass : classes){
                        Method method = overloadMap.get(keyClass);
                        final Class<?>[] params = method.getParameterTypes();
                        if(setMethod == null){
                            if(!params[1].isPrimitive()){
                                setMethod = method;
                            }
                            continue;
                        }
                        if(isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                            setMethod = method;
                        }
                    }
                    final Map<Class<?>, Method> tmpOverloadMap = new HashMap<Class<?>, Method>(overloadMap);
                    tmpOverloadMap.put(null, setMethod);
                    mappedWriteMethodCache.put(clazz, tmpOverloadMap);
                    return setMethod;
                }
            }else if(overloadMap.containsKey(param)){
                return (Method)overloadMap.get(param);
            }else{
                Method setMethod = overloadMap.get(null);
                if(setMethod != null){
                    return setMethod;
                }
                final Object[] classes = overloadMap.keySet().toArray();
                final Class<?> primitiveClazz = toPrimitive(param);
                for(Object keyClass : classes){
                    Method method = overloadMap.get(keyClass);
                    final Class<?>[] params = method.getParameterTypes();
                    if(setMethod == null){
                        if(!isAssignableFrom(params[1], param)
                            && !params[1].equals(primitiveClazz)){
                            continue;
                        }
                        setMethod = method;
                        if(param.equals(params[0])
                            || params[0].equals(primitiveClazz)){
                            break;
                        }
                        continue;
                    }
                    if(!isAssignableFrom(params[1], param)
                         && !params[1].equals(primitiveClazz)){
                        continue;
                    }
                    if(params[1].equals(param)
                        || params[1].equals(primitiveClazz)){
                        setMethod = method;
                        break;
                    }
                    if(isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                        setMethod = method;
                    }
                }
                final Map<Class<?>, Method> tmpOverloadMap = new HashMap<Class<?>, Method>(overloadMap);
                tmpOverloadMap.put(param, setMethod);
                mappedWriteMethodCache.put(clazz, tmpOverloadMap);
                return setMethod;
            }
        }
        if(!isAccessableClass(clazz)){
            final Class<?>[] interfaces = clazz.getInterfaces();
            for(Class<?> itf : interfaces){
                final Method method = getWriteMappedMethod(
                    itf,
                    param
                );
                if(method != null){
                    return method;
                }
            }
            final Class<?> superClass = clazz.getSuperclass();
            if(superClass != null){
                return getWriteMappedMethod(
                    superClass,
                    param
                );
            }
            return null;
        }
        final StringBuilder methodName = new StringBuilder(SET_METHOD_NAME);
        if(property.length() != 0){
            char capital = property.charAt(0);
            if(Character.isUpperCase(capital)){
                methodName.append(property);
            }else{
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if(property.length() > 1){
                    methodName.append(property.substring(1));
                }
            }
        }
        Method setMethod = null;
        final Method[] methods = clazz.getMethods();
        if(methods == null || methods.length == 0){
            return null;
        }
        final Class<?> primitiveClazz = toPrimitive(param);
        final Map<Class<?>, Method> overloadMap = new HashMap<Class<?>, Method>();
        boolean isMatch = false;
        for(Method method : methods){
            if(!methodName.toString().equals(method.getName())
                 || Modifier.isNative(method.getModifiers())){
                continue;
            }
            final Class<?>[] params = method.getParameterTypes();
            if(params == null || params.length != 2
                 || !params[0].equals(String.class)
            ){
                continue;
            }
            overloadMap.put(params[1], method);
            if(isMatch){
                continue;
            }
            if(setMethod == null){
                if(param == null){
                    setMethod = method;
                    continue;
                }
                if(!isAssignableFrom(params[1], param)
                    && !params[1].equals(primitiveClazz)){
                    continue;
                }
                setMethod = method;
                if(param.equals(params[0])
                    || params[0].equals(primitiveClazz)){
                    isMatch = true;
                }
                continue;
            }
            if(param == null){
                if(isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                    setMethod = method;
                }
                continue;
            }
            if(!isAssignableFrom(params[1], param)
                 && !params[1].equals(primitiveClazz)){
                continue;
            }
            if(params[1].equals(param)
                || params[1].equals(primitiveClazz)){
                isMatch = true;
                setMethod = method;
                continue;
            }
            if(isAssignableFrom(setMethod.getParameterTypes()[1], params[1])){
                setMethod = method;
            }
        }
        if(param == null){
            overloadMap.put(null, setMethod);
        }
        if(setMethod != null){
            if(overloadMap.size() > 1){
                mappedWriteMethodCache.put(clazz, overloadMap);
            }else{
                mappedWriteMethodCache.put(clazz, setMethod);
            }
        }
        return setMethod;
    }
    
    /**
     * w肳ꂽBeańASẴL[tvpeB擾B<p>
     * AAL[́AnullB<br>
     *
     * @param bean ΏۂƂȂBean
     * @return w肳ꂽBeańASẴL[tvpeB擾B
     */
    public static MappedProperty[] getMappedProperties(Object bean){
        return getMappedProperties(bean.getClass());
    }
    
    /**
     * w肳ꂽNX́ASẴL[tvpeB擾B<p>
     * AAL[́AnullB<br>
     *
     * @param clazz ΏۂƂȂNX
     * @return w肳ꂽBeańASẴL[tvpeB擾B
     */
    public static MappedProperty[] getMappedProperties(Class<?> clazz){
        Set<MappedProperty> props = new HashSet<MappedProperty>();
        if(isAccessableClass(clazz)){
            props = getMappedProperties(clazz, null, props);
        }else{
            final Class<?>[] interfaces = clazz.getInterfaces();
            for(Class<?> itf : interfaces){
                if(isAccessableClass(itf)){
                    props = getMappedProperties(itf, null, props);
                    break;
                }
            }
        }
        return props.toArray(new MappedProperty[props.size()]);
    }
    
    private static Set<MappedProperty> getMappedProperties(Class<?> clazz, String prop, Set<MappedProperty> props){
        final Method[] methods = clazz.getMethods();
        if(methods == null || methods.length == 0){
            return props;
        }
        String getMethodName = null;
        String setMethodName = null;
        String isMethodName = null;
        if(prop != null){
            final StringBuilder methodName = new StringBuilder();
            if(prop.length() != 0){
                char capital = prop.charAt(0);
                if(Character.isUpperCase(capital)){
                    methodName.append(prop);
                }else{
                    capital = Character.toUpperCase(capital);
                    methodName.append(capital);
                    if(prop.length() > 1){
                        methodName.append(prop.substring(1));
                    }
                }
            }
            getMethodName = methodName.insert(0, GET_METHOD_NAME).toString();
            methodName.delete(0, GET_METHOD_NAME.length());
            setMethodName = methodName.insert(0, SET_METHOD_NAME).toString();
            methodName.delete(0, SET_METHOD_NAME.length());
            isMethodName = methodName.insert(0, IS_METHOD_NAME).toString();
        }
        for(Method method : methods){
            if(Modifier.isNative(method.getModifiers())){
                continue;
            }
            final Class<?>[] params = method.getParameterTypes();
            if((getMethodName != null && getMethodName.equals(method.getName()))
                || (getMethodName == null && method.getName().startsWith(GET_METHOD_NAME))){
                final Class<?> retType = method.getReturnType();
                if(Void.TYPE.equals(retType)){
                    continue;
                }
                if(params == null){
                    if(Map.class.isAssignableFrom(retType)){
                        props.add(
                            new MappedProperty(
                                method.getName().substring(3)
                            )
                        );
                    }else{
                        try{
                            retType.getMethod(
                                GET_METHOD_NAME,
                                GET_METHOD_ARGS
                            );
                            props.add(
                                new MappedProperty(
                                    method.getName().substring(3)
                                )
                            );
                        }catch(NoSuchMethodException e){
                            final Method[] nestedMethods = retType.getMethods();
                            boolean isFound = false;
                            for(Method nestedMethod : nestedMethods){
                                final Class<?>[] nestedParams
                                     = nestedMethod.getParameterTypes();
                                if(SET_METHOD_NAME.equals(nestedMethod.getName())
                                    && !Modifier.isNative(nestedMethod.getModifiers())
                                    && nestedParams.length == 2
                                    && String.class.equals(nestedParams[0])){
                                    isFound = true;
                                    break;
                                }
                            }
                            if(isFound){
                                props.add(
                                    new MappedProperty(
                                        method.getName().substring(3)
                                    )
                                );
                            }
                        }
                    }
                }else if(params.length == 1){
                    if(!String.class.equals(params[0])){
                        continue;
                    }
                    props.add(
                        new MappedProperty(
                            method.getName().substring(3)
                        )
                    );
                }else{
                    continue;
                }
            }else if((isMethodName != null && isMethodName.equals(method.getName()))
                || (isMethodName == null && method.getName().startsWith(IS_METHOD_NAME))){
                final Class<?> retType = method.getReturnType();
                if(!Boolean.TYPE.equals(retType)){
                    continue;
                }
                if(params != null && params.length == 1
                    && String.class.equals(params[0])
                ){
                    props.add(
                        new MappedProperty(
                            method.getName().substring(2)
                        )
                    );
                }
            }else if((setMethodName != null && setMethodName.equals(method.getName()))
                || (setMethodName == null && method.getName().startsWith(SET_METHOD_NAME))){
                if(params != null && params.length == 2){
                    if(!String.class.equals(params[0])){
                        continue;
                    }
                    props.add(
                        new MappedProperty(
                            method.getName().substring(3)
                        )
                    );
                }else{
                    continue;
                }
            }else{
                continue;
            }
        }
        return props;
    }
    
    /**
     * w肳ꂽNX́Aw肳ꂽvpeB̃L[tvpeB擾B<p>
     * AAL[́AnullB<br>
     *
     * @param clazz ΏۂƂȂNX
     * @param prop ΏۂƂȂvpeB
     * @return w肳ꂽBeańAw肳ꂽvpeB̃L[tvpeB擾B
     */
    public static MappedProperty[] getMappedProperties(Class<?> clazz, String prop){
        Set<MappedProperty> props = new HashSet<MappedProperty>();
        if(isAccessableClass(clazz)){
            props = getMappedProperties(clazz, prop, props);
        }else{
            final Class<?>[] interfaces = clazz.getInterfaces();
            for(Class<?> itf : interfaces){
                if(isAccessableClass(itf)){
                    props = getMappedProperties(itf, prop, props);
                    break;
                }
            }
        }
        return props.toArray(new MappedProperty[props.size()]);
    }
    
    /**
     * ̃}bvvpeB̕\擾B<p>
     *
     * @return MappedProperty{vpeB[L[]}
     */
    @Override
    public String toString(){
        return "MappedProperty{" + property + '(' + key + ")}";
    }
    
    /**
     * ̃IuWFNgƑ̃IuWFNgǂ܂B <p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return Ɏw肳ꂽIuWFNgƂ̃IuWFNgꍇ trueAłȂꍇ falseB
     */
    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(!(obj instanceof MappedProperty)){
            return false;
        }
        final MappedProperty comp = (MappedProperty)obj;
        if(property == null && comp.property != null
            || property != null && comp.property == null){
            return false;
        }else if(property != null && comp.property != null
            && !property.equals(comp.property)){
            return false;
        }
        if(key == null && comp.key == null){
            return true;
        }else if(key == null){
            return false;
        }else{
            return key.equals(comp.key);
        }
    }
    
    /**
     * nbVl擾B<p>
     *
     * @return nbVl
     */
    @Override
    public int hashCode(){
        return (property == null ? 0 : property.hashCode()) + (key == null ? 0 : key.hashCode()) + 1;
    }
    
    /**
     * ̃IuWFNgƎw肳ꂽIuWFNg̏rB<p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return ̃IuWFNgw肳ꂽIuWFNg菬ꍇ͕̐Aꍇ̓[A傫ꍇ͐̐
     */
    @Override
    public int compareTo(Property obj){
        if(obj == null){
            return 1;
        }
        if(!(obj instanceof MappedProperty)){
            return 1;
        }
        final MappedProperty comp = (MappedProperty)obj;
        if(property == null && comp.property != null){
            return -1;
        }else if(property != null && comp.property == null){
            return 1;
        }else if(property != null && comp.property != null){
            final int val = property.compareTo(comp.property);
            if(val != 0){
                return val;
            }
        }
        if(key == null && comp.key == null){
            return 0;
        }else if(key == null){
            return -1;
        }else{
            return key.compareTo(comp.key);
        }
    }
    
    private void readObject(ObjectInputStream in)
     throws IOException, ClassNotFoundException{
        in.defaultReadObject();
        getMethodCache = new HashMap<Class<?>, Method>();
        setMethodCache = new HashMap<Class<?>, Object>();
        mappedReadMethodCache = new HashMap<Class<?>, Method>();
        mappedWriteMethodCache = new HashMap<Class<?>, Object>();
    }
}
