/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import org.w3c.dom.*;

/**
 * tB[h`&lt;field&gt;vf^f[^B<p>
 * T[rX`t@C&lt;field&gt;vfɋLqꂽei[郁^f[^ReiłB<p>
 *
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class FieldMetaData extends MetaData
 implements Serializable{
    
    private static final long serialVersionUID = 1310130198871856470L;
    
    /**
     * &lt;service&gt;vf̎qvf&lt;field&gt;vf̗vfB<p>
     */
    public static final String FIELD_TAG_NAME = "field";
    
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    
    protected static final String TYPE_ATTRIBUTE_NAME = "type";
    
    protected String name;
    
    protected String type;
    
    protected Object value;
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     */
    public FieldMetaData(MetaData parent){
        super(parent);
    }
    
    /**
     * &lt;field&gt;vfname̒l擾B<p>
     * 
     * @return name̒l
     */
    public String getName(){
        return name;
    }
    
    /**
     * &lt;field&gt;vfname̒lݒ肷B<p>
     * 
     * @param name name̒l
     */
    public void setName(String name){
        this.name = name;
    }
    
    /**
     * &lt;field&gt;vftype̒l擾B<p>
     * 
     * @return type̒l
     */
    public String getType(){
        return type;
    }
    
    /**
     * &lt;field&gt;vftype̒lݒ肷B<p>
     * 
     * @param type type̒l
     */
    public void setType(String type){
        this.type = type;
    }
    
    /**
     * &lt;field&gt;vf̓e̒l擾B<p>
     * 
     * @return &lt;field&gt;vf̓e
     */
    public Object getValue(){
        return value;
    }
    
    /**
     * &lt;field&gt;vf̓e̒lݒ肷B<p>
     * 
     * @param value &lt;field&gt;vf̓e
     */
    public void setValue(Object value){
        this.value = value;
    }
    
    /**
     * &lt;field&gt;vfElementp[XāAg̏Ayюqvf̃^f[^̐sB<p>
     *
     * @param element &lt;field&gt;vfElement
     * @exception DeploymentException &lt;field&gt;vf̉́Ǎʂɂ郁^f[^̐Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        super.importXML(element);
        
        if(!element.getTagName().equals(FIELD_TAG_NAME)){
            throw new DeploymentException(
                "Tag must be " + FIELD_TAG_NAME + " : "
                 + element.getTagName()
            );
        }
        
        name = getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        if(name.length() == 0){
            throw new DeploymentException(
                "Element of " + FIELD_TAG_NAME + " must have valid " + NAME_ATTRIBUTE_NAME + " attribute."
            );
        }
        type = getOptionalAttribute(element, TYPE_ATTRIBUTE_NAME);
        if(type != null && type.length() == 0){
            throw new DeploymentException(
                "Element of " + FIELD_TAG_NAME + " must have valid " + TYPE_ATTRIBUTE_NAME + " attribute."
            );
        }
        
        if(Element.class.getName().equals(type)){
            Element valueElement = getOptionalChild(element);
            if(valueElement != null){
                value = valueElement.cloneNode(true);
            }
            return;
        }
        
        final Element serviceRefElement = getOptionalChild(
            element,
            ServiceRefMetaData.SERIVCE_REF_TAG_NAME
        );
        if(serviceRefElement != null){
            final ServiceRefMetaData serviceRefData = new ServiceRefMetaData(
                this,
                getParent() == null ? null : ((ObjectMetaData)getParent()).getManagerName()
            );
            serviceRefData.importXML(serviceRefElement);
            value = serviceRefData;
            return;
        }
        
        final Element objectElement = getOptionalChild(
            element,
            ObjectMetaData.OBJECT_TAG_NAME
        );
        if(objectElement != null){
            final ObjectMetaData objectData = new ObjectMetaData(
                getParent() == null ? null : ((ObjectMetaData)getParent()).getServiceLoader(),
                this,
                getParent() == null ? null : ((ObjectMetaData)getParent()).getManagerName()
            );
            objectData.importXML(objectElement);
            value = objectData;
            return;
        }
        
        final Element staticInvokeElement = getOptionalChild(
            element,
            StaticInvokeMetaData.STATIC_INVOKE_TAG_NAME
        );
        if(staticInvokeElement != null){
            final StaticInvokeMetaData staticInvokeData
                 = new StaticInvokeMetaData(this);
            staticInvokeData.importXML(staticInvokeElement);
            value = staticInvokeData;
            return;
        }
        
        final Element staticFieldElement = getOptionalChild(
            element,
            StaticFieldRefMetaData.STATIC_FIELD_REF_TAG_NAME
        );
        if(staticFieldElement != null){
            final StaticFieldRefMetaData staticFieldData
                 = new StaticFieldRefMetaData(this);
            staticFieldData.importXML(staticFieldElement);
            value = staticFieldData;
            return;
        }
        value = getElementContent(element);
        if(value == null){
            value = "";
        }
    }
    
    @Override
    public StringBuilder toXML(StringBuilder buf){
        appendComment(buf);
        buf.append('<').append(FIELD_TAG_NAME);
        if(name != null){
            buf.append(' ').append(NAME_ATTRIBUTE_NAME)
                .append("=\"").append(name).append("\"");
        }
        if(type != null){
            buf.append(' ').append(TYPE_ATTRIBUTE_NAME)
                .append("=\"").append(type).append("\"");
        }
        buf.append('>');
        if(value != null){
            if(value instanceof MetaData){
                buf.append(LINE_SEPARATOR);
                buf.append(
                    addIndent(((MetaData)value).toXML(new StringBuilder()))
                );
                buf.append(LINE_SEPARATOR);
            }else{
                final String str = value.toString();
                if(str.indexOf('\r') != -1
                    || str.indexOf('\n') != -1){
                    buf.append(LINE_SEPARATOR);
                    buf.append(addIndent(str));
                    buf.append(LINE_SEPARATOR);
                }else{
                    buf.append(str);
                }
            }
        }
        buf.append("</").append(FIELD_TAG_NAME).append('>');
        return buf;
    }
}
