/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

/**
 * IuWFNg`&lt;object&gt;vf^f[^B<p>
 * T[rX`t@C&lt;object&gt;vfɋLqꂽei[郁^f[^ReiłB<p>
 *
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class ObjectMetaData extends MetaData implements Serializable{
    
    private static final long serialVersionUID = 1822804096588017217L;
    
    /**
     * &lt;object&gt;vf̗vfB<p>
     */
    public static final String OBJECT_TAG_NAME = "object";
    
    protected static final String CODE_ATTRIBUTE_NAME = "code";
    
    protected String managerName;
    
    protected String code;
    
    protected ConstructorMetaData constructor;
    
    protected Map<String, FieldMetaData> fields = new LinkedHashMap<String, FieldMetaData>();
    
    protected Map<String, AttributeMetaData> attributes = new LinkedHashMap<String, AttributeMetaData>();
    
    protected List<InvokeMetaData> invokes = new ArrayList<InvokeMetaData>();
    
    /**
     * [hServiceLoader
     */
    protected ServiceLoader myLoader;
    
    protected List<IfDefMetaData> ifDefMetaDataList;
    
    /**
     * ̃CX^X𐶐B<p>
     */
    public ObjectMetaData(){
    }
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param loader [hServiceLoader
     * @param parent evf̃^f[^
     * @param manager T[rXo^{@link ServiceManager}̖O
     */
    public ObjectMetaData(
        ServiceLoader loader,
        MetaData parent,
        String manager
    ){
        super(parent);
        myLoader = loader;
        managerName = manager;
    }
    
    /**
     * [h{@link ServiceLoader}擾B<p>
     *
     * @return [hServiceLoader 
     */
    public ServiceLoader getServiceLoader(){
        return myLoader;
    }
    
    /**
     * [h{@link ServiceLoader}ݒ肷B<p>
     *
     * @param loader [hServiceLoader 
     */
    public void setServiceLoader(ServiceLoader loader){
        myLoader = loader;
    }
    
    /**
     * &lt;object&gt;vfcode̒l擾B<p>
     * 
     * @return code̒l
     */
    public String getCode(){
        return code;
    }
    
    /**
     * &lt;object&gt;vfcode̒lݒ肷B<p>
     * 
     * @param code code̒l
     */
    public void setCode(String code){
        this.code = code;
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;constructor&gt;vf\{@link ConstructorMetaData}擾B<p>
     *
     * @return qvf&lt;constructor&gt;vf\ConstructorMetaData
     */
    public ConstructorMetaData getConstructor(){
        return constructor;
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;constructor&gt;vf\{@link ConstructorMetaData}ݒ肷B<p>
     *
     * @param constructor qvf&lt;constructor&gt;vf\ConstructorMetaData
     */
    public void setConstructor(ConstructorMetaData constructor){
        this.constructor = constructor;
    }
    
    /**
     * &lt;object&gt;vf֘A&lt;manager&gt;vfname̒l擾B<p>
     * 
     * @return &lt;object&gt;vf֘A&lt;manager&gt;vfname̒l
     */
    public String getManagerName(){
        return managerName;
    }
    
    /**
     * &lt;object&gt;vf֘A&lt;manager&gt;vfname̒lݒ肷B<p>
     * 
     * @param name &lt;object&gt;vf֘A&lt;manager&gt;vfname̒l
     */
    public void setManagerName(String name){
        managerName = name;
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;field&gt;vf\{@link FieldMetaData}namȅW擾B<p>
     *
     * @return qvf&lt;field&gt;vf\FieldMetaDatanamȅW
     */
    public List<String> getFieldNameList(){
        return new ArrayList<String>(fields.keySet());
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;field&gt;vf\{@link FieldMetaData}̏W擾B<p>
     *
     * @return qvf&lt;field&gt;vf\FieldMetaDatȁW
     */
    public List<FieldMetaData> getFields(){
        return new ArrayList<FieldMetaData>(fields.values());
    }
    
    /**
     * w肳ꂽOɊY&lt;object&gt;vf̎qvf&lt;field&gt;vf\{@link FieldMetaData}擾B<p>
     *
     * @param name qvf&lt;field&gt;vfname̒l
     * @return qvf&lt;field&gt;vf\FieldMetaData
     */
    public FieldMetaData getField(String name){
        return fields.get(name);
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;field&gt;vf\{@link FieldMetaData}ǉB<p>
     *
     * @param field qvf&lt;field&gt;vf\FieldMetaData
     */
    public void addField(FieldMetaData field){
        fields.put(field.getName(), field);
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;field&gt;vf\{@link FieldMetaData}폜B<p>
     *
     * @param name qvf&lt;field&gt;vfname̒l
     */
    public void removeField(String name){
        fields.remove(name);
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;field&gt;vf\{@link FieldMetaData}Sč폜B<p>
     */
    public void clearFields(){
        fields.clear();
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;attribute&gt;vf\{@link AttributeMetaData}namȅW擾B<p>
     *
     * @return qvf&lt;attribute&gt;vf\AttributeMetaDatanamȅW
     */
    public List<String> getAttributeNameList(){
        return new ArrayList<String>(attributes.keySet());
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;attribute&gt;vf\{@link AttributeMetaData}̏W擾B<p>
     *
     * @return qvf&lt;attribute&gt;vf\AttributeMetaDatȁW
     */
    public List<AttributeMetaData> getAttributes(){
        return new ArrayList<AttributeMetaData>(attributes.values());
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;attribute&gt;vf̂ŁAw肳ꂽname̒l&lt;attribute&gt;vf\{@link AttributeMetaData}擾B<p>
     *
     * @param name qvf&lt;attribute&gt;vfname̒l
     * @return qvf&lt;attribute&gt;vf\AttributeMetaData
     */
    public AttributeMetaData getAttribute(String name){
        return attributes.get(name);
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;attribute&gt;vf\{@link AttributeMetaData}ǉB<p>
     *
     * @param attribute qvf&lt;attribute&gt;vf\AttributeMetaData
     */
    public void addAttribute(AttributeMetaData attribute){
        attributes.put(attribute.getName(), attribute);
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;attribute&gt;vf\{@link AttributeMetaData}폜B<p>
     *
     * @param name qvf&lt;attribute&gt;vfname̒l
     */
    public void removeAttribute(String name){
        attributes.remove(name);
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;attribute&gt;vf\{@link AttributeMetaData}폜B<p>
     */
    public void clearAttributes(){
        attributes.clear();
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;invoke&gt;vf\{@link InvokeMetaData}̏W擾B<p>
     *
     * @return qvf&lt;invoke&gt;vf\InvokeMetaDatȁW
     */
    public List<InvokeMetaData> getInvokes(){
        return invokes;
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;invoke&gt;vf\{@link InvokeMetaData}ǉB<p>
     *
     * @param invoke qvf&lt;invoke&gt;vf\InvokeMetaData
     */
    public void addInvoke(InvokeMetaData invoke){
        invokes.add(invoke);
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;invoke&gt;vf\{@link InvokeMetaData}폜B<p>
     *
     * @param invoke qvf&lt;invoke&gt;vf\InvokeMetaData
     */
    public void removeInvoke(InvokeMetaData invoke){
        invokes.remove(invoke);
    }
    
    /**
     * &lt;object&gt;vf̎qvf&lt;invoke&gt;vf\{@link InvokeMetaData}Sč폜B<p>
     */
    public void clearInvokes(){
        invokes.clear();
    }
    
    /**
     * vfobjectł鎖`FbNB<p>
     *
     * @param element objectvf
     * @exception DeploymentException vfobjectłȂꍇ
     */
    protected void checkTagName(Element element) throws DeploymentException{
        if(!element.getTagName().equals(OBJECT_TAG_NAME)){
            throw new DeploymentException(
                "Tag must be " + OBJECT_TAG_NAME + " : "
                 + element.getTagName()
            );
        }
    }
    
    /**
     * &lt;object&gt;vfElementp[XāAg̏Ayюqvf̃^f[^̐sB<p>
     *
     * @param element &lt;object&gt;vfElement
     * @exception DeploymentException &lt;object&gt;vf̉́Ǎʂɂ郁^f[^̐Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        super.importXML(element);
        
        checkTagName(element);
        
        code = getUniqueAttribute(element, CODE_ATTRIBUTE_NAME);
        if(code.length() == 0){
            throw new DeploymentException(
                "Element of " + element.getTagName() + " must have valid " + CODE_ATTRIBUTE_NAME + " attribute."
            );
        }
        
        importXMLInner(element, null);
        
        final Iterator<Element> ifDefElements = getChildrenByTagName(
            element,
            IfDefMetaData.IFDEF_TAG_NAME
        );
        while(ifDefElements.hasNext()){
            if(ifDefMetaDataList == null){
                ifDefMetaDataList = new ArrayList<IfDefMetaData>();
            }
            final IfDefMetaData ifdefData
                 = new IfDefMetaData(this);
            ifdefData.importXML((Element)ifDefElements.next());
            ifDefMetaDataList.add(ifdefData);
        }
        
        if(ifDefMetaDataList == null || ifDefMetaDataList.size() == 0){
            return;
        }
        
        for(int i = 0, imax = ifDefMetaDataList.size(); i < imax; i++){
            IfDefMetaData ifdefData = ifDefMetaDataList.get(i);
            Element ifDefElement = ifdefData.getElement();
            if(ifDefElement == null){
                continue;
            }
            
            importXMLInner(ifDefElement, ifdefData);
            
            ifdefData.setElement(null);
        }
    }
    
    protected void importXMLInner(Element element, IfDefMetaData ifdefData) throws DeploymentException{
        
        final boolean ifdefMatch
            = ifdefData == null ? true : ifdefData.isMatch();
        
        final Element constElement = getOptionalChild(
            element,
            ConstructorMetaData.CONSTRUCTOR_TAG_NAME
        );
        if(constElement != null){
            if(ifdefMatch && constructor != null){
                throw new DeploymentException("Element of " + ConstructorMetaData.CONSTRUCTOR_TAG_NAME + " is duplicated.");
            }
            final ConstructorMetaData constData = new ConstructorMetaData(this);
            if(ifdefData != null){
                constData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(constData);
            }
            constData.importXML(constElement);
            if(ifdefMatch){
                constructor = constData;
            }
        }
        
        final Iterator<Element> fieldElements = getChildrenByTagName(
            element,
            FieldMetaData.FIELD_TAG_NAME
        );
        while(fieldElements.hasNext()){
            final FieldMetaData fieldData
                 = new FieldMetaData(this);
            if(ifdefData != null){
                fieldData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(fieldData);
            }
            fieldData.importXML((Element)fieldElements.next());
            if(ifdefMatch){
                if(getField(fieldData.getName()) != null){
                    throw new DeploymentException("Element of " + FieldMetaData.FIELD_TAG_NAME + " is duplicated. name=" + fieldData.getName());
                }
                addField(fieldData);
            }
        }
        
        final Iterator<Element> attributeElements = getChildrenByTagName(
            element,
            AttributeMetaData.ATTRIBUTE_TAG_NAME
        );
        while(attributeElements.hasNext()){
            final AttributeMetaData attributeData
                 = new AttributeMetaData(this);
            if(ifdefData != null){
                attributeData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(attributeData);
            }
            attributeData.importXML((Element)attributeElements.next());
            if(ifdefMatch){
                if(getAttribute(attributeData.getName()) != null){
                    throw new DeploymentException("Element of " + AttributeMetaData.ATTRIBUTE_TAG_NAME + " is duplicated. name=" + attributeData.getName());
                }
                addAttribute(attributeData);
            }
        }
        
        final Iterator<Element> invokeElements = getChildrenByTagName(
            element,
            InvokeMetaData.INVOKE_TAG_NAME
        );
        while(invokeElements.hasNext()){
            final InvokeMetaData invokeData
                 = new InvokeMetaData(this);
            if(ifdefData != null){
                invokeData.setIfDefMetaData(ifdefData);
                ifdefData.addChild(invokeData);
            }
            invokeData.importXML((Element)invokeElements.next());
            if(invokeData.getTarget() != null){
                throw new DeploymentException(
                    "target element must not specified. : " + invokeData
                );
            }
            if(ifdefMatch){
                addInvoke(invokeData);
            }
        }
    }
    
    @Override
    public StringBuilder toXML(StringBuilder buf){
        appendComment(buf);
        buf.append('<').append(OBJECT_TAG_NAME);
        if(code != null){
            buf.append(' ').append(CODE_ATTRIBUTE_NAME)
                .append("=\"").append(code).append("\"");
        }
        if(constructor == null && fields.size() == 0
             && attributes.size() == 0 && invokes.size() == 0
             && (ifDefMetaDataList == null || ifDefMetaDataList.size() == 0)){
            buf.append("/>");
        }else{
            buf.append('>');
            if(constructor != null && constructor.getIfDefMetaData() == null){
                buf.append(LINE_SEPARATOR);
                buf.append(
                    addIndent(constructor.toXML(new StringBuilder()))
                );
            }
            if(fields.size() != 0){
                buf.append(LINE_SEPARATOR);
                Iterator<FieldMetaData> datas = fields.values().iterator();
                while(datas.hasNext()){
                    FieldMetaData data = datas.next();
                    if(data.getIfDefMetaData() != null){
                        continue;
                    }
                    buf.append(
                        addIndent(data.toXML(new StringBuilder()))
                    );
                    if(datas.hasNext()){
                        buf.append(LINE_SEPARATOR);
                    }
                }
            }
            if(attributes.size() != 0){
                buf.append(LINE_SEPARATOR);
                Iterator<AttributeMetaData> datas = attributes.values().iterator();
                while(datas.hasNext()){
                    AttributeMetaData data = datas.next();
                    if(data.getIfDefMetaData() != null){
                        continue;
                    }
                    buf.append(
                        addIndent(data.toXML(new StringBuilder()))
                    );
                    if(datas.hasNext()){
                        buf.append(LINE_SEPARATOR);
                    }
                }
            }
            if(invokes.size() != 0){
                buf.append(LINE_SEPARATOR);
                for(int i = 0, imax = invokes.size(); i < imax; i++){
                    InvokeMetaData data = invokes.get(i);
                    if(data.getIfDefMetaData() != null){
                        continue;
                    }
                    buf.append(
                        addIndent(data.toXML(new StringBuilder()))
                    );
                    if(i != imax - 1){
                        buf.append(LINE_SEPARATOR);
                    }
                }
            }
            buf.append(LINE_SEPARATOR);
            if(ifDefMetaDataList != null && ifDefMetaDataList.size() != 0){
                for(int i = 0, imax = ifDefMetaDataList.size(); i < imax; i++){
                    IfDefMetaData ifdefData = ifDefMetaDataList.get(i);
                    buf.append(
                        addIndent(ifdefData.toXML(new StringBuilder()))
                    );
                    buf.append(LINE_SEPARATOR);
                }
            }
            buf.append("</").append(OBJECT_TAG_NAME).append('>');
        }
        return buf;
    }
    
    /**
     * ̃CX^X̕𐶐B<p>
     *
     * @return ̃CX^X̕
     */
    @Override
    public Object clone(){
        ObjectMetaData clone = (ObjectMetaData)super.clone();
        clone.fields = new LinkedHashMap<String, FieldMetaData>(fields);
        clone.attributes = new LinkedHashMap<String, AttributeMetaData>(attributes);
        clone.invokes = new ArrayList<InvokeMetaData>(invokes);
        return clone;
    }
    
    /**
     * ̃CX^X̕\擾B<p>
     *
     * @return \
     */
    @Override
    public String toString(){
        final StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('{');
        buf.append(CODE_ATTRIBUTE_NAME);
        buf.append('=');
        buf.append(getCode());
        buf.append('}');
        return buf.toString();
    }
}
