/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

/**
 * T[rX݂ȂOB<p>
 * T[rXȂꍇthrow܂B<br>
 *
 * @author M.Takata
 */
public class ServiceNotFoundException extends RuntimeException{
    
    private static final long serialVersionUID = 6536031104339439001L;
    
    /**
     * }l[WB<p>
     */
    private final String managerName;
    
    /**
     * T[rXB<p>
     */
    private final String serviceName;
    
    /**
     * ȂT[rXOIuWFNg𐶐B<p>
     *
     * @param name ServiceNameIuWFNg
     */
    public ServiceNotFoundException(ServiceName name){
        this(
            name != null? name.getServiceManagerName() : null,
            name != null? name.getServiceName() : null
        );
    }
    
    /**
     * ȂT[rXOIuWFNg𐶐B<p>
     *
     * @param manager }l[W
     * @param service T[rX
     */
    public ServiceNotFoundException(String manager, String service){
        managerName = manager;
        serviceName = service;
    }
    
    /**
     * ȂT[rXo^ĂƎvĂ}l[W擾B<p>
     *
     * @return }l[W
     */
    public String getServiceManagerName(){
        return managerName;
    }
    
    /**
     * ȂT[rX擾B<p>
     *
     * @return T[rX
     */
    public String getServiceName(){
        return serviceName;
    }
    
    /**
     * bZ[W擾B<p>
     * bZ[WARXgN^ŖIɎw肳Ȃꍇ́AȂT[rXbZ[WԂB<br>
     * 
     * @return bZ[W
     */
    public String getMessage(){
        return managerName + '#' + serviceName;
    }
}