/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import org.w3c.dom.*;

/**
 * T[rXQƒ`&lt;service-ref&gt;vf^f[^B<p>
 * T[rX`t@C&lt;service-ref&gt;vfɋLqꂽei[郁^f[^ReiłB<p>
 *
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class ServiceRefMetaData extends ServiceNameMetaData
 implements Serializable{
    
    private static final long serialVersionUID = -5823860625416503269L;
    
    /**
     * &lt;service-ref&gt;vf̗vfB<p>
     */
    public static final String SERIVCE_REF_TAG_NAME = "service-ref";
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     */
    public ServiceRefMetaData(MetaData parent){
        this(parent, null);
    }
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     * @param manager T[rXo^{@link ServiceManager}̖O
     */
    public ServiceRefMetaData(MetaData parent, String manager){
        this(parent, manager, null);
    }
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     * @param manager T[rXo^{@link ServiceManager}̖O
     * @param service T[rX̖O
     */
    public ServiceRefMetaData(MetaData parent, String manager, String service){
        super(parent, SERIVCE_REF_TAG_NAME, manager, service);
    }
    
    /**
     * T[rX\vfElementp[XāAg̏sB<p>
     *
     * @param element T[rX\vfElement
     * @exception DeploymentException T[rX\vf̉͂Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        
        if(!element.getTagName().equals(SERIVCE_REF_TAG_NAME)){
            throw new DeploymentException(
                "Tag must be " + SERIVCE_REF_TAG_NAME + " : "
                 + element.getTagName()
            );
        }
        super.importXML(element);
    }
    
    /**
     * ̃CX^X̕\擾B<p>
     *
     * @return \
     */
    @Override
    public String toString(){
        final StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('{');
        if(managerName != null){
            buf.append(managerName);
        }
        buf.append('#');
        buf.append(serviceName);
        buf.append('}');
        return buf.toString();
    }
}