/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop;

import java.util.Map;

import jp.ossc.nimbus.core.*;

/**
 * {@link DefaultInterceptorChainFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see DefaultInterceptorChainFactoryService
 */
public interface DefaultInterceptorChainFactoryServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * {@link InterceptorChainFactory#getInterceptorChain(Object)}̈Ŏw肷L[ƂĐK\Lɂ邩ǂݒ肷B<p>
     * ftHgł́AfalseB<br>
     *
     * @param isEnable K\Lɂꍇtrue
     */
    public void setRegexEnabled(boolean isEnable);
    
    /**
     * {@link InterceptorChainFactory#getInterceptorChain(Object)}̈Ŏw肷L[ƂĐK\Lɂ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAK\Lɂ
     */
    public boolean isRegexEnabled();
    
    /**
     * K\rsꍇɎgp}b`tOݒ肷B<p>
     * AA{@link #isRegexEnabled()}truȅꍇ̂ݗLłB<br>
     * ftHǵA0B<br>
     *
     * @param flag }b`tO
     * @see java.util.regex.Pattern#CANON_EQ
     * @see java.util.regex.Pattern#CASE_INSENSITIVE
     * @see java.util.regex.Pattern#DOTALL
     * @see java.util.regex.Pattern#MULTILINE
     * @see java.util.regex.Pattern#UNICODE_CASE
     * @see java.util.regex.Pattern#UNIX_LINES
     */
    public void setRegexMatchFlag(int flag);
    
    /**
     * K\rsꍇɎgp}b`tO擾B<p>
     *
     * @return }b`tO
     */
    public int getRegexMatchFlag();
    
    /**
     * L[ɊY{@link InterceptorChainList}T[rXݒ肷B<p>
     *
     * @param mapping L[InterceptorChainListT[rX̃}bsOBL[=InterceptorChainListT[rXŕw肷
     */
    public void setInterceptorChainListMapping(Map<String, String> mapping);
    
    /**
     * L[ɊY{@link InterceptorChainList}T[rX擾B<p>
     *
     * @return L[InterceptorChainListT[rX̃}bsO
     */
    public Map<String, String> getInterceptorChainListMapping();
    
    /**
     * L[ɊY{@link Interceptor}T[rXݒ肷B<p>
     * L[ɊY{@link #setInterceptorChainListMapping(Map)}̐ݒ肪ꍇ́A炪D悳B<br>
     *
     * @param mapping L[InterceptorT[rX̃}bsOBL[=InterceptorT[rXŕw肷
     */
    public void setInterceptorMapping(Map<String, String> mapping);
    
    /**
     * L[ɊY{@link Interceptor}T[rX擾B<p>
     *
     * @return L[InterceptorT[rX̃}bsO
     */
    public Map<String, String> getInterceptorMapping();
    
    /**
     * {@link #getInterceptorChainListMapping()}ɊY{@link InterceptorChainList}T[rX̃}bsO݂ȂꍇɎgpInterceptorChainListT[rX̃T[rXݒ肷B<p>
     *
     * @param name InterceptorChainListT[rX̃T[rX
     */
    public void setDefaultInterceptorChainListServiceName(ServiceName name);
    
    /**
     * {@link #getInterceptorChainListMapping()}ɊY{@link InterceptorChainList}T[rX̃}bsO݂ȂꍇɎgpInterceptorChainListT[rX̃T[rX擾B<p>
     *
     * @return InterceptorChainListT[rX̃T[rX
     */
    public ServiceName getDefaultInterceptorChainListServiceName();
    
    /**
     * L[ɊY{@link Invoker}T[rXݒ肷B<p>
     *
     * @param mapping L[InvokerT[rX̃}bsOBL[=InvokerT[rXŕw肷
     */
    public void setInvokerMapping(Map<String, String> mapping);
    
    /**
     * L[ɊY{@link Invoker}T[rX擾B<p>
     *
     * @return L[InvokerT[rX̃}bsO
     */
    public Map<String, String> getInvokerMapping();
    
    /**
     * {@link #getInvokerMapping()}ɊY{@link Invoker}T[rX̃}bsO݂ȂꍇɎgpInvokerT[rX̃T[rXݒ肷B<p>
     * w肵Ȃꍇ́A{@link jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService MethodReflectionCallInvokerService}gpB<br>
     *
     * @param name InvokerT[rX̃T[rX
     */
    public void setDefaultInvokerServiceName(ServiceName name);
    
    /**
     * {@link #getInvokerMapping()}ɊY{@link Invoker}T[rX̃}bsO݂ȂꍇɎgpInvokerT[rX̃T[rX擾B<p>
     *
     * @return InvokerT[rX̃T[rX
     */
    public ServiceName getDefaultInvokerServiceName();
    
    /**
     * {@link InterceptorChainFactory#getInterceptorChain(Object)}̖߂lLbV{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rXݒ肷B<p>
     * {@link DefaultInterceptorChainFactoryService}{@link InterceptorChain}́A{@link DefaultThreadLocalInterceptorChain}Ȃ̂ŁAXbhPʂł̍ėp\łB<br>
     * ̑w肵Ȃꍇ́ALbVɖ񐶐B<br>
     *
     * @param name CacheMapT[rX̃T[rX
     */
    public void setInterceptorChainCacheMapServiceName(ServiceName name);
    
    /**
     * {@link InterceptorChainFactory#getInterceptorChain(Object)}̖߂lLbV{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rX擾B<p>
     *
     * @return CacheMapT[rX̃T[rX
     */
    public ServiceName getInterceptorChainCacheMapServiceName();
    
    /**
     * {@link InterceptorChain}̎NXƂāA{@link DefaultThreadLocalInterceptorChain}gp邩ǂݒ肷B<p>
     * falsȅꍇ́A{@link DefaultInterceptorChain}gpB
     *
     * @param isUse gpꍇtrue
     */
    public void setUseThreadLocalInterceptorChain(boolean isUse);
    
    /**
     * {@link InterceptorChain}̎NXƂāA{@link DefaultThreadLocalInterceptorChain}gp邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAgp
     */
    public boolean isUseThreadLocalInterceptorChain();
}